package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.apache.struts.util.LabelValueBean;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SegmentTimestampSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SegmentTimestampSelector {
    protected Collection<LabelValueBean> segTimestamps;
    protected int selectedSegmentID;
    
    public SegmentTimestampSelector() {
    	segTimestamps = new ArrayList<LabelValueBean>(10);
    }

    public void add(String label, int segmentID) {
    	segTimestamps.add( new LabelValueBean(label, String.valueOf(segmentID)) );
    	if ( segTimestamps.size() == 1) {
    		this.selectedSegmentID = segmentID;
    	}
    }
    
    public String getMatchingTimeStamp(String segmentID) {
    	for (Iterator<LabelValueBean> it = segTimestamps.iterator(); it.hasNext();) {
			LabelValueBean lvb = it.next();
			if ( lvb.getValue().equals(segmentID)) {
				String label = lvb.getLabel();
				int idx = label.indexOf(" - ");
				if ( idx == -1) {
					return label;
				}
				return label.substring(0, idx);
			}
		}
    	return null;
    }
    
	public Collection<LabelValueBean> getSegTimestamps() {
		return segTimestamps;
	}

	public int getSelectedSegmentID() {
		return selectedSegmentID;
	}

	public void setSelectedSegmentID(int selectedSegmentID) {
		this.selectedSegmentID = selectedSegmentID;
	}
}
