package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SingleScoreSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class SingleScoreSelector {
	Collection<LabelValueBean> scores;
	String selectedScore;

	public SingleScoreSelector(Map<String, String> scoreKeyNameMap) {
		scores = new ArrayList<LabelValueBean>(scoreKeyNameMap.size());
		for (Map.Entry<String, String> entry : scoreKeyNameMap.entrySet()) {
			String scoreKey = entry.getKey();
			String scoreName = entry.getValue();
			LabelValueBean lvb = new LabelValueBean(scoreName, scoreKey);
			scores.add(lvb);
		}
	}

	public Collection<LabelValueBean> getScores() {
		return scores;
	}

	public void setScores(Collection<LabelValueBean> scores) {
		this.scores = scores;
	}

	public String getSelectedScore() {
		return selectedScore;
	}

	public void setSelectedScore(String selectedScore) {
		this.selectedScore = selectedScore;
	}

}
