package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

/**
 * @author I. Burak Ozyurt
 * @version $Id: StringListSelector.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class StringListSelector {
	protected Collection<LabelValueBean> lvList;
	protected String selectedItem;
	
	public StringListSelector(String[] strArray) {
		lvList = new ArrayList<LabelValueBean>( strArray.length);
		for (int i = 0; i < strArray.length; i++) {
			lvList.add(new LabelValueBean(strArray[i], strArray[i]) );
			if ( selectedItem == null) {
				selectedItem = strArray[i];
			}
		}
	}
	
	public StringListSelector(List<String> strList) {
		lvList = new ArrayList<LabelValueBean>( strList.size());
		for(String item : strList) {
			lvList.add(new LabelValueBean(item, item) );
			if ( selectedItem == null) {
				selectedItem = item;
			}
		}
	}

	public Collection<LabelValueBean> getLvList() {
		return lvList;
	}

	public String getSelectedItem() {
		return selectedItem;
	}

	public void setSelectedItem(String selectedItem) {
		this.selectedItem = selectedItem;
	}
}
