package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import clinical.server.dao.DeriveddataDAO;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IDerivedImageDataService;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.query.PostgresSQLDialect;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.exception.BaseException;
import clinical.web.vo.DerivedDataInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DerivedImageDataServiceImpl.java,v 1.1 2008/02/06 01:44:31
 *          bozyurt Exp $
 */
public class DerivedImageDataServiceImpl extends AbstractServiceImpl implements
		IDerivedImageDataService {

	public DerivedImageDataServiceImpl(String dbID) throws BaseException {
		super(dbID);
	}

	public List<Deriveddata> addDerivedData(UserInfo ui,
			List<DerivedDataInfo> ddiList) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			List<Deriveddata> ddList = new ArrayList<Deriveddata>(ddiList
					.size());
			for (DerivedDataInfo ddi : ddiList) {
				Deriveddata dd = addDerivedDataRec(con, ui, ddi);
				ddList.add(dd);
			}
			con.commit();
			return ddList;
		} catch (Exception x) {
			handleErrorAndRollBack(con, "addDerivedData", x, true);
			return null;
		} finally {
			releaseConnection(con, ui);
		}
	}

	/**
	 * to be used within an enclosing transaction
	 *
	 * @param con
	 * @param ui
	 * @param ddiList
	 * @return
	 * @throws Exception
	 */
	public List<Deriveddata> addDerivedData(Connection con, UserInfo ui,
			List<DerivedDataInfo> ddiList) throws Exception {
		List<Deriveddata> ddList = new ArrayList<Deriveddata>(ddiList.size());
		for (DerivedDataInfo ddi : ddiList) {
			Deriveddata dd = addDerivedDataRec(con, ui, ddi);
			ddList.add(dd);
		}
		return ddList;
	}

	protected Deriveddata addDerivedDataRec(Connection con, UserInfo ui,
			DerivedDataInfo ddi) throws Exception {
		ISequenceHelper sequenceHelper = MinimalServiceFactory
				.getSequenceHelper(theDBID);

		DeriveddataDAO dao = DAOFactory.createDeriveddataDAO(theDBID);
		Databaseuser dbUser = getDatabaseUser(ui, Constants.USERCLASS_ADMIN);
		Assertion.assertNotNull(dbUser);

		Deriveddata dd = new Deriveddata();
		dd.setSubjectid(ddi.getSubjectID());
		if (ddi.getExperimentID() != null)
			dd.setNcExperimentUniqueid(new BigDecimal(ddi.getExperimentID()));
		if (ddi.getVisitID() != null)
			dd.setComponentid(new BigDecimal(ddi.getVisitID()));
		if (ddi.getSegmentID() != null)
			dd.setSegmentid(new BigDecimal(ddi.getSegmentID()));
		dd.setDatauri(ddi.getDataURI());
		dd.setIsraw(ddi.isRaw());
		dd.setIsbad(false);
		dd.setExtensionname("nc_deriveddata");
		dd.setOntologysource(Constants.DEFAULT_ONT_SRC);
		dd.setConceptid(Constants.DEFAULT_ONT_CONCEPT);

		dd.setOwner(dbUser.getUniqueid());
		dd.setModuser(dbUser.getUniqueid());
		dd.setModtime(new Date());
		BigDecimal uniqueid = sequenceHelper.getNextUID(con,
				Constants.DERIVED_DATA, "uniqueid");
		dd.setUniqueid(uniqueid);
		dd.setTableid(getTableID(ui, Constants.DERIVED_DATA));

		dao.insert(con, dd);
		return dd;
	}

	public List<Deriveddata> findDerivedData(UserInfo ui, String subjectID,
			Integer expID, Integer visitID, Integer segmentID) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			Assertion.assertNotNull(subjectID);
			DeriveddataDAO dao = DAOFactory.createDeriveddataDAO(theDBID);
			Deriveddata cr = new Deriveddata();
			cr.setSubjectid(subjectID);
			if (expID != null)
				cr.setNcExperimentUniqueid(new BigDecimal(expID));
			if (visitID != null)
				cr.setComponentid(new BigDecimal(visitID));
			if (segmentID != null)
				cr.setSegmentid(new BigDecimal(segmentID));

			List<Deriveddata> list = dao.find(con, cr);
			con.commit();
			return list;

		} catch (Exception x) {
			handleErrorAndRollBack(con, "findDerivedData", x, true);
			return null;
		} finally {
			releaseConnection(con, ui);
		}
	}

	public List<Deriveddata> findDerivedData(UserInfo ui, String subjectID,
			String expName, Integer visitID, Integer segmentID)
			throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(super.theDBID);
		Map<String, Experiment> expMap = dbCache.getExperimentMap(ui, false);
		Experiment exp = expMap.get(expName);
		if (exp == null)
			return new ArrayList<Deriveddata>(0);
		return findDerivedData(ui, subjectID, exp.getUniqueid().intValue(),
				visitID, segmentID);
	}

	public List<Deriveddata> findDerivedData(UserInfo ui, String subjectID,
			String expName, Integer visitID, Integer segmentID, String fileType)
			throws Exception {
		IDBCache dbCache = ServiceFactory.getDBCache(super.theDBID);
		Map<String, Experiment> expMap = dbCache.getExperimentMap(ui, false);
		Experiment exp = expMap.get(expName);
		if (exp == null)
			return new ArrayList<Deriveddata>(0);
		return findDerivedData(ui, subjectID, exp.getUniqueid().intValue(),
				visitID, segmentID, fileType);
	}

	public List<Deriveddata> findDerivedData(UserInfo ui, String subjectID,
			Integer expID, Integer visitID, Integer segmentID, String fileType)
			throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			Assertion.assertNotNull(subjectID);
			TSQLProcessor tsp = new TSQLProcessor(new PostgresSQLDialect());
			StringBuilder qb = new StringBuilder(256);

			qb
					.append("select d.* from Deriveddata as d where d.israw = false ");
			qb.append(" and d.subjectid = '").append(subjectID).append("'");
			if (expID != null) {
				qb.append(" and d.ncExperimentUniqueid = ").append(expID);
			}
			if (visitID != null) {
				qb.append(" and d.componentid = ").append(visitID);
			}
			if (segmentID != null) {
				qb.append(" and d.segmentid = ").append(segmentID);
			}
			if (fileType != null) {
				qb.append(" and endsWith(d.datauri,'").append(fileType)
						.append("')");
			}
			List<?> results = tsp.executeQuery(con, qb.toString());
			List<Deriveddata> ddList = new ArrayList<Deriveddata>(results
					.size());
			for (Object item : results)
				ddList.add((Deriveddata) item);

			return ddList;

		} catch (Exception x) {
			handleErrorAndRollBack(con, "findDerivedData", x, true);
			return null;
		} finally {
			releaseConnection(con, ui);
		}
	}

}
