package clinical.web.tags;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import clinical.web.Constants;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentFindTag.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class AssessmentFindTag extends TagSupport {
	private static final long serialVersionUID = -4229241723622462184L;
	protected String partialMatch = "false";
	protected String name;

	public AssessmentFindTag() {
	}

	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
		HttpSession session = req.getSession(false);
		if (session == null)
			return SKIP_BODY;
		// check if there is a user container in the session (set after login
		// only)
		Map<?, ?> asNameMap = (Map<?, ?>) session
				.getAttribute(Constants.ASSESSMENT_NAME_MAP);

		if (asNameMap == null)
			return SKIP_BODY;

		if (partialMatch.equalsIgnoreCase("false")
				|| partialMatch.equalsIgnoreCase("no")) {
			if (asNameMap.get(name) != null)
				return EVAL_BODY_INCLUDE;
			else
				return SKIP_BODY;
		} else {
			for (Iterator<?> iter = asNameMap.keySet().iterator(); iter
					.hasNext();) {
				String asName = (String) iter.next();
				if (asName.indexOf(name) != -1) {
					return EVAL_BODY_INCLUDE;
				}
			}
		}

		return SKIP_BODY;
	}

	public void setPartialMatch(String newPartialMatch) {
		this.partialMatch = newPartialMatch;
	}

	public void setName(String newName) {
		this.name = newName;
	}

}