package clinical.web.vo;

import java.io.Serializable;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ASValueKey.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ASValueKey implements Serializable{
	private static final long serialVersionUID = 1L;
	protected int asID;
	protected String asName;
	protected String scoreName;

	public ASValueKey(int asID, String asName,String scoreName) {
		super();
		this.asID = asID;
		this.asName = asName;
		this.scoreName = scoreName;
	}

	public int getAsID() {
		return asID;
	}

	public String getScoreName() {
		return scoreName;
	}


	public String toString() {
		StringBuilder buffer = new StringBuilder();
		buffer.append("ASValueKey::[");
		buffer.append("asID = ").append(asID);
		buffer.append(" scoreName = ").append(scoreName);
		buffer.append("]");
		return buffer.toString();
	}

	public String getAsName() {
		return asName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + asID;
		result = prime * result + ((asName == null) ? 0 : asName.hashCode());
		result = prime * result
				+ ((scoreName == null) ? 0 : scoreName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ASValueKey other = (ASValueKey) obj;
		if (asID != other.asID)
			return false;
		if (asName == null) {
			if (other.asName != null)
				return false;
		} else if (!asName.equals(other.asName))
			return false;
		if (scoreName == null) {
			if (other.scoreName != null)
				return false;
		} else if (!scoreName.equals(other.scoreName))
			return false;
		return true;
	}

}
