package clinical.web.vo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;
import clinical.utils.DateTimeUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentInfo.java 73 2009-06-05 21:58:05Z bozyurt $
 */
public class ExperimentInfo {
	protected String baseURI;
	protected ContactPerson contactPerson;
	protected List<LabelValueBean> contactPersonsLVBeans;
	protected String contactPersonValue;
	protected String description;
	protected int id;
	protected Date modTime;
	protected String name;
	protected String storageType;

	public ExperimentInfo() {}

	public ExperimentInfo(Experiment se) {
		this.name = se.getName();
		this.description = se.getDescription();
		this.id = se.getUniqueid().intValue();
		modTime = se.getModtime();
		this.baseURI = se.getBaseuri();
		this.storageType = se.getStoragetype();
	}

	public String getBaseURI() {
		return baseURI;
	}

	public ContactPerson getContactPerson() {
		return this.contactPerson;
	}

	public Collection<LabelValueBean> getContactPersonsLVBeans() {
		return contactPersonsLVBeans;
	}

	public String getContactPersonValue() {
		return this.contactPersonValue;
	}

	public String getDescription() {
		return this.description;
	}

	public int getId() {
		return id;
	}

	public String getModTime() {
		return DateTimeUtils.formatDate(modTime);
	}

	public String getName() {
		return this.name;
	}

	public void setBaseURI(String baseURI) {
		this.baseURI = baseURI;
	}

	public void setContactPerson(ContactPerson newContactPerson) {
		this.contactPerson = newContactPerson;
	}

	public void setContactPersonsLVBeans(List<ContactPerson> contactPersons) {
		contactPersonsLVBeans = new ArrayList<LabelValueBean>(contactPersons
				.size());
		for (ContactPerson cp : contactPersons) {
			contactPersonsLVBeans.add(new LabelValueBean(cp.getFullName(), String
					.valueOf(cp.getUniqueID())));
		}
	}

	public void setContactPersonValue(String newContactPersonValue) {
		this.contactPersonValue = newContactPersonValue;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public void setId(int newId) {
		this.id = newId;
	}

	public void setName(String newName) {
		this.name = newName;
	}

	public String getStorageType() {
		return storageType;
	}

	public void setStorageType(String storageType) {
		this.storageType = storageType;
	}

}