package clinical.web.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * value object holding score value information from multiple score value
 * entries and question information.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ReconScoreValueInfo.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ReconScoreValueInfo {
	protected List<ScoreValue> scoreValues = new ArrayList<ScoreValue>(2);
	protected String leadingText;
	protected String trailingText;
	protected String scoreName;
	protected int scoreOrder;
	protected int assessmentID;
	protected String assessmentName;
	protected boolean sorted;
	protected ScoreValue reconciledValue;
	protected boolean multiValued = false;
	protected String dataClassification = "";
	protected static Map<String, Integer> dataClassificationMap = null;
	protected static Map<Integer, String> invDataClassMap = null;

	public ReconScoreValueInfo(String scoreName) {
		this.scoreName = scoreName;
	}

	public ReconScoreValueInfo(String leadingText, String trailingText,
			String scoreName, int assessmentID, String assessmentName) {
		this.leadingText = leadingText;
		this.trailingText = trailingText;
		this.scoreName = scoreName;
		this.assessmentID = assessmentID;
		this.assessmentName = assessmentName;
	}

	public static synchronized boolean isDataClassificationMapPopulated() {
		return (dataClassificationMap != null && !dataClassificationMap
				.isEmpty());
	}

	public static synchronized void setDataClassificationMap(
			Map<String, Integer> map) {
		dataClassificationMap = map;
		invDataClassMap = new HashMap<Integer, String>(11);
		for (Map.Entry<String,Integer> entry : dataClassificationMap.entrySet()) {
			invDataClassMap.put(entry.getValue(), entry.getKey());
		}
	}

	public static synchronized int getDataClassificationID(String name) {
		Integer id = (Integer) dataClassificationMap.get(name);
		if (id == null)
			return -1;
		return id.intValue();
	}

	public static synchronized String getDataClassificationName(Integer id) {
		return (String) invDataClassMap.get(id);
	}

	public static String createKey(String scoreName, int scoreOrder) {
		StringBuffer buf = new StringBuffer();
		buf.append(scoreName).append('_').append(scoreOrder);
		return buf.toString();
	}

	public String getDataClassificationName(String id) {
		return getDataClassificationName(new Integer(id));
	}

	public void addScoreValue(ScoreValue sv) {
		scoreValues.add(sv);
	}

	public List<ScoreValue> getScoreValues() {
		if (!sorted) {
			Collections.sort(scoreValues, new Comparator<ScoreValue>() {
				public int compare(ScoreValue s1, ScoreValue s2) {
					return s1.getEntryID().compareTo(s2.getEntryID());
				}
			});
			sorted = true;
		}
		return scoreValues;
	}

	// ---------------------- setters --------------
	public void setLeadingText(String newLeadingText) {
		this.leadingText = newLeadingText;
	}

	public void setTrailingText(String newTrailingText) {
		this.trailingText = newTrailingText;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setAssessmentID(int newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setAssessmentName(String newAssessmentName) {
		this.assessmentName = newAssessmentName;
	}

	public void setDataClassification(String newDataClassification) {
		this.dataClassification = newDataClassification;
	}

	public void setScoreOrder(int newScoreOrder) {
		this.scoreOrder = newScoreOrder;
	}

	public String getQuestionText() {
		if (this.leadingText != null) {
			return leadingText;
		} else {
			return scoreName;
		}
	}

	public void setReconciledValue(ScoreValue newReconciledValue) {
		this.reconciledValue = newReconciledValue;
	}

	public void setMultiValued(boolean newMultiValued) {
		this.multiValued = newMultiValued;
	}

	// ---------------------- getters --------------
	public String getLeadingText() {
		return this.leadingText;
	}

	public String getTrailingText() {
		return this.trailingText;
	}

	public String getScoreName() {
		return this.scoreName;
	}

	public int getAssessmentID() {
		return this.assessmentID;
	}

	public String getAssessmentName() {
		return this.assessmentName;
	}

	public String getScoreType() {
		assert (!scoreValues.isEmpty());
		return scoreValues.get(0).getScoreType();
	}

	public String getDataClassification() {
		return this.dataClassification;
	}

	public int getScoreOrder() {
		return this.scoreOrder;
	}

	public boolean getMultiValued() {
		return this.multiValued;
	}

	public int getMaxEntryID() {
		int max = -1;
		assert (!scoreValues.isEmpty());
		for (Iterator<ScoreValue> iter = scoreValues.iterator(); iter.hasNext();) {
			ScoreValue sv = iter.next();
			if (sv.getEntryID().intValue() > max)
				max = sv.getEntryID().intValue();
		}
		return max;
	}

	public ScoreValue getFirstValue() {
		return scoreValues.get(0);
	}

	public ScoreValue getSecondValue() {
		return scoreValues.get(1);
	}

	public ScoreValue getReconciledValue() {
		// System.out.println("getReconciledValue():" + reconciledValue);
		if (getDataClassification() != null
				&& getDataClassification().trim().length() > 0) {
			int classificationIdx = getDataClassificationID(getDataClassification());
			reconciledValue.setClassification(new Integer(classificationIdx));
		} else {
			if (reconciledValue != null) {
				reconciledValue.setClassification(null);
			}
		}
		return this.reconciledValue;
	}

	public boolean equals(Object other) {
		if (other == null) {
			return false;
		}
		if (other == this) {
			return true;
		}
		if (!(other instanceof ReconScoreValueInfo)) {
			return false;
		}
		ReconScoreValueInfo that = (ReconScoreValueInfo) other;
		if ((leadingText != null && that.leadingText != null && leadingText
				.equals(that.leadingText))
				&& (trailingText != null && that.trailingText != null && trailingText
						.equals(that.trailingText))
				&& (scoreName != null && that.scoreName != null && scoreName
						.equals(that.scoreName))
				&& assessmentID == that.assessmentID
				&& (assessmentName != null && that.assessmentName != null && assessmentName
						.equals(that.assessmentName))) {
			return true;
		}
		return false;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(152);
		buf.append("ReconScoreValueInfo::[");
		buf.append("leadingText=").append(leadingText);
		buf.append(", trailingText=").append(trailingText);
		buf.append(", scoreName=").append(scoreName);
		buf.append(", assessmentID=").append(assessmentID);
		buf.append(", assessmentName=").append(assessmentName);
		buf.append(", dataClassification=").append(dataClassification);
		buf.append(']');
		return buf.toString();
	}

}
