package clinical.web.vo;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Expstudy;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Study.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class Study {
	protected int studyID = -1;
	protected int componentID;
	protected int experimentID;
	protected String subjectID;
	protected java.sql.Timestamp timeStamp;
	protected String name;
	protected String description;
	protected boolean isTimeInterval;
	protected float timeInterval;
	protected List<StudySegment> studySegments = new LinkedList<StudySegment>();
	protected boolean dirty = false;

	public Study() {
	}

	public Study(Expstudy es) {
		if (es.getStudyid() != null) {
			this.studyID = es.getStudyid().intValue();
		}
		this.componentID = es.getComponentid().intValue();
		this.experimentID = es.getExperimentid().intValue();
		this.subjectID = es.getSubjectid();
		this.timeStamp = es.getTimeStamp();
		this.name = es.getName();
		this.description = es.getDescription();
		if (es.getIstimeinterval() != null) {
			this.isTimeInterval = es.getIstimeinterval().booleanValue();
		}
		if (isTimeInterval) {
			this.timeInterval = es.getTimeinterval().floatValue();
		}
	}

	public Study(Study other) {
		this.studyID = other.studyID;
		this.componentID = other.componentID;
		this.experimentID = other.experimentID;
		this.subjectID = other.subjectID;
		this.timeStamp = other.timeStamp;
		this.name = other.name;
		this.description = other.description;
		this.isTimeInterval = other.isTimeInterval;
		this.timeInterval = other.timeInterval;
	}

	public Expstudy toExpStudy() {
		Expstudy es = new Expstudy();
		es.setStudyid(toBigDecimal(this.studyID));
		es.setComponentid(toBigDecimal(this.componentID));
		es.setExperimentid(toBigDecimal(this.experimentID));
		es.setSubjectid(this.subjectID);
		es.setTimeStamp(this.timeStamp);
		es.setName(this.name);
		es.setDescription(this.description);
		es.setIstimeinterval(new Boolean(isTimeInterval));
		if (isTimeInterval) {
			// for POSTGRES new Float(timeInterval) -> new Double(timeInterval)
			es.setTimeinterval(new Float(timeInterval));
		}
		return es;
	}

	public void setDirty(boolean newDirty) {
		this.dirty = newDirty;
	}

	public boolean isDirty() {
		return this.dirty;
	}

	public void addStudySegment(StudySegment ss) {
		studySegments.add(ss);
	}

	public List<StudySegment> getStudySegments() {
		return studySegments;
	}

	public StudySegment getStudySegment(int studyID) {
		for (Iterator<StudySegment> iter = studySegments.iterator(); iter
				.hasNext();) {
			StudySegment ss = iter.next();
			if (ss.getStudyID() == studyID) {
				return ss;
			}
		}
		return null;
	}

	public String getComponentIDAsString() {
		return String.valueOf(componentID);
	}

	public String getStudyIDAsString() {
		return String.valueOf(studyID);
	}

	private BigDecimal toBigDecimal(int value) {
		return new BigDecimal(String.valueOf(value));
	}

	public void setStudyID(int newStudyID) {
		this.studyID = newStudyID;
		setDirty(true);
	}

	public void setComponentID(int newComponentID) {
		this.componentID = newComponentID;
		for (Iterator<StudySegment> iter = studySegments.iterator(); iter
				.hasNext();) {
			StudySegment ss = iter.next();
			ss.setVisitID(newComponentID);
		}
		setDirty(true);
	}

	public void setExperimentID(int newExperimentID) {
		this.experimentID = newExperimentID;
		setDirty(true);
	}

	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
		setDirty(true);
	}

	public void setTimeStamp(java.sql.Timestamp newTimeStamp) {
		this.timeStamp = newTimeStamp;
		setDirty(true);
	}

	public void setName(String newName) {
		this.name = newName;
		setDirty(true);
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
		setDirty(true);
	}

	public void setIsTimeInterval(boolean newIsTimeInterval) {
		this.isTimeInterval = newIsTimeInterval;
		setDirty(true);
	}

	public void setTimeInterval(float newTimeInterval) {
		this.timeInterval = newTimeInterval;
		setDirty(true);
	}

	// ---------------------- getters --------------
	public int getStudyID() {
		return this.studyID;
	}

	public int getComponentID() {
		return this.componentID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public String getSubjectID() {
		return this.subjectID;
	}

	public java.sql.Timestamp getTimeStamp() {
		return this.timeStamp;
	}

	public String getName() {
		return this.name;
	}

	public String getDescription() {
		return this.description;
	}

	public boolean getIsTimeInterval() {
		return this.isTimeInterval;
	}

	public float getTimeInterval() {
		return this.timeInterval;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(272);
		buf.append("Study::[");
		buf.append("studyID=").append(studyID);
		buf.append(", componentID=").append(componentID);
		buf.append(", experimentID=").append(experimentID);
		buf.append(", subjectID=").append(subjectID);
		buf.append(", timeStamp=").append(timeStamp);
		buf.append(", name=").append(name);
		buf.append(", description=").append(description);
		buf.append(", isTimeInterval=").append(isTimeInterval);
		buf.append(", timeInterval=").append(timeInterval);
		for (Iterator<StudySegment> iter = studySegments.iterator(); iter
				.hasNext();) {
			StudySegment ss = iter.next();
			buf.append("\n\t").append(ss.toString());
		}
		buf.append(']');
		return buf.toString();
	}

}
