package clinical.web.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author I. Burak Ozyurt
 * @version $Id: VisitScoreValuesSummary.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class VisitScoreValuesSummary {
	private String subjectID;
	private int visitID;
	private Set<Integer> segmentIDSet = new HashSet<Integer>(3);
	private int experimentID;
	private String siteID;
	private Map<String, SubjectAsScoreValueSummary> map = new LinkedHashMap<String, SubjectAsScoreValueSummary>();

	public VisitScoreValuesSummary(String subjectID, int visitID,
			int experimentID, String siteID) {
		this.subjectID = subjectID;
		this.visitID = visitID;
		this.experimentID = experimentID;
		this.siteID = siteID;
	}

	public static String prepareKey(String subjectID, int visitID,
			int experimentID, String siteID) {
		StringBuffer buf = new StringBuffer(80);
		buf.append(subjectID).append('_').append(siteID).append('_');
		buf.append(experimentID).append('_').append(visitID);
		return buf.toString();
	}

	public void addScoreValueSummary(SubjectAsScoreValueSummary sasv) {
		assert (sasv.getExperimentID() == experimentID && sasv.getSiteID() == siteID);
		String key = prepareKey(sasv.getAssessmentID(), sasv.getScoreName());
		segmentIDSet.add(sasv.getSegmentID());
		map.put(key, sasv);
	}

	public SubjectAsScoreValueSummary get(String asID, String scoreName) {
		String key = prepareKey(asID, scoreName);
		return map.get(key);
	}

	public List<SubjectAsScoreValueSummary> getSubjectAsScoreValueSummaryList() {
		return new ArrayList<SubjectAsScoreValueSummary>(map.values());
	}

	public static String prepareKey(String asID, String scoreName) {
		StringBuffer buf = new StringBuffer();
		buf.append(asID).append('_').append(scoreName);
		return buf.toString();
	}

	public String getSubjectID() {
		return subjectID;
	}

	public int getVisitID() {
		return visitID;
	}

	public List<Integer> getSegmentIDList(boolean sorted) {
		List<Integer> sil = new ArrayList<Integer>(segmentIDSet);
		if (sorted) {
			Collections.sort(sil);
		}
		return sil;
	}

	public int getExperimentID() {
		return experimentID;
	}

	public String getSiteID() {
		return siteID;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + experimentID;
		result = prime * result + ((siteID == null) ? 0 : siteID.hashCode());
		result = prime * result
				+ ((subjectID == null) ? 0 : subjectID.hashCode());
		result = prime * result + visitID;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final VisitScoreValuesSummary other = (VisitScoreValuesSummary) obj;
		if (experimentID != other.experimentID)
			return false;
		if (siteID == null) {
			if (other.siteID != null)
				return false;
		} else if (!siteID.equals(other.siteID))
			return false;
		if (subjectID == null) {
			if (other.subjectID != null)
				return false;
		} else if (!subjectID.equals(other.subjectID))
			return false;
		if (visitID != other.visitID)
			return false;
		return true;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("VisitScoreValuesSummary::[");
		buf.append("subjectID=").append(subjectID);
		buf.append(", visitID=").append(visitID);
		buf.append(", experimentID=").append(experimentID);
		buf.append(", siteID=").append(siteID);
		buf.append(", segmentIDs=(");
		for(Integer segmentID : segmentIDSet) {
			buf.append(segmentID).append(',');
		}
		buf.append(')');
		buf.append(']');
		return buf.toString();
	}

}
