package clinical.web.vo;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Expsegment;
import clinical.utils.GenUtils;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.helpers.ScoreValuesDisplayHelper;
import clinical.web.helpers.ScoreValuesDisplayLayout;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitSegment.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class VisitSegment {
   protected int segmentID;
   protected int visitID;
   protected int experimentID;
   protected String subjectID;
   protected java.sql.Timestamp timeStamp;
   protected String description;
   protected int protocolVersion;
   protected String protocolID;
   protected CollectionEquipment equipment;
   protected String name = "";

   protected int studyID = -1;
   /** name of the study if this segment is associated with a study (optional) */
   protected String studyName = null;
   /**
    * holds a list of <code>clinical.web.vo.AssessmentInfo</code> objects for
    * the current subject
    */
   protected List<AssessmentInfo> assessmentInfos = new LinkedList<AssessmentInfo>();
   /**
    * holds a map of assessment name versus
    * <code>clinical.web.vo.AssessmentScoreValues</code> objects for the
    * current subject
    */
   protected Map<String, AssessmentScoreValues> asScoreValuesMap;
   protected int maxScoreNumber = -1;
   protected int currentAsIdx = 0;
   
   /** holds info to build and request image data to view */
   protected ImageSeriesDataInfo isdi;

   private Log log = LogFactory.getLog(VisitSegment.class);

   public VisitSegment() {}

   public VisitSegment(Expsegment seg) {
      segmentID = seg.getSegmentid().intValue();
      visitID = seg.getComponentid().intValue();
      experimentID = seg.getNcExperimentUniqueid().intValue();
      subjectID = seg.getSubjectid();
      timeStamp = seg.getTimeStamp();
      description = seg.getDescription();
      protocolVersion = seg.getProtocolversion().intValue();
      protocolID = seg.getProtocolid();
      name = seg.getName();
      if (seg.getStudyid() != null) {
         studyID = seg.getStudyid().intValue();
      }
   }

   public VisitSegment(VisitSegment other) {
      segmentID = other.getSegmentID();
      visitID = other.getVisitID();
      experimentID = other.getExperimentID();
      subjectID = other.getSubjectID();
      timeStamp = other.getTimeStamp();
      description = other.getDescription();
      protocolVersion = other.getProtocolVersion();
      protocolID = other.getProtocolID();
      name = other.getName();
      studyID = other.getStudyID();
      studyName = other.getStudyName();
   }

   // ---------------------- setters --------------
   public void setSegmentID(int newSegmentID) {
      this.segmentID = newSegmentID;
   }

   public void setVisitID(int newComponentid) {
      this.visitID = newComponentid;
   }

   public void setExperimentID(int newExperimentID) {
      this.experimentID = newExperimentID;
   }

   public void setSubjectID(String newSubjectID) {
      this.subjectID = newSubjectID;
   }

   public void setTimeStamp(java.sql.Timestamp newTimeStamp) {
      this.timeStamp = newTimeStamp;
   }

   public void setDescription(String newDescription) {
      this.description = newDescription;
   }

   public void setProtocolVersion(int newProtocolVersion) {
      this.protocolVersion = newProtocolVersion;
   }

   public void setProtocolID(String newProtocolID) {
      this.protocolID = newProtocolID;
   }

   public void setEquipment(CollectionEquipment newEquipment) {
      this.equipment = newEquipment;
   }

   public void setName(String newName) {
      this.name = newName;
   }

   public void setStudyID(int newStudyID) {
      this.studyID = newStudyID;
   }

   public void setStudyName(String newStudyName) {
      this.studyName = newStudyName;
   }

   // ---------------------- getters --------------
   public int getSegmentID() {
      return this.segmentID;
   }

   public int getVisitID() {
      return this.visitID;
   }

   public int getExperimentID() {
      return this.experimentID;
   }

   public String getSubjectID() {
      return this.subjectID;
   }

   public java.sql.Timestamp getTimeStamp() {
      return this.timeStamp;
   }

   public String getDescription() {
      return this.description;
   }

   public int getProtocolVersion() {
      return this.protocolVersion;
   }

   public String getProtocolID() {
      return this.protocolID;
   }

   public CollectionEquipment getEquipment() {
      return this.equipment;
   }

   public String getName() {
      return name;
   }

   public int getStudyID() {
      return this.studyID;
   }

   public String getStudyName() {
      return this.studyName;
   }

   public Expsegment toExpSegment() {
      Expsegment segment = new Expsegment();
      segment.setSegmentid(new BigDecimal(String.valueOf(segmentID)));
      segment.setComponentid(new BigDecimal(String.valueOf(visitID)));
      segment.setNcExperimentUniqueid(new BigDecimal(String
            .valueOf(experimentID)));
      segment.setSubjectid(subjectID);
      segment.setTimeStamp(timeStamp);
      segment.setDescription(description);
      segment
            .setProtocolversion(new BigDecimal(String.valueOf(protocolVersion)));
      segment.setProtocolid(protocolID);
      if (studyID >= 0) {
         segment.setStudyid(GenUtils.toBigDecimal(studyID));
      }
      segment.setName(name);

      return segment;
   }

   public String toString() {
      StringBuffer buf = new StringBuffer(200);
      buf.append("VisitSegment::[").append("segmentID=").append(segmentID);
      buf.append(",visitID=").append(visitID).append(",subjectID=").append(
            subjectID);
      buf.append(",experimentID=").append(experimentID).append(",timestamp=")
            .append(timeStamp);
      if (description != null)
         buf.append(",description=").append(description);
      if (name != null)
         buf.append(",name=").append(name);
      if (studyID >= 0)
         buf.append(",studyID=").append(studyID);
      buf.append(']');
      return buf.toString();
   }

   // for assessments associated with this segment

   public void resetAssessments() {
      currentAsIdx = 0;
   }

   public void setAsScoreValuesMap(List<AssessmentScoreValues> newAsvList) {
      asScoreValuesMap = new HashMap<String, AssessmentScoreValues>(17);
      for (AssessmentScoreValues asv : newAsvList) {

         String key = ScoreValuesDisplayHelper.createScoreValueMapKey(asv
               .getAssessmentName(), asv.getSegmentID(), asv.getVisitID());
         asScoreValuesMap.put(key, asv);
      }
   }

   public Map<String, AssessmentScoreValues> getScoreValuesMap() {
      return asScoreValuesMap;
   }

   public int findAndSetAssessmentInfos(List<AssessmentInfo> newAsiList) {
      for (AssessmentInfo asi : newAsiList) {
         if (asi.getVisitID() == visitID && asi.getSegmentID() == segmentID) {
            assessmentInfos.add(asi);
         }
      }
      return assessmentInfos.size();
   }

   public Collection<AssessmentInfo> getAssessmentInfos() {
      return assessmentInfos;
   }

   public ScoreValuesDisplayLayout getScoreValuesDisplayLayout() {
      try {
         if (assessmentInfos.isEmpty())
            return new ScoreValuesDisplayLayout();

         AssessmentInfo asi = assessmentInfos.get(currentAsIdx);

         String key = ScoreValuesDisplayHelper.createScoreValueMapKey(asi
               .getName(), this.segmentID, this.visitID);
         AssessmentScoreValues asv = asScoreValuesMap.get(key);
         ScoreValuesDisplayLayout svdl = new ScoreValuesDisplayLayout();
         ScoreValuesDisplayHelper.prepareScoreValuesLayoutForCA(asi, svdl, asv);

         // move to the next assessment
         ++currentAsIdx;

         return svdl;
      } catch (Throwable t) {
         log.error("", t);
         if (t instanceof RuntimeException)
            throw (RuntimeException) t;
         return null;
      }
   }

   public int getMaxScoreNumber() {
      if (maxScoreNumber < 0) {
         for (Iterator<AssessmentInfo> iter = assessmentInfos.iterator(); iter
               .hasNext();) {
            AssessmentInfo asi = iter.next();
            if (asi.getScores().size() > maxScoreNumber) {
               maxScoreNumber = asi.getScores().size();
            }
         }
      }
      return maxScoreNumber;
   }

   public String getRemainingColumnSize(int idx) {
      AssessmentInfo asi = assessmentInfos.get(idx);
      return String.valueOf(maxScoreNumber - asi.getScores().size());
   }

   public ImageSeriesDataInfo getIsdi() {
      return isdi;
   }

   public void setIsdi(ImageSeriesDataInfo isdi) {
      this.isdi = isdi;
   }
}
