package clinical.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

import clinical.utils.GenUtils;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ApplicationUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ApplicationUtils {
	static Properties props = null;

	private ApplicationUtils() {
	}

	public static synchronized String getProperty(String property)
			throws IOException {
		if (props == null) {
			props = GenUtils.loadProperties("clinical.properties");
		}
		return props.getProperty(property);
	}

	public static UserInfo authenticate(String webUser, String pwd, String dbID)
			throws BaseException {
		IAuthenticationService ia = ServiceFactory.getAuthenticationService();
		UserInfo ui = ia.authenticate(webUser, pwd, dbID);
		return ui;
	}

	public static String prepareErrorMessage(Throwable t) {
		StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw, true);
        t.printStackTrace(pw);
        StringBuilder sb = new StringBuilder(1024);
        if (t.getMessage() != null) {
        	sb.append(t.getMessage()).append("\n\n");
        }
        sb.append("Stack Trace:\n");
        sb.append(sw.toString());
        return sb.toString();
	}
}
