package clinical.xml;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.datatype.XMLGregorianCalendar;

import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: XMLUtils.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class XMLUtils {
	SimpleDateFormat tsFormat = new SimpleDateFormat("");
	private XMLUtils() {
	}

	public static void prettyPrint(String xmlDoc) throws IOException,
			JDOMException {
		prettyPrint(xmlDoc, new OutputStreamWriter(System.out));
	}

	public static void prettyPrint(String xmlDoc, Writer out)
			throws IOException, JDOMException {
		SAXBuilder builder = new SAXBuilder();
		StringReader reader = new StringReader(xmlDoc);
		Document doc = builder.build(reader);
		XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
		xout.output(doc.getRootElement(), out);
	}

	public static Date toDate(XMLGregorianCalendar cal) {
        return cal.toGregorianCalendar().getTime();
	}

}
