package clinical.xml.export;

import java.io.IOException;
import java.io.StringWriter;

import javax.jws.WebService;

import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.xml.ApplicationUtils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE1Service.java 62 2009-05-29 23:54:50Z bozyurt $
 */
 
@WebService(endpointInterface = "clinical.xml.export.XCEDE",
            serviceName="XCEDE1Service",
		    portName="xcede1Port")
public class XCEDE1Service implements XCEDE {

	public String exportExperimentData(String webUser, String pwd, int expID)
			throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		StringWriter out = new StringWriter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			se.exportExperiment(ui, expID, out);
			return out.toString();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new XCEDEFault(ex.getMessage());
		} catch (BaseException bex) {
			bex.printStackTrace();
			throw new XCEDEFault(bex.getMessage());
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}
	}

	public String exportSeriesData(String webUser, String pwd,
			String subjectID, int expID, int visitID, int studyID, int segmentID)
			throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		StringWriter out = new StringWriter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			se.exportSession(ui, subjectID, expID, visitID, studyID, segmentID,
					out);
			return out.toString();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new XCEDEFault(ex.getMessage());
		} catch (BaseException bex) {
			bex.printStackTrace();
			throw new XCEDEFault(bex.getMessage());
		}
	}

	public String exportStudyData(String webUser, String pwd, String subjectID,
			int expID, int visitID, int studyID) throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		StringWriter out = new StringWriter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			se.exportStudy(ui, subjectID, expID, visitID, studyID, out);
			return out.toString();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new XCEDEFault(ex.getMessage());
		} catch (BaseException bex) {
			bex.printStackTrace();
			throw new XCEDEFault(bex.getMessage());
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}

	}

	public String exportSubjectData(String webUser, String pwd,
			String subjectID, int expID) throws XCEDEFault {

		SeriesExporter se = new SeriesExporter();
		StringWriter out = new StringWriter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			se.exportSubject(ui, subjectID, expID, out);
			return out.toString();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new XCEDEFault(ex.getMessage());
		} catch (BaseException bex) {
			bex.printStackTrace();
			throw new XCEDEFault(bex.getMessage());
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}
	}

	public String exportVisitData(String webUser, String pwd, String subjectID,
			int expID, int visitID) throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		StringWriter out = new StringWriter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			se.exportVisit(ui, subjectID, expID, visitID, out);
			return out.toString();
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new XCEDEFault();
		} catch (BaseException bex) {
			bex.printStackTrace();
			throw new XCEDEFault();
		}
	}

	public int[] getAllExperimentIDs(String webUser, String pwd)
			throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			if (dbID == null) {
				throw new Exception(
						"Database ID as retrieved from the property fbirn.dbid was null!");
			}
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			return se.getAllExperimentIDs(ui);
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}
	}

	public String[] getAllSubjects(String webUser, String pwd, int expID)
			throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			return se.getExpSubjects(ui, expID);
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}
	}

	public String[] getExperimentNames(String webUser, String pwd, int[] expIDs)
			throws XCEDEFault {
		SeriesExporter se = new SeriesExporter();
		String dbID = null;
		try {
			dbID = ApplicationUtils.getProperty("fbirn.dbid");
			UserInfo ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			return se.getExperimentNames(ui, expIDs);
		} catch (Exception x) {
			x.printStackTrace();
			throw new XCEDEFault(x.getMessage());
		}
	}

}
