package clinical.xml.gui;

import guilib.common.BaseDialog;
import guilib.common.NameValueField;
import guilib.common.PasswordField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ParamsDialog.java 62 2009-05-29 23:54:50Z bozyurt $
 */
public class ParamsDialog extends BaseDialog {
	private static final long serialVersionUID = -2640128417607251519L;
	private ConfigInfo configInfo;
	private NameValueField endPointField;
	private NameValueField userField;
	private PasswordField pwdField;

	public ParamsDialog(Frame owner, String title, ConfigInfo configInfo) {
		super(owner, title, new String[] { "OK", "Cancel" });
		this.configInfo = configInfo;
		init();
		pack();
	}

	protected void init()
	{
		JPanel labelPanel = new JPanel(new GridLayout(3, 1, 3, 3));
		labelPanel.add(new JLabel("Web Service EndPoint:", JLabel.RIGHT));
		labelPanel.add(new JLabel("HID User:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Password:", JLabel.RIGHT));

		JPanel panel = new JPanel(new GridLayout(3, 1, 3, 3));
		endPointField = new NameValueField(null, 30);
		endPointField.setValue(configInfo.getEndPoint());
		panel.add(endPointField);
		userField = new NameValueField(null, 10);
		panel.add(userField);
		pwdField = new PasswordField(null, 10);
		panel.add(pwdField);

		JPanel paramPanel = new JPanel();
		BoxLayout bl = new BoxLayout(paramPanel, BoxLayout.X_AXIS);
		paramPanel.setLayout(bl);
		paramPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		paramPanel.add(labelPanel);
		paramPanel.add(panel);

		this.setDefaultButton("OK");

		getContentPane().add(paramPanel);
	}

	public ConfigInfo getConfigInfo()
	{
		return this.configInfo;
	}

	private boolean hasUserData(String value)
	{
		return (value != null && value.trim().length() > 0);
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				if (hasUserData(endPointField.getValue())) {
					configInfo.setEndPoint(endPointField.getValue());
				}
				configInfo.setUser(userField.getValue());
				configInfo.setPwd(pwdField.getValue());
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

}
