package clinical.xml.gui;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: XmlViewPane.java 62 2009-05-29 23:54:50Z bozyurt $
 */

public class XmlViewPane extends JPanel {

	private static final long serialVersionUID = 7732217082469542539L;
	private TitledBorder titledBorder;
	private JTextArea xmlArea = new JTextArea(25, 60);

	public XmlViewPane() {
		titledBorder = new TitledBorder("Received:");
		this.setBorder(titledBorder);
		xmlArea.setEditable(false);
		this.setLayout(new BorderLayout());
		this.add(new JScrollPane(xmlArea));
	}

	public void setXMLContent(String xmlStr)
	{
		String eol = System.getProperty("line.separator");
		xmlArea.setText(xmlStr + eol);
	}
}
