class AdminUtils {
   def db;
   def dbType;
   def dbu;

   void init(db, dbType, dbu) {
      this.db = db;
      this.dbType = dbType;
      this.dbu = dbu;
   }
      
   def getDataObjectTypes() {
      def dotDAO = prepDOT()
      return dotDAO.find()
   }

   def addDataObjectType(argMap) {
      def dotDAO = prepDOT()
      dotDAO.create(argMap)
   }
   
   def deleteDataObjectType(argMap) {
      def dotDAO = prepDOT()
      dotDAO.delete(argMap)
   }
   
   def updateDataObjectType(argMap) {
      def dotDAO = prepDOT()
      dotDAO.update(argMap)
   }

   private def prepDOT() {
      def dotDAO = new DataobjecttypeDAO(db: db)
      dotDAO.setDBType(dbType)
      dotDAO.setOwner(dbu)
      return dotDAO
   }


   def getRawdatas() {
      def rdDAO = prepRD()
      return rdDAO.find()
   }

   def getRawdatas(String wherePart) {
      def rdDAO = prepRD()
      return rdDAO.find(wherePart)
   }

   def addRawdata(argMap) {
      def rdDAO = prepRD()
      rdDAO.create(argMap)
   }

   
   private def prepRD() {
      def rdDAO = new RawdataDAO(db: db)
      rdDAO.setDBType(dbType)
      rdDAO.setOwner(dbu)
      return rdDAO
   }

   def addDataObject(argMap) {
      def doDAO = prepDO()
      doDAO.create(argMap)
   }
   
   def addUpdateDataObject(argMap) {
      def doDAO = prepDO()
      def list = doDAO.find('where dataid = ' + argMap.dataid + ' and objecttypeid = ' + argMap.objecttypeid);
      if (!list.isEmpty()) {
	 print "updating " + argMap 
	 doDAO.update(argMap)
      } else 
	 doDAO.create(argMap)
   }

   def getDataObjects(wherePart = null) {
      def doDAO = prepDO()
      if (wherePart != null)
	 return doDAO.find(wherePart)
       return doDAO.find()
   }

      

   private def prepDO() {
      def doDAO = new DataobjectDAO(db: db)
      doDAO.setDBType(dbType)
      doDAO.setOwner(dbu)
      return doDAO
   }

   def getExperiments() {
      def expDAO = new ExperimentDAO(db: db)
      expDAO.setDBType(dbType)
      expDAO.setOwner(dbu)
      return expDAO.find()
   }

   def getSizeFromSRB(String srbPath) {
      def proc = "Sls -l $srbPath".execute();
      def sizes = []
      proc.in.eachLine { line ->
         line = line.trim()
	 if (line.indexOf(' ') != -1 || line.indexOf('\t') != -1) {
	   def toks = line.split('\\s+');
	   if (toks.length > 4 && toks[1] == '0') {
	     sizes << toks[3]
	   }
	 }
      }
      long totSize = 0
      for(s in sizes) { totSize += new Long(s) }
      return totSize
   }

   
   
   def getFromSRB(String srbRootPath, verbose=true) {
      def proc = "Sls -r $srbRootPath".execute()
      def paths = [];
      def curDir = ''
      proc.in.eachLine { line ->
        line = line.trim()
	if (line.startsWith('C-')) {
	   line = line.substring(2)
	   paths << line
	   if (verbose) println line
	} else if (!line.endsWith(':')) {
	   if (verbose) println line
	   paths << "++" + line
	}
      }
      def fullPaths = []
      for (path in paths) {
	 if (! path.startsWith('++')) {
	    curDir = path
	    fullPaths << path
	 } else {
	    path = path.substring(2)
	    path = curDir + "/" + path
	    fullPaths << path
	 }
      }	    
      return fullPaths
   }

   def getFromLocal(String rootDir, verbose = false) {
      def paths = []
      new File(rootDir).eachFileRecurse { 
	 f -> paths << f.getAbsolutePath()
	 if (verbose) { println f }
      }
      return paths
   }
}
