package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Analysisflow;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AnalysisflowDAO implements clinical.server.dao.AnalysisflowDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AnalysisflowDAO() {
	}

	public void insert(Connection con, Analysisflow bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ANALYSISFLOW ");
			buf.append(" (ANALYSISID,COMPONENTID,PRIORCOMPONENTID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 3; ++i) {
				buf.append('?');
				if (i < 2)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getAnalysisid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getComponentid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getPriorcomponentid(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Analysisflow bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("ANALYSISID");
		buf.append(',');
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("PRIORCOMPONENTID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Analysisflow bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ANALYSISID=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getPriorcomponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PRIORCOMPONENTID=?");
			qi.values.add(bean.getPriorcomponentid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Analysisflow bean,
			Analysisflow criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ANALYSISFLOW SET ");

		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ANALYSISID=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getPriorcomponentid() != null
				|| bean.isNull("priorcomponentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PRIORCOMPONENTID=? ");
			uqi.setValues.add(bean.getPriorcomponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("priorcomponentid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Analysisflow createObject(ResultSet rs) throws SQLException {
		Analysisflow obj = new Analysisflow();
		obj.setAnalysisid((java.math.BigDecimal) rs.getObject(1));
		obj.setComponentid((java.math.BigDecimal) rs.getObject(2));
		obj.setPriorcomponentid((java.math.BigDecimal) rs.getObject(3));
		return obj;
	}

	public List<Analysisflow> find(Connection con, Analysisflow criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Analysisflow> results = new LinkedList<Analysisflow>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ANALYSISFLOW ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Analysisflow item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Analysisflow bean, Analysisflow criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Analysisflow criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ANALYSISFLOW ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
