package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Privileges;
import clinical.web.exception.ValidationException;

public class PrivilegesDAO implements clinical.server.dao.PrivilegesDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public PrivilegesDAO() {
	}

	public void insert(Connection con, Privileges bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_PRIVILEGES VALUES ");
			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getPrivid());
			ps.setObject(2, bean.getPrivilege());
			ps.setObject(3, bean.getOwner());
			ps.setObject(4, new java.sql.Date(bean.getModtime().getTime()));
			ps.setObject(5, bean.getModuser());
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Privileges bean) {
		StringBuffer buf = new StringBuffer(200);
		int idx = 0;
		buf.append("PRIVID");
		buf.append(',');
		buf.append("PRIVILEGE");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Privileges bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		String s = null;
		if (bean.getPrivid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PRIVID=?");
			qi.values.add(bean.getPrivid());
			valueSet = true;
		}
		if (bean.getPrivilege() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PRIVILEGE=?");
			qi.values.add(bean.getPrivilege());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Privileges bean,
			Privileges criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_PRIVILEGES SET ");
		String s = null;
		if (bean.getPrivid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("PRIVID=? ");
			uqi.setValues.add(bean.getPrivid());
			valueSet = true;
		}
		if (bean.getPrivilege() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("PRIVILEGE=? ");
			uqi.setValues.add(bean.getPrivilege());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	public Privileges createObject(ResultSet rs) throws SQLException {
		Privileges obj = new Privileges();
		obj.setPrivid((java.math.BigDecimal) rs.getObject(1));
		obj.setPrivilege((String) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		obj.setModtime((java.util.Date) rs.getObject(4));
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		return obj;
	}

	public List find(Connection con, Privileges criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List results = new LinkedList();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_PRIVILEGES ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Privileges item = createObject(rs);
				results.add(item);
			}
		} finally {
			if (rs != null)
				try {
					rs.close();
				} catch (Exception x) { /* ignore */
				}
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
		return results;
	}

	public void update(Connection con, Privileges bean, Privileges criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			for (Iterator it = uqi.setValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			// for where part
			for (Iterator it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public void delete(Connection con, Privileges criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_PRIVILEGES ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public static class QueryInfo {
		String whereClause;
		List values = new LinkedList();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List setValues = new LinkedList();
		List whereValues = new LinkedList();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
