package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Schemaversion;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class SchemaversionDAO implements clinical.server.dao.SchemaversionDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public SchemaversionDAO() {
	}

	public void insert(Connection con, Schemaversion bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_SCHEMAVERSION ");
			buf
					.append(" (MAJORVERSION,MINORVERSION,UPDATEVERSION,UPDATEFINISHED,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,RELEASEDATE,DESCRIPTION) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 11; ++i) {
				buf.append('?');
				if (i < 10)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getMajorversion(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getMinorversion(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getUpdateversion(),
					Types.NUMERIC);
			ps.setObject(4, boolean2Number((Boolean) bean.getUpdatefinished()),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(8, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(9, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setTimestamp(10, bean.getReleasedate() == null ? null
					: new java.sql.Timestamp(bean.getReleasedate().getTime()));
			ps.setObject(11, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Schemaversion bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("MAJORVERSION");
		buf.append(',');
		buf.append("MINORVERSION");
		buf.append(',');
		buf.append("UPDATEVERSION");
		buf.append(',');
		buf.append("UPDATEFINISHED");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("RELEASEDATE");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Schemaversion bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getMajorversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MAJORVERSION=?");
			qi.values.add(bean.getMajorversion());
			valueSet = true;
		}
		if (bean.getMinorversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MINORVERSION=?");
			qi.values.add(bean.getMinorversion());
			valueSet = true;
		}
		if (bean.getUpdateversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UPDATEVERSION=?");
			qi.values.add(bean.getUpdateversion());
			valueSet = true;
		}
		if (bean.getUpdatefinished() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UPDATEFINISHED=?");
			qi.values.add(boolean2Number((Boolean) bean.getUpdatefinished()));
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getReleasedate() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("RELEASEDATE=?");
			qi.values.add(new java.sql.Timestamp(bean.getReleasedate()
					.getTime()));
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Schemaversion bean,
			Schemaversion criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_SCHEMAVERSION SET ");

		if (bean.getMajorversion() != null || bean.isNull("majorversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MAJORVERSION=? ");
			uqi.setValues.add(bean.getMajorversion());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("majorversion"), uqi);
			valueSet = true;
		}
		if (bean.getMinorversion() != null || bean.isNull("minorversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MINORVERSION=? ");
			uqi.setValues.add(bean.getMinorversion());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("minorversion"), uqi);
			valueSet = true;
		}
		if (bean.getUpdateversion() != null || bean.isNull("updateversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UPDATEVERSION=? ");
			uqi.setValues.add(bean.getUpdateversion());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("updateversion"), uqi);
			valueSet = true;
		}
		if (bean.getUpdatefinished() != null || bean.isNull("updatefinished")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UPDATEFINISHED=? ");
			uqi.setValues
					.add(boolean2Number((Boolean) bean.getUpdatefinished()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("updatefinished"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getReleasedate() != null || bean.isNull("releasedate")) {
			if (valueSet)
				buf.append(", ");
			buf.append("RELEASEDATE=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getReleasedate()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("releasedate"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Schemaversion createObject(ResultSet rs) throws SQLException {
		Schemaversion obj = new Schemaversion();
		obj.setMajorversion((java.math.BigDecimal) rs.getObject(1));
		obj.setMinorversion((java.math.BigDecimal) rs.getObject(2));
		obj.setUpdateversion((java.math.BigDecimal) rs.getObject(3));
		obj.setUpdatefinished(convert2Boolean(rs.getObject(4)));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(5));
		obj.setTableid((java.math.BigDecimal) rs.getObject(6));
		obj.setOwner((java.math.BigDecimal) rs.getObject(7));
		if (rs.getTimestamp(8) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(8).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(9));
		if (rs.getTimestamp(10) != null) {
			obj
					.setReleasedate(new java.util.Date(rs.getTimestamp(10)
							.getTime()));
		}
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(11)));
		return obj;
	}

	public List<Schemaversion> find(Connection con, Schemaversion criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Schemaversion> results = new LinkedList<Schemaversion>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_SCHEMAVERSION ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Schemaversion item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Schemaversion bean,
			Schemaversion criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Schemaversion criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_SCHEMAVERSION ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
