package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Usedargument;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class UsedargumentDAO implements clinical.server.dao.UsedargumentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public UsedargumentDAO() {
	}

	public void insert(Connection con, Usedargument bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_USEDARGUMENT ");
			buf
					.append(" (TABLEID,OWNER,MODTIME,MODUSER,NC_EXECUTEDTRANSFORM_UNIQUEID,TRANSFORMATIONARGID,TEXTVALUE,UNIQUEID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 8; ++i) {
				buf.append('?');
				if (i < 7)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(3, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(4, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean
					.getNcExecutedtransformUniqueid(), Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean
					.getTransformationargid(), Types.NUMERIC);
			ps.setObject(7, (String) bean.getTextvalue(), Types.VARCHAR);
			ps.setObject(8, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Usedargument bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("NC_EXECUTEDTRANSFORM_UNIQUEID");
		buf.append(',');
		buf.append("TRANSFORMATIONARGID");
		buf.append(',');
		buf.append("TEXTVALUE");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Usedargument bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getNcExecutedtransformUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_EXECUTEDTRANSFORM_UNIQUEID=?");
			qi.values.add(bean.getNcExecutedtransformUniqueid());
			valueSet = true;
		}
		if (bean.getTransformationargid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TRANSFORMATIONARGID=?");
			qi.values.add(bean.getTransformationargid());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TEXTVALUE=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Usedargument bean,
			Usedargument criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_USEDARGUMENT SET ");

		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getNcExecutedtransformUniqueid() != null
				|| bean.isNull("ncExecutedtransformUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_EXECUTEDTRANSFORM_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcExecutedtransformUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncExecutedtransformUniqueid"),
					uqi);
			valueSet = true;
		}
		if (bean.getTransformationargid() != null
				|| bean.isNull("transformationargid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TRANSFORMATIONARGID=? ");
			uqi.setValues.add(bean.getTransformationargid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("transformationargid"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TEXTVALUE=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Usedargument createObject(ResultSet rs) throws SQLException {
		Usedargument obj = new Usedargument();
		obj.setTableid((java.math.BigDecimal) rs.getObject(1));
		obj.setOwner((java.math.BigDecimal) rs.getObject(2));
		if (rs.getTimestamp(3) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(3).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(4));
		obj.setNcExecutedtransformUniqueid((java.math.BigDecimal) rs
				.getObject(5));
		obj.setTransformationargid((java.math.BigDecimal) rs.getObject(6));
		obj.setTextvalue((String) rs.getObject(7));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(8));
		return obj;
	}

	public List<Usedargument> find(Connection con, Usedargument criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Usedargument> results = new LinkedList<Usedargument>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_USEDARGUMENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Usedargument item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Usedargument bean, Usedargument criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Usedargument criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_USEDARGUMENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
