package clinical.web.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Site;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.StatisticsForm;
import clinical.web.helpers.DescriptiveStats;
import clinical.web.helpers.StatsHelper;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DataExplorationAction.java,v 1.1 2007/04/12 20:14:38 bozyurt
 *          Exp $
 */
public class DataExplorationAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);

	private Log log = LogFactory.getLog(DataExplorationAction.class);

	public DataExplorationAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.stats.univarstats", "doUnivariateStats");
		map.put("button.stats.bivarstats", "doBivariateStats");
		map.put("button.stats.change", "changeStatsOption");
		map.put("button.stats.return", "toStatsInput");

		return map;
	}

	public ActionForward toStatsInput(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> toStatsInput");
		try {
			// just verify user and forward to Constants.STATS_CHANGE page
			getUserInfo(request);

			return mapping.findForward(Constants.STATS_CHANGE);
		} catch (Exception x) {
			log.error("toStatsInput", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward changeStatsOption(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> changeStatsOption");
		try {
			// just verify user and forward to Constants.STATS_CHANGE page
			getUserInfo(request);

			return mapping.findForward(Constants.STATS_CHANGE);
		} catch (Exception x) {
			log.error("changeStatsOption", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward doBivariateStats(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> doBivariateStats");
		try {
			UserInfo ui = getUserInfo(request);
			StatisticsForm statsForm = (StatisticsForm) form;
			HttpSession session = request.getSession(false);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Site> sites = dbCache.getSites(ui, false);
			Map<String,String> siteNameMap = new HashMap<String, String>(17);
			for(Site site : sites) {
				siteNameMap.put(site.getSiteid(), site.getSitename());
			}

			String imagesDir = (String) session.getServletContext()
					.getAttribute(Constants.MRI_JPEGS_DIR_KEY);
			imagesDir = session.getServletContext().getRealPath(imagesDir);
			log.info("imagesDir=" + imagesDir);

			if (statsForm.isPlotOLS()) {
				StatsHelper.plotBivariateOLSChart(queryForm, statsForm,
						imagesDir, siteNameMap);
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("doBivariateStats", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward doUnivariateStats(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> doUnivariateStats");
		try {

			getUserInfo(request);
			StatisticsForm statsForm = (StatisticsForm) form;

			HttpSession session = request.getSession(false);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);


			IAppConfigService configService = ServiceFactory.getAppConfigService();

			String imagesDir = (String) session.getServletContext()
					.getAttribute(Constants.MRI_JPEGS_DIR_KEY);
			imagesDir = session.getServletContext().getRealPath(imagesDir);
			log.info("imagesDir=" + imagesDir);

			String localTempDir = configService.getParamValue(Constants.TEMP_FILES_LOCATION);
			log.info("localTempDir=" + localTempDir);
			if (localTempDir != null &&  new File(localTempDir).isDirectory()) {
				String tempFile = GenUtils.createTempFileName(localTempDir,
						".dat");

				String infoFile = GenUtils.getBasePart(tempFile) + ".info";
				log.info("data File: " + tempFile);
				log.info("info file: " + infoFile);
				FileOutputStream out = null;
				try {
					out = new FileOutputStream(tempFile);
					StatsHelper.prepareAndWriteSRBCVSFile(queryForm, out);
				} finally {
					FileUtils.close(out);

				}
				StatsHelper.prepareAndWriteInfoFile(queryForm, infoFile, ',');

				/** @todo execute univariate-r script */
				/*
				 * String xmlStr =
				 * StatsHelper.executeUnivariateStatsScript(appProps, queryForm,
				 * statsForm, tempFile);
				 * StatsHelper.updateStatsFormFromXML(xmlStr, statsForm);
				 */
			}
			if (statsForm.isMsd()) {
				List<DescriptiveStats> descStatsList = StatsHelper.prepDescriptiveStats(
						queryForm, statsForm);
				statsForm.setDescStatsList(descStatsList);
			}

			if (statsForm.isPlotBarGraph()) {
				StatsHelper.plotUnivariateBarChart(queryForm, statsForm,
						imagesDir);
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("doUnivariateStats", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

}
