package clinical.web.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
//import clinical.web.IAssessmentService;
import clinical.web.SRBUtils;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.ARValueKey;
import clinical.web.common.vo.AnalysisResultSummary;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.common.vo.VisitSegAnalysisResultValues;
import clinical.web.common.vo.VisitSegmentScoreValues;
import clinical.web.download.SubjectImageDataBundle;
//import clinical.web.exception.BaseException;
//import clinical.web.exception.ExpiredSessionException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.BatchQueryForm;
import clinical.web.forms.ShoppingCartForm;
import clinical.web.forms.StatisticsForm;
import clinical.web.helpers.BatchQueryHelper;
import clinical.web.helpers.CombinedScoreSelector;
import clinical.web.helpers.HeaderInfo;
import clinical.web.helpers.ScoreValueSummary;
import clinical.web.helpers.ScoresSelector;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.helpers.SingleScoreSelector;
import clinical.web.helpers.StatsHelper;
import clinical.web.helpers.StatsOptionSelector;
//import clinical.web.services.BatchQueryResult;
import clinical.web.services.IDownloadJobService;
import clinical.web.vo.ASValueKey;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.ExpSubjectsIDBInfo;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.ScoreMetaData;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.VisitSegAsResultValues;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SVNavigateAction.java,v 1.23.2.2 2008/07/30 01:15:32 bozyurt
 *          Exp $
 */

public class SVNavigateAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(SVNavigateAction.class);

	public SVNavigateAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.next", "nextWindow");
		map.put("button.prev", "prevWindow");
		map.put("button.pageAt", "pageAt");
		map.put("button.csv", "dumpCSV");
		map.put("button.stats", "dumpCSVToSRB");
		map.put("button.show.stats.input", "showStatsInput");
		map.put("button.batch.query", "showBatchQueryForm");
		map.put("button.sc.view", "viewCart");
		map.put("button.sc.showbatch", "showBatchImageDownloadPage");
		return map;
	}

	public ActionForward prevWindow(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			HttpSession session = request.getSession(false);
			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);

			uc.getUserInfo();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();
			if (log.isDebugEnabled())
				log.debug("*** ASQUERYACTION state=" + state);
			// SearchResultsIterator srit = queryForm.getSearchResultsIterator();
			SearchResultsIterator srit = queryForm.getQsSearchResultsIter();
			srit.moveToPrevWindow();
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward nextWindow(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			HttpSession session = request.getSession(false);
			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);

			uc.getUserInfo();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();
			if (log.isDebugEnabled())
				log.debug("*** ASQUERYACTION state=" + state);
			// SearchResultsIterator srit = queryForm.getSearchResultsIterator();
			SearchResultsIterator srit = queryForm.getQsSearchResultsIter();
			
			srit.moveToNextWindow();
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward pageAt(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			HttpSession session = request.getSession(false);
			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);

			uc.getUserInfo();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			String state = queryForm.getState();
			if (log.isDebugEnabled())
				log.debug("*** ASQUERYACTION state=" + state);

			// SearchResultsIterator srit = queryForm.getSearchResultsIterator();
			SearchResultsIterator srit = queryForm.getQsSearchResultsIter();

			Number pageNum = GenUtils.toNumber(request.getParameter("page"));

			if (pageNum != null) {
				log.info("page=" + pageNum.intValue());
				srit.moveToWindowAt(pageNum.intValue());
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward dumpCSV(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			String formatOption = request.getParameter("formatOption");
			String contentOption = request.getParameter("contentOption");
			log.info("formatOption=" + formatOption + "\ncontentOption="
					+ contentOption);
			response.setContentType("application/octet-stream");
			// as of RFC 2183
			response.setHeader("Content-Disposition",
					"attachment; filename=results.csv;");
			HttpSession session = request.getSession(false);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);

			try {
//				prepareAndWriteCVSFile2(queryForm, response.getOutputStream(),
//						formatOption, contentOption);//Jinran commented
				
				//Jinran added. Change output format for 'Export CSV'
				String longFormat = null;
				if(formatOption.equals("segment")){
					longFormat="wide";					
				}else if(formatOption.equals("visit")){
					longFormat="wider";
				}else if(formatOption.equals("long")){
					longFormat="long";
				}
				prepareAndWriteCSV(response.getOutputStream(), request, queryForm, longFormat);
				
			} finally {
				FileUtils.close(response.getOutputStream());
			}
			return null;
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	/**
	 * @deprecated
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	public ActionForward dumpCSVToSRB(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);

			HttpSession session = request.getSession(false);

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);

			String localTempDir = configService
					.getParamValue(Constants.TEMP_FILES_LOCATION);
			log.debug("localTempDir=" + localTempDir);
			String tempFile = GenUtils.createTempFileName(localTempDir, ".dat");
			String infoFile = GenUtils.getBasePart(tempFile) + ".info";
			FileOutputStream out = null;
			try {
				out = new FileOutputStream(tempFile);
				prepareAndWriteSRBCVSFile(queryForm, out);
			} finally {
				FileUtils.close(out);
			}
			prepareAndWriteInfoFile(queryForm, infoFile, ',');
			//
			String srbCollection = configService
					.getParamValue(Constants.SRB_TEMP_COLLECTION);
			SRBUtils.saveFilesForStats(srbCollection, tempFile, infoFile,
					configService);
			// remove the local temp files
			new File(tempFile).delete();
			new File(infoFile).delete();

			/*
			 * jargon behaves funky while trying to save a file sometimes
			 * SRBUtils.srbPut(tempFile, userInfoFile, srbCollection);
			 * SRBUtils.srbPut(infoFile, userInfoFile, srbCollection);
			 */
			String srbLoc = srbCollection;
			if (srbLoc.endsWith("/"))
				srbLoc += new File(tempFile).getName();
			else
				srbLoc += "/" + new File(tempFile).getName();
			StringBuffer portalURL = new StringBuffer(128);
			portalURL.append(configService.getParamValue(Constants.PORTAL_URL));
			portalURL.append(configService
					.getParamValue(Constants.PORTAL_STAT_SRB_LOCATION));
			if (!portalURL.toString().endsWith("/"))
				portalURL.append('/');
			portalURL.append(queryForm.getSelectedStatPage());
			portalURL.append("?dataFile=");
			portalURL.append(java.net.URLEncoder.encode(srbLoc, "UTF-8"));

			queryForm.setStatPageURL(portalURL.toString());

			return mapping.findForward("stats");
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void prepareAndWriteInfoFile(AsQueryBuilderForm queryForm,
			String filename, char sepChar) throws IOException {
		StringBuffer infoBuf = new StringBuffer(256);
		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID").append(sepChar);
		infoBuf.append("NA").append(sepChar);

		// site ID
		buf.append("SiteID").append(sepChar);
		infoBuf.append("DS").append(sepChar);

		for (Iterator<HeaderInfo> iter = queryForm.getHeaders().iterator(); iter
				.hasNext();) {
			HeaderInfo hi = iter.next();
			for (Iterator<String> it = hi.getSubHeaders().iterator(); it
					.hasNext();) {
				String subHeader = it.next();
				subHeader = subHeader.replace(' ', '_');
				String variableName = hi.getTitle().replace(' ', '_') + "_"
						+ subHeader;
				buf.append(variableName);
				if (it.hasNext())
					buf.append(sepChar);
			}
			if (iter.hasNext())
				buf.append(sepChar);
		}

		// prepare data type line
		for (Iterator<HeaderInfo> iter = queryForm.getHeaders().iterator(); iter
				.hasNext();) {
			HeaderInfo hi = iter.next();
			for (Iterator<String> it = hi.getDataTypes().iterator(); it
					.hasNext();) {
				String subHeaderDataType = it.next();
				infoBuf.append(subHeaderDataType);
				if (it.hasNext())
					infoBuf.append(sepChar);
			}
			if (iter.hasNext())
				infoBuf.append(sepChar);
		}

		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(filename), 4096);
			out.write(buf.toString());
			out.write('\n');
			out.write(infoBuf.toString());
			out.write('\n');
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (Exception x) {
				}
		}
	}

	protected void prepareAndWriteCVSFile2(AsQueryBuilderForm queryForm,
			OutputStream outStream, String formatOption, String contentOption)
			throws IOException {
		List<QuerySummary> qsList = queryForm.getQsList();
		Header header = prepHeaderLine(qsList, formatOption, contentOption);
		BufferedWriter out = null;
		out = new BufferedWriter(new OutputStreamWriter(outStream), 4096);
		// write header
		out.write(header.line);
		out.write('\n');
		List<String[]> queryResultRows = new LinkedList<String[]>();
		for (QuerySummary qs : qsList) {
			if (formatOption.equals("segment")) {
				handleSegmentRows(header, queryResultRows, qs, contentOption);
			} else if(formatOption.equals("visit")){
				handleVisitRows(header, queryResultRows, qs, contentOption);
			}else if(formatOption.equals("long")){
				
			}
		}
		writeQueryResultRows(out, queryResultRows);

	}
	
	/*
	 * Jinran added. To export CSV file in different formats: long, wide, wider in consistent with Batch Query 
	 */
	protected void prepareAndWriteCSV(OutputStream outStream, HttpServletRequest request,
			AsQueryBuilderForm queryForm, String longFormat){
		try{
			BufferedWriter out = null;
			out = new BufferedWriter(new OutputStreamWriter(outStream), 4096);
			List<QuerySummary> qsList = queryForm.getQsList();
			Assertion.assertNotNull(qsList);
			BatchQueryHelper.prepareCSV(out, qsList, longFormat);
		}
		catch(Exception e){
			return;
		}	
	}
	

	protected void handleVisitRows(Header header,
			List<String[]> queryResultRows, QuerySummary qs, String contentOption) {
		boolean includeDD = !contentOption.equals("none");
		if (qs.getArs() != null) {
			AssessmentResultSummary ars = qs.getArs();
			// group by visit id;
			Map<VisitSiteKey, List<VisitSegAsResultValues>> visitMap = new HashMap<VisitSiteKey, List<VisitSegAsResultValues>>(
					7);
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				VisitSiteKey vsKey = new VisitSiteKey(vsarv.getVisitID(), vsarv
						.getSiteID());
				List<VisitSegAsResultValues> list = visitMap.get(vsKey);
				if (list == null) {
					list = new ArrayList<VisitSegAsResultValues>(5);
					visitMap.put(vsKey, list);
				}
				list.add(vsarv);
			}
			for (VisitSiteKey vsKey : visitMap.keySet()) {
				String[] row = new String[header.offset
						+ header.indexMap.size()];
				row[0] = ars.getSubjectID();
				row[1] = vsKey.siteID;
				row[2] = ars.getExpName();
				row[3] = String.valueOf(vsKey.visitID);
				List<VisitSegAsResultValues> list = visitMap.get(vsKey);
				for (VisitSegAsResultValues vsarv : list) {
					handleAssessmentPartsOfRow(header, vsarv, row, true);
					if (includeDD && qs.getDdrs() != null) {
						AnalysisResultSummary ddrs = qs.getDdrs();
						handleDDPartsOfRow(header, vsarv, row, ddrs, true);
					}
				}
				queryResultRows.add(row);
			}
		} else if (includeDD && qs.getDdrs() != null) {
			AnalysisResultSummary ddrs = qs.getDdrs();
			Map<VisitSiteKey, List<VisitSegAnalysisResultValues>> visitMap = new HashMap<VisitSiteKey, List<VisitSegAnalysisResultValues>>(
					7);
			for (VisitSegAnalysisResultValues vsarv : ddrs.getVsarvList()) {
				VisitSiteKey vsKey = new VisitSiteKey(vsarv.getVisitID(), vsarv
						.getSiteID());
				List<VisitSegAnalysisResultValues> list = visitMap.get(vsKey);
				if (list == null) {
					list = new ArrayList<VisitSegAnalysisResultValues>(5);
					visitMap.put(vsKey, list);
				}
				list.add(vsarv);
			}
			for (VisitSiteKey vsKey : visitMap.keySet()) {
				String[] row = new String[header.offset
						+ header.indexMap.size()];
				row[0] = ddrs.getSubjectID();
				row[1] = vsKey.siteID;
				row[2] = ddrs.getExpName();
				row[3] = String.valueOf(vsKey.visitID);
				List<VisitSegAnalysisResultValues> list = visitMap.get(vsKey);
				for (VisitSegAnalysisResultValues vsarv : list) {
					for (ARValueKey arvKey : vsarv.getValueMap().keySet()) {
						ReportVariable rv = new ReportVariable(arvKey
								.getMgName(), arvKey.getFieldName(), vsarv
								.getSegmentID());
						Integer index = header.indexMap.get(rv.getKey());
						Assertion.assertNotNull(index);
						Object value = vsarv.getValue(arvKey.getMgName(),
								arvKey.getFieldName());
						row[header.offset + index] = (value != null) ? value
								.toString() : null;
					}
				}
				queryResultRows.add(row);
			}
		}
	}

	protected void handleSegmentRows(Header header,
			List<String[]> queryResultRows, QuerySummary qs, String contentOption) {
		boolean includeDD = !contentOption.equals("none");
		if (qs.getArs() != null) {
			AssessmentResultSummary ars = qs.getArs();
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				String[] row = new String[header.offset
						+ header.indexMap.size()];
				row[0] = ars.getSubjectID();
				row[1] = vsarv.getSiteID();
				row[2] = ars.getExpName();
				row[3] = String.valueOf(vsarv.getVisitID());
				row[4] = String.valueOf(vsarv.getSegmentID());
				handleAssessmentPartsOfRow(header, vsarv, row, false);
				if (includeDD && qs.getDdrs() != null) {
					AnalysisResultSummary ddrs = qs.getDdrs();
					handleDDPartsOfRow(header, vsarv, row, ddrs, false);
				}
				queryResultRows.add(row);
			}// for vsarv
		} else if (includeDD && qs.getDdrs() != null) {
			AnalysisResultSummary ddrs = qs.getDdrs();
			for (VisitSegAnalysisResultValues vsarv : ddrs.getVsarvList()) {
				String[] row = new String[header.offset
						+ header.indexMap.size()];
				row[0] = ddrs.getSubjectID();
				row[1] = vsarv.getSiteID();
				row[2] = ddrs.getExpName();
				row[3] = String.valueOf(vsarv.getVisitID());
				row[4] = String.valueOf(vsarv.getSegmentID());
				for (ARValueKey arvKey : vsarv.getValueMap().keySet()) {
					ReportVariable rv = new ReportVariable(arvKey.getMgName(),
							arvKey.getFieldName());
					Integer index = header.indexMap.get(rv.getKey());
					Assertion.assertNotNull(index);
					Object value = vsarv.getValue(arvKey.getMgName(), arvKey
							.getFieldName());
					row[header.offset + index] = (value != null) ? value
							.toString() : null;
				}
				queryResultRows.add(row);
			}
		}
	}

	protected void handleDDPartsOfRow(Header header,
			VisitSegAsResultValues vsarv, String[] row,
			AnalysisResultSummary ddrs, boolean useSegmentID) {
		VisitSegAnalysisResultValues vsanv = ddrs
				.getVisitSegAnalysisResultValues(vsarv.getVisitID(), vsarv
						.getSegmentID(), vsarv.getExpID(), vsarv.getSiteID());
		for (ARValueKey arvKey : vsanv.getValueMap().keySet()) {
			ReportVariable rv = null;
			if (useSegmentID) {
				rv = new ReportVariable(arvKey.getMgName(), arvKey
						.getFieldName(), vsarv.getSegmentID());
			} else {
				rv = new ReportVariable(arvKey.getMgName(), arvKey
						.getFieldName());
			}
			Integer index = header.indexMap.get(rv.getKey());
			Assertion.assertNotNull(index);
			Object value = vsanv.getValue(arvKey.getMgName(), arvKey
					.getFieldName());
			row[header.offset + index] = (value != null) ? value.toString()
					: null;
		}
	}

	protected void handleAssessmentPartsOfRow(Header header,
			VisitSegAsResultValues vsarv, String[] row, boolean useSegmentID) {
		for (ASValueKey aKey : vsarv.getSasvsMap().keySet()) {
			ReportVariable rv = null;
			if (useSegmentID) {
				rv = new ReportVariable(aKey.getAsName(), aKey.getScoreName(),
						vsarv.getSegmentID());
			} else {
				rv = new ReportVariable(aKey.getAsName(), aKey.getScoreName());
			}
			Integer index = header.indexMap.get(rv.getKey());
			Assertion.assertNotNull(index);
			SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);
			// TODO multiple value per score support
			row[header.offset + index] = (sasvs.getValue() != null) ? sasvs
					.getValue().toString() : null;
		}
	}

	protected void sortKeyList(List<ASValueKey> keyList) {
		Collections.sort(keyList, new Comparator<ASValueKey>() {
			@Override
			public int compare(ASValueKey o1, ASValueKey o2) {
				int diff = o1.getAsName().compareTo(o2.getAsName());
				if (diff == 0)
					return o1.getScoreName().compareTo(o2.getScoreName());
				return diff;
			}
		});
	}

	protected void prepareAndWriteCVSFile(AsQueryBuilderForm queryForm,
			OutputStream outStream) throws IOException {
		List<ScoreValueSummary> sumList = queryForm.getSummaryList();
		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");
		buf.append("Experiment ID,");
		buf.append("Visit ID,");
		buf.append("Segment ID,");

		prepHeaderLine(queryForm, buf);

		BufferedWriter out = null;
		out = new BufferedWriter(new OutputStreamWriter(outStream), 4096);
		// write header
		out.write(buf.toString());
		out.write('\n');

		List<String[]> visitScoresRows = new LinkedList<String[]>();
		for (ScoreValueSummary summary : sumList) {

			for (VisitSegmentScoreValues vssv : summary
					.getVisitSegmentScoreValues()) {
				List<Object> values = vssv.getValues();
				String[] row = new String[values.size() + 5];

				row[0] = summary.getSubjectID();
				row[1] = vssv.getSiteID();
				row[2] = String.valueOf(vssv.getExperimentID());
				row[3] = String.valueOf(vssv.getVisitID());
				row[4] = String.valueOf(vssv.getSegmentID());
				int offset = 5;
				int idx = offset;
				for (Object item : values) {
					row[idx++] = item.toString().trim();
				}
				visitScoresRows.add(row);
			}
		}
		writeQueryResultRows(out, visitScoresRows);
	}

	private void writeQueryResultRows(BufferedWriter out,
			List<String[]> visitScoresRows) throws IOException {
		for (Iterator<String[]> iter = visitScoresRows.iterator(); iter
				.hasNext();) {
			String[] row = iter.next();
			for (int i = 0; i < row.length; i++) {
				String value = row[i];
				if (row[i] == null || row[i].length() == 0) {
					value = "."; // for SPSS/SAS
				}
				out.write(value);
				if ((i + 1) < row.length)
					out.write(',');
			}
			out.write('\n');
		}
		out.flush();
	}

	private Header prepHeaderLine(List<QuerySummary> qsList,
			String formatOption, String contentOption) {
		StringBuilder sb = new StringBuilder(1024);
		sb.append("SubjectID,");
		sb.append("Site ID,");
		sb.append("Experiment,");
		sb.append("Visit ID,");
		if (formatOption.equals("segment"))
			sb.append("Segment ID,");
		Set<ReportVariable> rvUniqSet = new HashSet<ReportVariable>();
		for (QuerySummary qs : qsList) {
			if (qs.getArs() != null) {
				AssessmentResultSummary ars = qs.getArs();
				for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
					for (ASValueKey aKey : vsarv.getSasvsMap().keySet()) {
						ReportVariable rv = new ReportVariable(
								aKey.getAsName(), aKey.getScoreName());
						if (!formatOption.equals("segment")) {
							rv.segmentID = vsarv.getSegmentID();
						}
						rvUniqSet.add(rv);
					}
				}
			}
			if (qs.getDdrs() != null) {
				AnalysisResultSummary ddrs = qs.getDdrs();
				for (VisitSegAnalysisResultValues vsarv : ddrs.getVsarvList()) {
					for (ARValueKey aKey : vsarv.getValueMap().keySet()) {
						ReportVariable rv = new ReportVariable(
								aKey.getMgName(), aKey.getFieldName());
						if (!formatOption.equals("segment")) {
							rv.segmentID = vsarv.getSegmentID();
						}
						rvUniqSet.add(rv);
					}
				}
			}
		}
		List<ReportVariable> rvList = new ArrayList<ReportVariable>(rvUniqSet);
		rvUniqSet = null;
		Collections.sort(rvList, new Comparator<ReportVariable>() {
			@Override
			public int compare(ReportVariable o1, ReportVariable o2) {
				int diff = o1.segmentID - o2.segmentID;
				if (diff == 0) {
					diff = o1.levelTwo.compareTo(o2.levelTwo);
					if (diff == 0) {
						diff = o1.levelOne.compareTo(o2.levelOne);
					}
				}
				return diff;
			}
		});
		Map<String, Integer> indexMap = new HashMap<String, Integer>();
		int i = 0;
		for (Iterator<ReportVariable> it = rvList.iterator(); it.hasNext();) {
			ReportVariable rv = it.next();
			String key = rv.getKey();
			sb.append(key);
			if (it.hasNext())
				sb.append(',');
			indexMap.put(key, i);
			i++;
		}

		int offset = 4;
		if (formatOption.equals("segment"))
			offset = 5;
		Header h = new Header(sb.toString(), indexMap, offset);
		return h;
	}

	public static class Header {
		int offset;
		String line;
		Map<String, Integer> indexMap;

		public Header(String line, Map<String, Integer> indexMap, int offset) {
			super();
			this.line = line;
			this.indexMap = indexMap;
			this.offset = offset;
		}

	}

	private void prepHeaderLine(AsQueryBuilderForm queryForm, StringBuffer buf) {
		for (Iterator<HeaderInfo> iter = queryForm.getHeaders().iterator(); iter
				.hasNext();) {
			HeaderInfo hi = iter.next();
			for (Iterator<String> it = hi.getSubHeaders().iterator(); it
					.hasNext();) {
				String subHeader = it.next();
				subHeader = subHeader.replace(' ', '_');
				String variableName = hi.getTitle().replace(' ', '_') + "_"
						+ subHeader;
				buf.append(variableName);
				if (it.hasNext())
					buf.append(',');
			}
			if (iter.hasNext())
				buf.append(',');
		}
	}

	protected void prepareAndWriteSRBCVSFile(AsQueryBuilderForm queryForm,
			OutputStream outStream) throws IOException {
		List<ScoreValueSummary> sumList = queryForm.getSummaryList();
		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");

		prepHeaderLine(queryForm, buf);

		BufferedWriter out = null;
		out = new BufferedWriter(new OutputStreamWriter(outStream), 4096);
		// write header
		out.write(buf.toString());
		out.write('\n');

		List<String[]> visitScoresRows = new LinkedList<String[]>();
		for (ScoreValueSummary summary : sumList) {

			VisitSegmentScoreValues vssv = (VisitSegmentScoreValues) summary
					.getVisitSegmentScoreValues().iterator().next();
			List<Object> values = vssv.getValues();
			String[] row = new String[values.size() + 2];

			row[0] = summary.getSubjectID();
			row[1] = vssv.getSiteID();
			int offset = 2;
			int idx = offset;
			for (Object item : values) {
				row[idx++] = item.toString().trim();
			}

			// combine assessments from different visits only if the visits
			// assessments don't overlap
			boolean first = true;
			for (VisitSegmentScoreValues vss : summary
					.getVisitSegmentScoreValues()) {
				if (first) {
					first = false;
					continue;
				}
				idx = offset;
				for (Object item : vss.getValues()) {
					String value = item.toString().trim();
					if (value.length() > 0 && row[idx].length() == 0) {
						row[idx] = value;
					}
					++idx;
				}
			}
			visitScoresRows.add(row);
		}

		writeQueryResultRows(out, visitScoresRows);
	}

	public ActionForward showStatsInput(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> showStatsInput");
			HttpSession session = request.getSession(false);
			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);
			uc.getUserInfo();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StatisticsForm statsForm = new StatisticsForm();

			/** @todo use Constants */
			session.setAttribute("statsForm", statsForm);

//			List<String> regionNames = StatsHelper
	//				.getBrainRegionNames(queryForm);

			List<String> regionNames = new ArrayList<String>(0);

			Set<ScoreMetaData> smdSet = StatsHelper.getScoreMetaData(queryForm);
			Map<String,ScoreMetaData> smdMap = new HashMap<String, ScoreMetaData>();
			//FIXME unique scorename assumption
			for(ScoreMetaData smd : smdSet) {
				smdMap.put(smd.getScoreName(), smd);
			}
			statsForm.setSmdMap(smdMap);

			Map<String, String> discreteScoresMap = StatsHelper.getScoreMap(
					smdSet, true);
			SingleScoreSelector dsSelector = new SingleScoreSelector(
					discreteScoresMap);
			statsForm.setDiscreteScoreSelector(dsSelector);

			Map<String, String> contScoresMap = StatsHelper.getScoreMap(
					smdSet, false);
			ScoresSelector csSelector = new ScoresSelector(contScoresMap);
			statsForm.setContScoresSelector(csSelector);

			// preparations for bivariates
			CombinedScoreSelector bv1Selector = new CombinedScoreSelector(
					contScoresMap, regionNames);
			CombinedScoreSelector bv2Selector = new CombinedScoreSelector(
					contScoresMap, regionNames);

			statsForm.setBv1ScoreSelector(bv1Selector);
			statsForm.setBv2ScoreSelector(bv2Selector);
			if (!discreteScoresMap.isEmpty()) {
				discreteScoresMap.put("Site", "Site");
				SingleScoreSelector groupByVarSelector = new SingleScoreSelector(
						discreteScoresMap);
				statsForm.setGroupByVarSelector(groupByVarSelector);
			}

			Map<String, String> statsOptionMap = new LinkedHashMap<String, String>(
					5);
			statsOptionMap.put("Univariate", "univariate");
			statsOptionMap.put("Bivariate", "bivariate");

			StatsOptionSelector soSelector = new StatsOptionSelector(
					statsOptionMap);
			statsForm.setStatsOptionSelector(soSelector);

			/** @todo use Constants */
			return mapping.findForward("stats_input");
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showBatchQueryForm(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			getUserInfo(request);
			HttpSession session = request.getSession(false);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			List<AssessmentSelectionInfo> asiList = queryForm.getAssessments();
			List<AssessmentSelectionInfo> newAsiList = new ArrayList<AssessmentSelectionInfo>(
					asiList.size());
			for (AssessmentSelectionInfo asi : asiList) {
				AssessmentSelectionInfo newAsi = new AssessmentSelectionInfo(
						asi, false, false);
				newAsiList.add(newAsi);
			}
			BatchQueryForm bqForm = new BatchQueryForm();
			bqForm.setAsiList(newAsiList);
			session.setAttribute(Constants.BATCHQUERY_FORM_KEY, bqForm);
			return mapping.findForward("show_bq");
		} catch (Exception x) {
			log.error(x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewCart(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewCart");
		try {
			// just verify user and forward to Constants.VIEW_CART page
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			ShoppingCartForm scForm = (ShoppingCartForm) session
					.getAttribute("scForm");
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			boolean canSendEmail = isEmailServiceEnabled(configService);
			if (scForm != null) {
				scForm.setSupportEmail(canSendEmail);
				if (canSendEmail) {
					if (GenUtils.isValidEmail(ui.getPerceivedName())) {
						scForm.setEmail(ui.getPerceivedName());
					}
				}
			}

			return mapping.findForward(Constants.VIEW_CART);
		} catch (Exception x) {
			log.error("viewCart", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected boolean isEmailServiceEnabled(IAppConfigService configService) {
		String emailHost = configService.getParamValue("email.host");
		String emailUser = configService.getParamValue("email.user");
		String emailPwd = configService.getParamValue("email.pwd");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.isNotEmpty(emailUser)
				&& GenUtils.isNotEmpty(emailPwd)
				&& GenUtils.isNotEmpty(emailHost)
				&& GenUtils.isNotEmpty(emailFrom);

		canSendEmail &= GenUtils.isValidEmail(emailFrom);
		return canSendEmail;
	}

	public ActionForward showBatchImageDownloadPage(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			ShoppingCartForm scForm = (ShoppingCartForm) session
					.getAttribute("scForm");

			if (scForm == null) {
				scForm = new ShoppingCartForm();
				session.setAttribute("scForm", scForm);
			}

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISecurityService secService = ServiceFactory.getSecurityService();
			IDownloadJobService djs = ServiceFactory.getDownloadJobService();
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			// set email support flag if available
			boolean canSendEmail = isEmailServiceEnabled(configService);
			scForm.setSupportEmail(canSendEmail);

			String curSiteID = secService.findSiteIDByDbID(dbID);

			List <QuerySummary> qsList = queryForm.getQsList();
			Map<String, Set<String>> site2SubjectListMap = new HashMap<String, Set<String>>(
					17);
			for(QuerySummary qs : qsList) {
				String siteID = qs.getSiteID();
				String subjectID = qs.getSubjectID();
				String expID = qs.getExpID();
				String key = siteID + "_" + expID;
				Set<String> subjectIDList = site2SubjectListMap.get(key);
				if (subjectIDList == null) {
					subjectIDList = new HashSet<String>();
					site2SubjectListMap.put(key, subjectIDList);
				}
				subjectIDList.add(subjectID);
			}

			Map<String, ExpSubjectsIDBInfo> esidbMap = new HashMap<String, ExpSubjectsIDBInfo>(
					7);
			Map<String, List<SubjectImageDataBundle>> exp2SIDBMap = new HashMap<String, List<SubjectImageDataBundle>>(
					7);

			for (Map.Entry<String, Set<String>> entry : site2SubjectListMap
					.entrySet()) {
				String key = entry.getKey();
				String siteID = key.substring(0, key.indexOf('_'));
				String expID = key.substring(key.indexOf('_') + 1);
				Set<String> subjectIDSet = entry.getValue();

				List<SubjectImageDataBundle> sidbList = exp2SIDBMap.get(expID);
				if (sidbList == null) {
					sidbList = new ArrayList<SubjectImageDataBundle>();
					exp2SIDBMap.put(expID, sidbList);
				}

				String[] sidArr = new String[subjectIDSet.size()];
				sidArr = subjectIDSet.toArray(sidArr);
				SubjectImageDataBundle[] sidbArr = new SubjectImageDataBundle[sidArr.length];

				for (int i = 0; i < sidArr.length; i++) {
					String subjectID = sidArr[i];
					SubjectImageDataBundle sidb = new SubjectImageDataBundle(
							subjectID, siteID, null);
					sidbList.add(sidb);
					sidbArr[i] = sidb;
				}

				String siteIDParam = (!siteID.equals(curSiteID)) ? siteID
						: null;
				djs.prepImagePathsForSubject(siteIDParam, dbID, ui, sidArr,
						expID, sidbArr, null, configService, null);
				for (SubjectImageDataBundle sidb : sidbList) {
					for (String expIDStr : sidb.getExpIds()) {
						String expName = sidb.getExperimentName(expIDStr);
						ExpSubjectsIDBInfo esidb = esidbMap.get(expName);
						if (esidb == null) {
							esidb = new ExpSubjectsIDBInfo(expName);
							esidbMap.put(expName, esidb);
						}
						esidb.addSIDB(expID, sidb);
					}
				}

			} // site2SubjectListMap

			scForm.setEsidbMap(esidbMap);

			return mapping.findForward(Constants.BATCH_IMG_DOWNLOAD);
		} catch (Exception x) {
			log.error("showBatchImageDownloadPage", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected Map<String, List<String>> prepExp2RunTypeMap(
			Map<String, List<SubjectImageDataBundle>> exp2SIDBMap) {
		Map<String, List<String>> map = new HashMap<String, List<String>>(7);
		for (String expID : exp2SIDBMap.keySet()) {
			List<SubjectImageDataBundle> sidbList = exp2SIDBMap.get(expID);
			Set<String> runTypeSet = new HashSet<String>(7);
			for (SubjectImageDataBundle sidb : sidbList) {
				Set<String> snSet = sidb.getSegmentNameSet();
				for (String segName : snSet) {
					if (!runTypeSet.contains(segName)) {
						if (segName.startsWith("Segment ")) {
							continue;
						}
						if (segName.equals("t1") || segName.equals("t2")) {
							runTypeSet.add(segName);
						} else {
							String runType = segName.replaceFirst("\\d+$", "");
							if (!runTypeSet.contains(runType))
								runTypeSet.add(runType);
						}
					}
				}
			}
			if (!runTypeSet.isEmpty()) {
				List<String> runTypes = new ArrayList<String>(runTypeSet);
				Collections.sort(runTypes);
				map.put(expID, runTypes);
			}
		}
		return map;
	}

	public static class ReportVariable {
		String levelOne;
		String levelTwo;
		int segmentID = -1;

		public ReportVariable(String levelOne, String levelTwo) {
			this(levelOne, levelTwo, -1);
		}

		public ReportVariable(String levelOne, String levelTwo, int segmentID) {
			super();
			this.levelOne = levelOne.replaceAll("\\s+", "_");
			this.levelTwo = levelTwo.replaceAll("\\s+", "_");
			this.segmentID = segmentID;
		}

		public String getKey() {
			StringBuilder sb = new StringBuilder();
			sb.append(levelOne).append("__").append(levelTwo);
			if (segmentID >= 0)
				sb.append("__").append(segmentID);
			return sb.toString();
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result
					+ ((levelOne == null) ? 0 : levelOne.hashCode());
			result = prime * result
					+ ((levelTwo == null) ? 0 : levelTwo.hashCode());
			result = prime * result + segmentID;
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final ReportVariable other = (ReportVariable) obj;
			if (levelOne == null) {
				if (other.levelOne != null)
					return false;
			} else if (!levelOne.equals(other.levelOne))
				return false;
			if (levelTwo == null) {
				if (other.levelTwo != null)
					return false;
			} else if (!levelTwo.equals(other.levelTwo))
				return false;
			if (segmentID != other.segmentID)
				return false;
			return true;
		}
	}

	static class VisitSiteKey {
		int visitID;
		String siteID;

		public VisitSiteKey(int visitID, String siteID) {
			this.visitID = visitID;
			this.siteID = siteID;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result
					+ ((siteID == null) ? 0 : siteID.hashCode());
			result = prime * result + visitID;
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final VisitSiteKey other = (VisitSiteKey) obj;
			if (siteID == null) {
				if (other.siteID != null)
					return false;
			} else if (!siteID.equals(other.siteID))
				return false;
			if (visitID != other.visitID)
				return false;
			return true;
		}
	}// ;
}
