package clinical.web.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.BIRNURIException;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.download.DataNode;
import clinical.web.download.DownloadJob;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.FileInfo;
import clinical.web.download.SubjectImageDataBundle;
import clinical.web.exception.ValidationException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.ShoppingCartForm;
import clinical.web.helpers.EmailHelper;
import clinical.web.helpers.ShoppingCartHelper;
import clinical.web.scheduler.JobScheduler;
import clinical.web.services.IDownloadJobService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ShoppingCartAction.java,v 1.1.2.7 2007/07/03 01:43:59 bozyurt
 *          Exp $
 */
public class ShoppingCartAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ShoppingCartAction.class);

	public ShoppingCartAction() {
		super();
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.sc.add", "addItem");
		map.put("button.sc.remove", "removeItem");
		map.put("button.sc.view", "viewCart");
		map.put("button.sc.download", "scheduleDownload");
		map.put("button.sc.back", "back2SearchResults");
		map.put("button.sc.counts", "checkCounts");
		map.put("button.sc.complete", "schedulingComplete");

		return map;
	}

	public ActionForward addItem(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addItem");
		try {
			response.setContentType("text/xml");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);

			ShoppingCartForm scForm = (ShoppingCartForm) form;
			String subjectID = request.getParameter("subjectID");
			String siteID = request.getParameter("siteID");
			String expID = request.getParameter("expID");

			log.info("subjectID:" + subjectID + ", siteID:" + siteID + ", expID:"
					+ expID);

			if (subjectID != null) {
				String dbID = (String) session
						.getAttribute(Constants.SESSION_DBID_KEY);

				String treeId = "t_" + scForm.nextId();
				SubjectImageDataBundle[] sidbArr = new SubjectImageDataBundle[1];
				SubjectImageDataBundle sidb = new SubjectImageDataBundle(subjectID,
						siteID, treeId);
				sidbArr[0] = sidb;

				// prepTestImagePaths(sidb);

				ISecurityService secService = ServiceFactory.getSecurityService();
				String curSiteID = secService.findSiteIDByDbID(dbID);
				Assertion.assertNotNull(curSiteID);

				IAppConfigService configService = ServiceFactory
						.getAppConfigService();

				IDownloadJobService djs = ServiceFactory.getDownloadJobService();

				String siteIDParam = (!siteID.equals(curSiteID)) ? siteID : null;
				djs.prepImagePathsForSubject(siteIDParam, dbID, ui,
						new String[] { subjectID }, expID, sidbArr, null,
						configService, null);

				scForm.addItem(sidb);
				StringBuilder buf = new StringBuilder("<success itemCount=\"");
				buf.append(scForm.getItemCount()).append("\" />");
				log.info(buf.toString());
				response.getOutputStream().println(buf.toString());
			} else {
				throw new Exception("No subjectID is specified!");
			}
		} catch (Exception x) {
			log.error("addItem", x);
			prepXMLFailureMessage(response, x);
		}
		return null;
	}

	public ActionForward checkCounts(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			response.setContentType("text/xml");
			getUserInfo(request);
			ShoppingCartForm scForm = (ShoppingCartForm) form;
			StringBuilder buf = new StringBuilder("<success itemCount=\"");
			buf.append(scForm.getItemCount()).append("\" />");
			log.info(buf.toString());
			response.getOutputStream().println(buf.toString());
		} catch (Exception x) {
			log.error("checkCounts", x);
			prepXMLFailureMessage(response, x);
		}
		return null;
	}

	protected void prepTestImagePaths(SubjectImageDataBundle sidb)
			throws BIRNURIException {
		DataNode visit = sidb.addVisit("0001");
		// DataNode segment = sidb.addSegment("0001", visit);
		DataNode subDir = sidb.addSubDir("sirp1", visit);
		String rootPath = sidb.getSubjectID() + "/scanVisit__0006__0002/sirp1";
		FileInfo fi1 = new FileInfo(
				sidb.getSubjectID()
						+ "/scanVisit__0006__0002/sirp1/sirp-hp65-stc-to7-gam+deriv-fsl-from-MBTS-preproc-0008-0001.feat",
				FileInfo.GZIPPED_NIFTI, FileInfo.LOCAL, rootPath, false);
		FileInfo fi2 = new FileInfo(
				sidb.getSubjectID()
						+ "/scanVisit__0006__0002/sirp1/sirp-hp65-stc-to7-gam+deriv-fsl-from-MBTS-preproc-0008-0002.feat",
				FileInfo.GZIPPED_NIFTI, FileInfo.LOCAL, rootPath, false);
		List<FileInfo> fiList = new ArrayList<FileInfo>(2);
		fiList.add(fi1);
		fiList.add(fi2);

		sidb.addFiles(fiList, subDir, true);
	}

	public ActionForward removeItem(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> removeItem");
		try {
			getUserInfo(request);
			ShoppingCartForm scForm = (ShoppingCartForm) form;
			String subjectID = request.getParameter("subjectID");
			if (subjectID != null) {
				scForm.removeItem(subjectID);
			}
			return mapping.findForward(Constants.VIEW_CART);
		} catch (Exception x) {
			log.error("removeItem", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewCart(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewCart");
		try {
			// just verify user and forward to Constants.VIEW_CART page
			UserInfo ui = getUserInfo(request);
			ShoppingCartForm scForm = (ShoppingCartForm) form;
			String context = request.getParameter("context");
			if (context != null) {
				scForm.setJobScheduled(false);
			}

			IAppConfigService configService = ServiceFactory.getAppConfigService();

			String emailHost = configService.getParamValue("email.host");
			String emailUser = configService.getParamValue("email.user");
			String emailPwd = configService.getParamValue("email.pwd");
			String emailFrom = configService.getParamValue("email.from");
			boolean canSendEmail = GenUtils.isNotEmpty(emailUser)
					&& GenUtils.isNotEmpty(emailPwd)
					&& GenUtils.isNotEmpty(emailHost)
					&& GenUtils.isNotEmpty(emailFrom);

			canSendEmail &= GenUtils.isValidEmail(emailFrom);

			scForm.setSupportEmail(canSendEmail);
			if (canSendEmail) {
				if (GenUtils.isValidEmail(ui.getPerceivedName())) {
					scForm.setEmail(ui.getPerceivedName());
				}
			}

			return mapping.findForward(Constants.VIEW_CART);
		} catch (Exception x) {
			log.error("viewCart", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward scheduleDownload(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> scheduleDownload");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);

			ShoppingCartForm scForm = (ShoppingCartForm) form;
			String results = request.getParameter("results");
			log.info("results:" + results);
			log.info("bundleName: " + scForm.getBundleName());
			String bundleName = scForm.getBundleName();
			if (bundleName == null || bundleName.trim().length() == 0) {
				bundleName = "data_download";
			}
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISecurityService secService = ServiceFactory.getSecurityService();
			String curSiteID = secService.findSiteIDByDbID(dbID);
			Assertion.assertNotNull(curSiteID);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> expList = dbCache.getExperiments(ui, false);
			Map<String, Experiment> expMap = toMap(curSiteID, expList);

			List<SubjectImageDataBundle> sidbList = scForm.getItems();
			Set<String> remoteSiteIDSet = new HashSet<String>(7);
			for (SubjectImageDataBundle sidb : sidbList) {
				if (!sidb.getSiteID().equals(curSiteID)) {
					remoteSiteIDSet.add(sidb.getSiteID());
				}
			}

			if (!remoteSiteIDSet.isEmpty()) {
				IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
				for (String siteID : remoteSiteIDSet) {
					Map<String, Experiment> map = rds.getAllExperiments(siteID);
					for (Experiment e : map.values()) {
						expMap.put(siteID + "_" + e.getName(), e);
					}
				}
			}

			Map<String, String> asNameMap = new HashMap<String, String>();
			List<SubjectImageDataBundle> caSIDBList = ShoppingCartHelper
					.prepareAssessmentBundle(sidbList, results, asNameMap);

			String id = String.valueOf(System.currentTimeMillis());
			String description = "download named '" + bundleName + "'";

			IAppConfigService configService = ServiceFactory.getAppConfigService();

			String cacheRoot = configService.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			File cacheDir = new File(cacheRoot, id);
			cacheDir.mkdirs();

			FileBundleConfig fbc = ShoppingCartHelper.prepareFileBundleConfig(
					sidbList, results, bundleName, cacheDir.getAbsolutePath(),
					expMap);

			DownloadJob job = new DownloadJob(id, ui, description, fbc);
			job.setDbID(dbID);
			log.info("email:" + scForm.getEmail());

			if (scForm.isSupportEmail() && scForm.isNotifyByEmail()
					&& GenUtils.isNotEmpty(scForm.getEmail())
					&& GenUtils.isValidEmail(scForm.getEmail())) {

				log.info("will notify by email!");
				String emailHost = configService.getParamValue("email.host");
				String emailUser = configService.getParamValue("email.user");
				String emailPwd = configService.getParamValue("email.pwd");
				String emailFrom = configService.getParamValue("email.from");
				EmailHelper emailHelper = new EmailHelper(emailHost, emailUser,
						emailPwd, emailFrom);
				emailHelper.setToUser(scForm.getEmail());
				job.setEmailHelper(emailHelper);
				scForm.setWillNotify(true);
			}

			if (!caSIDBList.isEmpty()) {
				AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
						.getAttribute(Constants.ASQUERYFORM_KEY);

				List<AssessmentSelectionInfo> asiList = queryForm.getAssessments();
				List<AssessmentSelectionInfo> filteredAsiList = new ArrayList<AssessmentSelectionInfo>(
						asiList.size());
				for (AssessmentSelectionInfo asi : asiList) {
					if (asNameMap.containsKey(asi.getName())) {
						filteredAsiList.add(asi);
					}
				}

				job.setCaSIDBList(caSIDBList);
				job.setFilteredAsiList(asiList);
			}

			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job);
			scForm.setScheduledJobID(id);
			scForm.clearItems();

			return mapping.findForward(Constants.SCHEDULE_COMPLETE);
		} catch (Exception x) {
			log.error("scheduleDownload", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward schedulingComplete(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> schedulingComplete");
		try {
			getUserInfo(request);
			return mapping.findForward(Constants.SCHEDULE_COMPLETE);
		} catch (Exception x) {
			log.error("schedulingComplete", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward back2SearchResults(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			// just verify user and forward to Constants.BACK page
			getUserInfo(request);
			ShoppingCartForm scForm = (ShoppingCartForm) form;

			scForm.setJobScheduled(false);
			return mapping.findForward(Constants.BACK);
		} catch (Exception x) {
			log.error("back2SearchResults", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected static Map<String, Experiment> toMap(String siteID,
			List<Experiment> expList) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = expList.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(siteID + "_" + exp.getName(), exp);
		}
		return map;
	}

	protected static void prepXMLFailureMessage(HttpServletResponse response,
			Exception x) throws IOException {
		StringBuffer buf = new StringBuffer();
		buf.append("<failure>");
		buf.append(x.getMessage());
		buf.append("</failure>");
		response.getOutputStream().println(buf.toString());
	}
}
