package clinical.web.actions;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Protocol;
import clinical.utils.DateTimeUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IExperimentManagement;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.exception.SubjectVisitManagementException;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.helpers.StudyFormInfo;
import clinical.web.helpers.StudySelector;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.helpers.VisitFormInfo;
import clinical.web.services.BIRNIDGenerator;
import clinical.web.services.SecurityService;
import clinical.web.vo.Study;
import clinical.web.vo.StudySegment;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectManagementAction.java,v 1.36 2008/04/15 00:16:00 bozyurt
 *          Exp $
 */
public class SubjectManagementAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(31);

	public SubjectManagementAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.visit_edit", "editVisit");
		map.put("button.visit_add", "addVisit");
		map.put("button.visit_update", "updateVisit");

		map.put("button.visit_delete", "deleteVisit");
		map.put("button.segment_add", "addSegment");
		map.put("button.segment_delete", "deleteSegment");

		map.put("button.show_subject_add", "showAddSubject");
		map.put("button.create_birnid", "createBIRNID");
		map.put("button.subject_add", "addSubject");
		map.put("button.subject_update", "updateSubject");
		map.put("button.subject_view", "viewSubject");
		map.put("button.subject_find", "findSubjects");
		map.put("button.subject_edit", "manageSubjects");
		map.put("button.subject_show_find", "showFindSubjectsScreen");
		map.put("button.enroll.subject", "enrollSubject");

		map.put("action.changeVisit", "changeVisit");
		map.put("button.segment_manage", "manageSegment");

		map.put("button.show_visit_add", "showVisitAdd");
		map.put("button.show_visit_edit", "showVisitEdit");

		map.put("button.next", "nextSubjectWindow");
		map.put("button.prev", "prevSubjectWindow");

		map.put("button.study_edit", "editStudy");
		map.put("button.study_add", "addStudy");
		map.put("button.show_edit_study", "showEditStudy");
		map.put("button.show_add_study", "showAddStudy");
		map.put("action.changeStudy", "changeStudy");
		map.put("action.changeExperiment", "changeExperiment");
		map.put("button.show_add_segment", "showAddSegment");
		map.put("button.segment_add", "addSegment");

		return map;
	}

	public ActionForward showVisitEdit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		log.info(">> showVisitEdit");
		try {
			getUserInfo(request);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;

			// current visit will be updated hence nothing needs to be done
			// besides setting current action
			svmForm.setCurrentAction(Constants.EDIT_VISIT);
		} catch (Exception x) {
			processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.EDIT_VISIT);
	}

	public ActionForward showVisitAdd(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showVisitAdd");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			String[] expNames = SubjectManagementHelper.getExperimentNames(
					dbID, ui, svmForm);
			String[] visitTypes = SubjectManagementHelper.getVisitTypes(dbID,
					ui);
			List<Protocol> protocols = svmForm.getProtocols();
			if (protocols == null || protocols.isEmpty()) {
				protocols = SubjectManagementHelper.getProtocols(dbID, ui);
				svmForm.setProtocols(protocols);
			}
			Object[] protocolNameVersions = SubjectManagementHelper
					.getProtocolNameVersions(protocols);

			Visit newVisit = new Visit();
			newVisit.setSubjectID(svmForm.getSubject().getSubjectID());
			VisitFormInfo vfi = new VisitFormInfo(newVisit, expNames,
					visitTypes, svmForm);
			Experiment exp = null;
			log.info("** experimentValue=" + svmForm.getExperimentValue());
			if (svmForm.getCurrentVisit() != null) {
				exp = SubjectManagementHelper.findExperimentByName(svmForm
						.getExperiments(), svmForm.getCurrentVisit()
						.getExperiment());
				log.info("showVisitAdd exp=" + exp);
			} else {
				// first visit
				exp = SubjectManagementHelper.findExperiment(svmForm
						.getExperiments(), svmForm.getExpSelector()
						.getSelectedExpID());
				log.info("showVisitAdd first visit exp=" + exp);
			}

			vfi.setExperiment(exp.getName());

			VisitSegment vs = new VisitSegment();
			// also set the experiment id on visitSegment
			vs.setExperimentID(exp.getUniqueid().intValue());

			vs.setSubjectID(svmForm.getSubject().getSubjectID());

			SegmentFormInfo sfi = new SegmentFormInfo(vs,
					(String[]) protocolNameVersions[0],
					(int[]) protocolNameVersions[1], svmForm);

			newVisit.addVisitSegment(vs);
			vfi.addSegmentFormInfo(sfi);

			svmForm.setCurrentVisit(vfi);

			svmForm.setCurrentAction(Constants.ADD_VISIT);
		} catch (Exception x) {
			processExceptions(request, response, mapping, form, x,
					Constants.EDIT_VISIT);
		}
		return mapping.findForward(Constants.ADD_VISIT);
	}

	public ActionForward editVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editVisit");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			log.debug("editing the visit " + svmForm.getSelectedVisitID()
					+ " for subject " + svmForm.getSubject().getSubjectID());

			svmForm.setCurrentAction(Constants.EDIT_VISIT);
			Visit theVisit = null;
			int selExpID = svmForm.getExpSelector().getSelectedExpID();

			int visitID = Integer.parseInt(svmForm.getSelectedVisitID());
			theVisit = svmForm.getSubject().findVisit(visitID, selExpID);

			SubjectManagementHelper.prepareStaticInfo(dbID, svmForm, ui);

			String[] expNames = new String[svmForm.getExperiments().size()];
			int idx = 0;
			for (Experiment exp : svmForm.getExperiments()) {
				expNames[idx++] = exp.getName();
			}
			String[] visitTypes = new String[svmForm.getVisitTypes().size()];
			svmForm.getVisitTypes().toArray(visitTypes);
			VisitFormInfo vfi = new VisitFormInfo(theVisit, expNames,
					visitTypes, svmForm);
			String[] protocolNames = new String[svmForm.getProtocols().size()];
			int[] protocolVersions = new int[protocolNames.length];
			idx = 0;
			for (Protocol pr : svmForm.getProtocols()) {
				protocolNames[idx] = pr.getName();
				protocolVersions[idx] = pr.getProtocolversion().intValue();
				++idx;
			}
			for (VisitSegment vs : theVisit.getVisitSegments()) {
				SegmentFormInfo sfi = new SegmentFormInfo(vs, protocolNames,
						protocolVersions, svmForm);
				vfi.addSegmentFormInfo(sfi);
			}
			svmForm.setCurrentVisit(vfi);

		} catch (Exception x) {
			svmForm.setCurrentAction("");
			return processExceptions(request, response, mapping, form, x,
					Constants.EDIT_VISIT);
		}

		return mapping.findForward(Constants.EDIT_VISIT);
	}

	public ActionForward addVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addVisit");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);

			VisitFormInfo vfi = svmForm.getCurrentVisit();
			if (log.isDebugEnabled()) {
				log.debug(vfi.getVisit().toExpComponent().toString());

			}

			// remove any visit segments since segments or studies will be added
			// in a later step
			vfi.getVisit().getVisitSegments().clear();

			int newVisitID = isvm.addVisitForSubject(ui, vfi.getVisit());

			// refresh the current subject's visit/experiment info from the
			// database
			String selSubjectID = svmForm.getSelectedSubjectID();
			if (selSubjectID == null) {
				// check also the CURRENT_SUBJECTID_KEY
				selSubjectID = (String) session
						.getAttribute(Constants.CURRENT_SUBJECTID_KEY);
				if (selSubjectID != null) {
					svmForm.setSelectedSubjectID(selSubjectID);
				} else {
					throw new SubjectVisitManagementException(
							"The selected subject information is missing");
				}
			}
			Experiment visitExp = SubjectManagementHelper.findExperimentByName(
					svmForm.getExperiments(), vfi.getExperiment());

			SubjectManagementHelper.prepareCurrentSubject(dbID, ui,
					selSubjectID, svmForm, visitExp.getUniqueid().intValue(),
					newVisitID);
		} catch (Exception x) {
			log.error("addVisit", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_VISIT);
		}
		// was Constants.SUCCESS
		return mapping.findForward(Constants.AFTER_ADD_VISIT);
	}

	public ActionForward afterAddVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			getUserInfo(request);
		} catch (Exception x) {
			log.error("afterAddVisit", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.AFTER_ADD_VISIT);
		}
		return mapping.findForward(Constants.AFTER_ADD_VISIT);
	}

	public ActionForward updateVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> updateVisit");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);

			VisitFormInfo vfi = svmForm.getCurrentVisit();
			log.debug(vfi.getVisit().toExpComponent().toString());

			isvm.updateVisitForSubject(ui, vfi.getVisit());

			// refresh the current subject's visit/experiment info from the
			// database
			String selSubjectID = svmForm.getSelectedSubjectID();
			Experiment visitExp = SubjectManagementHelper.findExperimentByName(
					svmForm.getExperiments(), vfi.getExperiment());

			SubjectManagementHelper.prepareCurrentSubject(dbID, ui,
					selSubjectID, svmForm, visitExp.getUniqueid().intValue());
		} catch (Exception x) {
			log.error("updateVisit", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	// not used 3/31/05 (IBO)
	/**
	 * @deprecated
	 */
	public ActionForward addVisit2(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addVisit2");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SubjectManagementHelper.prepareStaticInfo(dbID, svmForm, ui);

			Visit newVisit = new Visit();
			newVisit.setSubjectID(svmForm.getSubject().getSubjectID());
			String[] expNames = new String[svmForm.getExperiments().size()];
			int idx = 0;
			for (Object element : svmForm.getExperiments()) {
				Experiment exp = (Experiment) element;
				expNames[idx++] = exp.getName();
			}
			String[] visitTypes = new String[svmForm.getVisitTypes().size()];
			svmForm.getVisitTypes().toArray(visitTypes);

			VisitFormInfo vfi = new VisitFormInfo(newVisit, expNames,
					visitTypes, svmForm);
			String[] protocolNames = new String[svmForm.getProtocols().size()];
			int[] protocolVersions = new int[protocolNames.length];
			idx = 0;
			for (Object element : svmForm.getProtocols()) {
				Protocol pr = (Protocol) element;
				protocolNames[idx] = pr.getName();
				protocolVersions[idx] = pr.getProtocolversion().intValue();
				++idx;
			}

			// empty segment
			VisitSegment vs = new VisitSegment();
			SegmentFormInfo sfi = new SegmentFormInfo(vs, protocolNames,
					protocolVersions, svmForm);
			vfi.addSegmentFormInfo(sfi);

			svmForm.setCurrentVisit(vfi);
			svmForm.setCurrentAction(Constants.ADD_VISIT);

		} catch (Exception x) {
			log.error("+++", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.ADD_VISIT);
	}

	public ActionForward showFindSubjectsScreen(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showFindSubjectsScreen");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {

			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			List<?> subjects = isvm.getMatchingSubjects(ui, new SearchCriteria(
					new SearchPredicateList()));

			// start with a clean slate
			svmForm.cleanState();

			Collections.sort(subjects, new Comparator<Object>() {
				public int compare(Object o1, Object o2) {
					Humansubject hs1 = (Humansubject) o1;
					Humansubject hs2 = (Humansubject) o2;
					return hs1.getSubjectid().compareTo(hs2.getSubjectid());
				}
			});

			for (Object element : subjects) {
				Humansubject hs = (Humansubject) element;
				Subject subject = new Subject(hs);
				svmForm.addSubject(subject);
			}

		} catch (Exception x) {
			log.error("+++", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SHOW_SEARCH);
	}

	public ActionForward manageSubjects(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		log.info(">> manageSubjects");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isvm = ServiceFactory.getSubjectVisitManagement(dbID);

			boolean newSubject = true;
			// find the selected subject
			String selSubjectID = svmForm.getSelectedSubjectID();
			if (selSubjectID == null || selSubjectID.length() == 0) {
				selSubjectID = (String) session
						.getAttribute(Constants.CURRENT_SUBJECTID_KEY);
				svmForm.setSelectedSubjectID(selSubjectID);
				newSubject = false;
			}
			if (log.isDebugEnabled()) {
				log.debug("@@@@ selSubjectID=" + selSubjectID);
			}

			Subject subject = SubjectManagementHelper
					.prepareSubjectFromHumanSubject(ui, selSubjectID, isvm);

			// get the visits for the selected subject
			List<?> visits = isvm.getAllVisitsForSubject(ui, subject
					.getSubjectID());
			for (Object element : visits) {
				Visit vi = (Visit) element;
				// sort the visits by date also
				subject.addVisit(vi, true);
			}
			List<Visit> expVisits = null;
			int selectedExpID = subject.getFirstExperimentID();
			if (selectedExpID != -1) {
				expVisits = subject.getVisitsForExperiment(String
						.valueOf(selectedExpID));
			}

			// get only the experiments this subject participates
			List<Experiment> experiments = isvm.getExperimentsForSubject(ui,
					subject.getSubjectID());

			String[] expNames = new String[experiments.size()];

			Experiment selectedExperiment = SubjectManagementHelper
					.prepareExperiments(svmForm, experiments, expNames,
							selectedExpID);

			Visit latestVisit = null;
			if (expVisits != null && !expVisits.isEmpty()) {
				// repopulate visitdates
				svmForm.getVisitDates().clear();
				for (Visit vi : expVisits) {
					svmForm.addVisitDate(DateTimeUtils.formatTimestampToDate(vi
							.getTs()), String.valueOf(vi.getComponentID()));
				}

				latestVisit = (Visit) expVisits.get(0);
				// the first visit shown is the latest
				svmForm.setVisitDateValue(latestVisit.getComponentIDAsString());
			}

			svmForm.setSubject(subject);

			// now set the subject to the subject visit management form
			String[] visitTypes = SubjectManagementHelper.getVisitTypes(dbID,
					ui);

			if (latestVisit != null) {
				VisitFormInfo vfi = new VisitFormInfo(latestVisit, expNames,
						visitTypes, svmForm);
				vfi.setExperiment(selectedExperiment.getName());
				// set the protocols
				List<Protocol> protocols = SubjectManagementHelper
						.getProtocols(dbID, ui);
				svmForm.setProtocols(protocols);

				Object[] protocolNameVersions = SubjectManagementHelper
						.getProtocolNameVersions(protocols);

				if (!latestVisit.getStudies().isEmpty()) {
					StudySelector studySelector = new StudySelector(latestVisit
							.getStudies());
					svmForm.setStudySelector(studySelector);
					if (svmForm.getCurrentStudy() != null) {
						studySelector.setSelectedStudyID(svmForm
								.getCurrentStudy().getStudy().getStudyID());
					}

					SubjectManagementHelper
							.prepareStudy(svmForm, latestVisit, vfi, protocols,
									protocolNameVersions, studySelector);
				} else {
					// there are no studies
					svmForm.setStudySelector(null);
					// set segments
					log.info("no studies found setSegmentsForVisit ... ");
					SubjectManagementHelper.setSegmentsForVisit(svmForm,
							latestVisit, vfi, protocols, protocolNameVersions);
				}

				svmForm.setCurrentVisit(vfi);
				svmForm.setSelectedVisitID(String.valueOf(vfi.getVisit()
						.getComponentID()));

				if (log.isDebugEnabled()) {
					for (Object element : vfi.getSegmentFormInfos()) {
						SegmentFormInfo sfi = (SegmentFormInfo) element;
						log.debug("** " + sfi.toString());
					}
				}
			} // latestVisit != null

			if (newSubject && (expVisits == null || expVisits.isEmpty())) {
				// for a new subject without any visit clear the current visit
				// state
				svmForm.setCurrentVisit(null);
			}

			if (selectedExperiment != null) {
				session.setAttribute(Constants.CURRENT_EXPERIMENTID_KEY,
						selectedExperiment.getUniqueid().toString());
				session.setAttribute(Constants.CURRENT_EXPERIMENTNAME_KEY,
						GenUtils.clipString(selectedExperiment.getName(), 18));
				session.setAttribute(Constants.CURRENT_SUBJECTID_KEY,
						selSubjectID);
			}

			if (selectedExperiment == null) {
				SubjectManagementHelper.prepare4SubjectEnrollment(dbID, ui,
						svmForm);
			}

		} catch (Exception x) {
			log.error("manageSubjects", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward findSubjects(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> findSubjects");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);

			BeanInfo bi = Introspector.getBeanInfo(Subject.class, Object.class);
			Map<String, String> voColMap = new HashMap<String, String>(7);
			voColMap.put("subjectID", "subjectid");
			voColMap.put("birthDate", "birthdate");

			SearchCriteria sc = SubjectManagementHelper.prepareSearchCriteria(
					svmForm, bi, voColMap);

			List<Humansubject> subjects = isvm.getMatchingSubjects(ui, sc);
			List<Subject> summaryList = new ArrayList<Subject>(subjects.size());
			for (Humansubject hs : subjects) {
				Subject s = new Subject(hs);
				summaryList.add(s);
			}
			svmForm.setSubjectSummaryList(summaryList);

		} catch (Exception x) {
			log.error("findSubjects", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUBJECT_LIST);
	}

	public ActionForward changeExperiment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);

			Subject subject = svmForm.getSubject();

			VisitFormInfo oldVfi = svmForm.getCurrentVisit();
			// log.info("changeExperiment: experimentValue=" +
			// svmForm.getExperimentValue() );
			int selExpID = svmForm.getExpSelector().getSelectedExpID();
			Visit newVisit = subject.findFirstVisit(selExpID);
			if (newVisit == null) {
				svmForm.setCurrentVisit(null);
				svmForm.setSelectedVisitID(null);
			} else {
				log.info("prepareForVisitChange 1");
				//
				// repopulate visitdates
				svmForm.getVisitDates().clear();
				List<Visit> expVisits = subject.getVisitsForExperiment(String
						.valueOf(selExpID));
				for (Visit vi : expVisits) {
					svmForm.addVisitDate(DateTimeUtils.formatTimestampToDate(vi
							.getTs()), String.valueOf(vi.getComponentID()));
				}

				prepareForVisitChange(svmForm, subject, oldVfi, newVisit
						.getComponentID(), selExpID);
			}

		} catch (Exception x) {
			log.error("changeVisit", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	/**
	 * 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws java.lang.Exception
	 */
	public ActionForward changeVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeVisit");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);

			Subject subject = svmForm.getSubject();

			VisitFormInfo oldVfi = svmForm.getCurrentVisit();
			int newVisitID = Integer.parseInt(svmForm.getSelectedVisitID());
			int selExpID = oldVfi.getVisit().getExperimentID();
			prepareForVisitChange(svmForm, subject, oldVfi, newVisitID,
					selExpID);

		} catch (Exception x) {
			log.error("changeVisit", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	private void prepareForVisitChange(SubjectVisitManagementForm svmForm,
			Subject subject, VisitFormInfo oldVfi, int newVisitID, int selExpID)
			throws NumberFormatException, RuntimeException {
		Visit newVisit = subject.findVisit(newVisitID, selExpID);

		svmForm.setVisitDateValue(newVisit.getComponentIDAsString());

		VisitFormInfo vfi = new VisitFormInfo(newVisit, oldVfi
				.getExperimentNamesAsArray(), oldVfi.getVisitTypesAsArray(),
				svmForm);

		Experiment selExp = SubjectManagementHelper.findExperiment(svmForm
				.getExperiments(), selExpID);
		vfi.setExperiment(selExp.getName());

		List<Protocol> protocols = svmForm.getProtocols();
		Object[] protocolNameVersions = SubjectManagementHelper
				.getProtocolNameVersions(protocols);

		if (!newVisit.getStudies().isEmpty()) {
			StudySelector studySelector = svmForm.getStudySelector();
			if (studySelector == null) {
				// throw new RuntimeException("studySelector = null!");
				studySelector = new StudySelector(newVisit.getStudies());
				svmForm.setStudySelector(studySelector);
			}
			SubjectManagementHelper.prepareStudy(svmForm, newVisit, vfi,
					protocols, protocolNameVersions, studySelector);

		} else {
			// no studies has been found
			log.info("no studies found setSegmentsForVisit ... ");
			SubjectManagementHelper.setSegmentsForVisit(svmForm, newVisit, vfi,
					protocols, protocolNameVersions);
		}
		svmForm.setCurrentVisit(vfi);
		svmForm.setSelectedVisitID(String.valueOf(vfi.getVisit()
				.getComponentID()));
	}

	public ActionForward showAddSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showAddSubject");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);

			Subject subject = new Subject();
			svmForm.setSubject(subject);

		} catch (Exception x) {
			log.error("showAddSubject", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.ADD_SUBJECT);
	}

	public ActionForward updateSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> updateSubject");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			Subject subject = svmForm.getSubject();
			log.info(">>SUBJECT ID:" + subject.getSubjectID());

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			isvm.updateSubject(ui, subject);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("updateSubject", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_SUBJECT);
		}
	}

	public ActionForward addSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addSubject");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			Subject subject = svmForm.getSubject();
			log.info(">>SUBJECT ID:" + subject.getSubjectID());
			if (subject.getBirthDate() != null
					&& subject.getBirthDate().trim().length() > 0) {
				subject.setBirthDate(subject.getBirthDate().trim());
				if (DateTimeUtils.toDate(subject.getBirthDate()) == null) {
					throw new SubjectVisitManagementException(
							"The subject's birth date was not of format (mm/dd/yyyy):"
									+ subject.getBirthDate());
				}
			}

			// clean the previous state if any
			svmForm.cleanState();

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			isvm.addSubject(ui, subject);

			SubjectManagementHelper.getExperimentNames(dbID, ui, svmForm,
					subject.getSubjectID());
			SubjectExperimentsSelector expSelector = new SubjectExperimentsSelector(
					svmForm.getExperiments());
			svmForm.setExpSelector(expSelector);

			SubjectManagementHelper
					.prepare4SubjectEnrollment(dbID, ui, svmForm);
			svmForm.setSelectedSubjectID(subject.getSubjectID());
			session.setAttribute(Constants.CURRENT_SUBJECTID_KEY, subject
					.getSubjectID());
			session.setAttribute(Constants.CURRENT_EXPERIMENTID_KEY,
					"");
			session.setAttribute(Constants.CURRENT_EXPERIMENTNAME_KEY,
					"");

		} catch (Exception x) {
			log.error("addSubject", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_SUBJECT);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward createBIRNID(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			String siteID = ss.getSiteID(dbID);

			BIRNIDGenerator big = BIRNIDGenerator.getInstance(dbID);
			// String siteID = GenUtils.findSiteID(dbID);
			String BIRNID = big.createBIRNID(siteID);
			Subject subject = svmForm.getSubject();
			subject.setSubjectID(BIRNID);

		} catch (Exception x) {
			log.error("createBIRNID", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_SUBJECT);
		}
		return mapping.findForward(Constants.ADD_SUBJECT);
	}

	/**
	 * prepares the presentation data for the segments a of the current visit of
	 * the current subject.
	 * 
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws java.lang.Exception
	 */
	public ActionForward manageSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> manageSegment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			Experiment exp = SubjectManagementHelper.findExperiment(svmForm
					.getExperiments(), svmForm.getExpSelector()
					.getSelectedExpID());
			Subject subject = svmForm.getSubject();

			// get both validated and unvalidated assessments for this segment
			// for the not yet validated assessments get the one with entry ID 1
			SubjectManagementHelper.prepareForSegmentManPage(session, ui, dbID,
					svmForm, subject.getSubjectID(), exp.getUniqueid()
							.intValue(), -1, 1,
					SubjectManagementHelper.RETRIEVE_BOTH, false);

		} catch (Exception x) {
			log.error("manageSegment", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.MANAGE_SEGMENT);
	}

	public ActionForward prevSubjectWindow(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> prevSubjectWindow");
		try {
			getUserInfo(request);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			String action = svmForm.getCurrentAction();

			log.debug("*** SVM FORM ACTION action=" + action);
			SearchResultsIterator srit = svmForm.getSearchResultsIterator();

			srit.moveToPrevWindow();
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUBJECT_LIST);
	}

	public ActionForward nextSubjectWindow(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> nextSubjectWindow");
		try {
			getUserInfo(request);

			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			String action = svmForm.getCurrentAction();

			log.debug("*** SVM FORM ACTION action=" + action);
			SearchResultsIterator srit = svmForm.getSearchResultsIterator();
			srit.moveToNextWindow();
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUBJECT_LIST);
	}

	// for study management

	public ActionForward changeStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeStudy");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);

			prepareSelectedStudy(svmForm);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	private void prepareSelectedStudy(SubjectVisitManagementForm svmForm) {
		StudySelector studySelector = svmForm.getStudySelector();
		VisitFormInfo vfi = svmForm.getCurrentVisit();
		List<Protocol> protocols = svmForm.getProtocols();
		Object[] protocolNameVersions = SubjectManagementHelper
				.getProtocolNameVersions(protocols);
		SubjectManagementHelper.prepareStudy(svmForm, vfi.getVisit(), vfi,
				protocols, protocolNameVersions, studySelector);

		svmForm.setSelectedStudyID(String.valueOf(studySelector
				.getSelectedStudyID()));
	}

	public ActionForward showEditStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showEditStudy");
		try {
			getUserInfo(request);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;

			svmForm.setCurrentAction(Constants.EDIT_STUDY);
			prepareSelectedStudy(svmForm);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.EDIT_STUDY);
	}

	public ActionForward editStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editStudy");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			Study curStudy = svmForm.getCurrentStudy().getStudy();

			isvm.updateStudyForVisit(ui, curStudy);
			// update cached study also
			Subject subject = svmForm.getSubject();
			int visitID = curStudy.getComponentID();
			int expID = curStudy.getExperimentID();
			Visit visit = subject.findVisit(visitID, expID);
			assert (visit != null);
			visit.updateStudy(curStudy.getStudyID(), curStudy, false);
			// also update study selector
			StudySelector studySelector = new StudySelector(visit.getStudies());
			studySelector.setSelectedStudyID(curStudy.getStudyID());
			svmForm.setStudySelector(studySelector);

		} catch (Exception x) {
			log.error("editSegment", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.EDIT_SEGMENT);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward showAddStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showAddStudy");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);

			VisitFormInfo vfi = svmForm.getCurrentVisit();
			Study study = new Study();
			// also set the experiment id on study
			int theExpID = -1;
			for (Experiment exp : svmForm.getExperiments()) {
				if (exp.getName().equals(
						svmForm.getCurrentVisit().getExperiment())) {
					theExpID = exp.getUniqueid().intValue();
					study.setExperimentID(theExpID);
					break;
				}
			}
			study.setSubjectID(svmForm.getSubject().getSubjectID());
			study.setComponentID(vfi.getVisit().getComponentID());
			study.setTimeStamp(vfi.getVisit().getTs());

			StudyFormInfo sfi = new StudyFormInfo(study);
			vfi.getVisit().addStudy(study);
			vfi.addStudyFormInfo(sfi);

			// add the mandatory segment (each study has a mandatory segment
			StudySegment ss = new StudySegment();
			ss.setExperimentID(theExpID);
			ss.setSubjectID(svmForm.getSubject().getSubjectID());
			ss.setVisitID(vfi.getVisit().getComponentID());
			// segment numbers start from 1
			ss.setSegmentID(1);
			ss.setTimeStamp(vfi.getVisit().getTs());

			List<Protocol> protocols = svmForm.getProtocols();
			Object[] protocolNameVersions = SubjectManagementHelper
					.getProtocolNameVersions(protocols);
			SegmentFormInfo sgi = new SegmentFormInfo(ss,
					(String[]) protocolNameVersions[0],
					(int[]) protocolNameVersions[1], svmForm);

			sfi.addSegmentFormInfo(sgi);
			study.addStudySegment(ss);

			// cleanup selection state
			// if (svmForm.getSelectedStudyID() != null) {
			svmForm.setSelectedSegmentID(null);
			// }
			// indicate that the user is adding a new study
			svmForm.setSelectedStudyID("-1000");

			svmForm.setCurrentAction(Constants.ADD_STUDY);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.ADD_STUDY);
	}

	public ActionForward addStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addStudy");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isvm = ServiceFactory.getSubjectVisitManagement(dbID);

			Study study = svmForm.getCurrentStudy().getStudy();
			log.info("*** addStudy " + study.toExpStudy().toString());

			Study insertedStudy = isvm.addStudyForVisit(ui, study);

			// prepare StudySelector
			VisitFormInfo vfi = svmForm.getCurrentVisit();

			svmForm.setSelectedSubjectID(vfi.getVisit().getSubjectID());

			StudySelector studySelector = null;

			if (vfi.getStudyFormInfos().isEmpty()) {
				List<Study> studies = new ArrayList<Study>(1);
				studies.add(insertedStudy);
				studySelector = new StudySelector(studies);
				svmForm.setStudySelector(studySelector);
				svmForm.setSelectedStudyID("1");
				studySelector.setSelectedStudyID(1);
			} else {
				List<Study> studies = new ArrayList<Study>(vfi
						.getStudyFormInfos().size());
				for (StudyFormInfo studyFI : vfi.getStudyFormInfos()) {
					studies.add(studyFI.getStudy());
				}
				studySelector = new StudySelector(studies);
				svmForm.setStudySelector(studySelector);
				svmForm.setSelectedStudyID(String.valueOf(studies.size()));
				studySelector.setSelectedStudyID(studies.size());
			}
			log.info("addStudy prepared studySelector "
					+ studySelector.toString());

			// CHECK: if the code below is necessary
			SubjectManagementHelper.prepareCurrentSubject(dbID, ui, svmForm
					.getSelectedSubjectID(), svmForm, svmForm.getExpSelector()
					.getSelectedExpID());

			SubjectManagementHelper.prepareSegmentTimestampList(svmForm);
		} catch (Exception x) {
			log.error("addStudy", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_STUDY);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward showAddSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showAddSegment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);
			VisitFormInfo vfi = svmForm.getCurrentVisit();
			StudyFormInfo studyFI = svmForm.getCurrentStudy();
			List<Protocol> protocols = svmForm.getProtocols();
			Object[] protocolNameVersions = SubjectManagementHelper
					.getProtocolNameVersions(protocols);

			if (studyFI != null) {
				StudySegment ss = new StudySegment();
				// also set the experiment id on visitSegment
				SubjectManagementHelper.setExperimentIDForStudySegment(svmForm,
						ss);
				ss.setSubjectID(svmForm.getSubject().getSubjectID());
				ss.setVisitID(vfi.getVisit().getComponentID());
				ss.setTimeStamp(vfi.getVisit().getTs());
				// set the study ID also
				ss.setStudyID(studyFI.getStudy().getStudyID());
				SegmentFormInfo sfi = new SegmentFormInfo(ss,
						(String[]) protocolNameVersions[0],
						(int[]) protocolNameVersions[1], svmForm);
				studyFI.addSegmentFormInfo(sfi);
				studyFI.getStudy().addStudySegment(ss);
			} else {
				VisitSegment vs = new VisitSegment();
				// also set the experiment id on visitSegment
				SubjectManagementHelper.setExperimentIDForVisitSegment(svmForm,
						vs);
				vs.setSubjectID(svmForm.getSubject().getSubjectID());
				vs.setVisitID(vfi.getVisit().getComponentID());
				vs.setTimeStamp(vfi.getVisit().getTs());

				SegmentFormInfo sfi = new SegmentFormInfo(vs,
						(String[]) protocolNameVersions[0],
						(int[]) protocolNameVersions[1], svmForm);

				vfi.getVisit().addVisitSegment(vs);
				vfi.addSegmentFormInfo(sfi);
			}
			svmForm.setSelectedSegmentID(null);
			svmForm.setCurrentAction(Constants.ADD_SEGMENT);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.ADD_SEGMENT);
	}

	public ActionForward addSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addSegment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			StudyFormInfo studyFI = svmForm.getCurrentStudy();
			int segmentExpID = -1;
			int curVisitID = -1;

			if (studyFI != null) {
				StudySegment ss = svmForm.getCurrentSegment().getStudySegment();
				log.info("*** addSegment " + ss.toExpSegment().toString());
				int newSegmentID = isvm.addStudySegmentForSubject(ui, ss);
				svmForm.setSelectedSegmentID(String.valueOf(newSegmentID));
				segmentExpID = ss.getExperimentID();
				curVisitID = ss.getVisitID();
			} else {
				VisitSegment vs = svmForm.getCurrentSegment().getVisitSegment();
				log.info("*** addSegment " + vs.toExpSegment().toString());
				int newSegmentID = isvm.addVisitSegmentForSubject(ui, vs);
				svmForm.setSelectedSegmentID(String.valueOf(newSegmentID));
				segmentExpID = vs.getExperimentID();
				curVisitID = vs.getVisitID();
			}

			SubjectManagementHelper.prepareCurrentSubject(dbID, ui, svmForm
					.getSelectedSubjectID(), svmForm, segmentExpID, curVisitID);

			SubjectManagementHelper.prepareSegmentTimestampList(svmForm);

			svmForm.setCurrentAsInfos();
			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();

		} catch (Exception x) {
			log.error("addSegment", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_SEGMENT);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward enrollSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> enrollSubject");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		IExperimentManagement iem = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String subjectID = svmForm.getSubject().getSubjectID();
			int expID = svmForm.getEnrollExperimentSelector()
					.getSelectedExpID();
			String researchGroupIDStr = svmForm.getSelectedResearchGroupId();

			System.out.println("subjectID: " + subjectID + " expID: " + expID
					+ " researchGroupID:" + researchGroupIDStr);
			int researchGroupID = GenUtils.toInt(researchGroupIDStr, -1);
			iem = ServiceFactory.getExperimentManagement(dbID);
			iem.enrollSubject(ui, expID, subjectID, researchGroupID);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			int selectedExpID = 0;

			// get only the experiments this subject participates
			List<Experiment> experiments = isvm.getExperimentsForSubject(ui,
					svmForm.getSelectedSubjectID());
			String[] expNames = new String[experiments.size()];

			SubjectManagementHelper.prepareExperiments(svmForm, experiments,
					expNames, selectedExpID);

		} catch (Exception x) {
			log.error("enrollSubject", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

}
