package clinical.web.common;

/**
 * An interface to check if a user is allowed to carry a particular action on the system.
 *
 * @author I. Burak Ozyurt
 * @version $Id: IAuthorizationService.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public interface IAuthorizationService {

  /**
   * Checks if a user is allowed to carry an action. An action can be taught as a privilege.
   *
   * @param userInfo a <code>UserInfo</code> object holding non-sensitive user information
   * @param dbID 
   * @param action a general object holding the description of the action to check for authorization
   * @return true if the user is allowed to carry the action
   */
   public boolean isAuthorized(UserInfo userInfo, String dbID, Object action);
}