package clinical.web.common.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;


/**
 * @author I. Burak Ozyurt
 * @version $Id: PostgresQueryProcessor.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class PostgresQueryProcessor extends AbstractQueryProcessor {

	public PostgresQueryProcessor(Class<?> valueObjectClass,
			SearchPredicateList spList) throws Exception {
		super(valueObjectClass, spList);
	}

	/**
	 * getTableName
	 * 
	 * @return String
	 */
	protected String getTableName() {
		return "nc_" + getBaseClassName(voClass.getName()).toLowerCase();
	}

	/**
	 * invokeSetter
	 * 
	 * @param m Method
	 * @param vo Object
	 * @param value Object
	 * @param colType int
	 */
	protected void invokeSetter(Method m, Object vo, Object value, int colType)
			throws InvocationTargetException, IllegalArgumentException,
			IllegalAccessException {
		if (value != null && value instanceof Long) {
			m.invoke(vo, new Object[] { new BigDecimal(value.toString()) });
		} else {
			m.invoke(vo, new Object[] { value });
		}
	}

	protected void preparePredicateDateValue(SearchPredicate sp,
			StringBuffer buf) {
		Date date = (Date) sp.getValue();
		buf.append(df.format(date)).append(' ');
	}

}
