package clinical.web.common.vo;

import java.io.Serializable;

import clinical.server.vo.Extendedtuple;

/**
 * This class acts as a unique key identifying the analysis result value for a
 * segment of a visit.
 *
 * @author I. Burak Ozyurt
 * @version $Id: ARValueKey.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ARValueKey implements Serializable {
	private static final long serialVersionUID = 1L;
	private AnalysisExTupleInfo anExTupleInfo;
	private String mgName;
	private String fieldName;
	private int etID;
	private String exTupleName;

	public ARValueKey(AnalysisExTupleInfo anExTupleInfo, String mgName,
			String fieldName, int etID) {
		super();
		this.anExTupleInfo = anExTupleInfo;
		this.mgName = mgName;
		this.fieldName = fieldName;
		this.etID = etID;
	}

	public AnalysisExTupleInfo getAnExTupleInfo() {
		return anExTupleInfo;
	}

	public String getMgName() {
		return mgName;
	}

	public String getFieldName() {
		return fieldName;
	}

	public int getEtID() {
		return etID;
	}

	public String getExtendedTupleName() {
		if (exTupleName == null) {
			for (Extendedtuple et : anExTupleInfo.getExTupleSet()) {
				if (et.getUniqueid().intValue() == etID) {
					exTupleName = et.getName();
					break;
				}
			}
		}
		return exTupleName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + etID;
		result = prime * result
				+ ((fieldName == null) ? 0 : fieldName.hashCode());
		result = prime * result + ((mgName == null) ? 0 : mgName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ARValueKey other = (ARValueKey) obj;
		if (etID != other.etID)
			return false;
		if (fieldName == null) {
			if (other.fieldName != null)
				return false;
		} else if (!fieldName.equals(other.fieldName))
			return false;
		if (mgName == null) {
			if (other.mgName != null)
				return false;
		} else if (!mgName.equals(other.mgName))
			return false;
		return true;
	}

	/**
	 * toString method: creates a String representation of the object
	 *
	 * @return the String representation
	 * @author
	 */
	public String toString() {
		StringBuilder buffer = new StringBuilder();
		buffer.append("ARValueKey::[");
		buffer.append("etID = ").append(etID);
		buffer.append(", fieldName = ").append(fieldName);
		buffer.append(", mgName = ").append(mgName);
		buffer.append("]");
		return buffer.toString();
	}

}
