package clinical.web.exception;

import java.util.List;
import java.util.LinkedList;
import java.io.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BaseException.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class BaseException extends Exception {
	private static final long serialVersionUID = 1L;
	protected Throwable rootCause;
	private Object[] messageArgs;
	private String messageKey;
	private List<BaseException> exceptions;

	public BaseException() {
		super();
	}

	public BaseException(String msg) {
		super(msg);
	}

	public BaseException(String msg, String msgKey) {
		super(msg);
		messageKey = msgKey;
	}

	public BaseException(Throwable rootCause) {
		this.rootCause = rootCause;
	}
	
	public BaseException(String message, Throwable rootCause) {
		super(message);
		this.rootCause = rootCause;
	}

	public void addException(BaseException be) {
		if (exceptions == null)
			exceptions = new LinkedList<BaseException>();
		exceptions.add(be);
	}

	public void printStackTrace() {
		printStackTrace(System.err);
	}

	public void printStackTrace(PrintStream out) {
		super.printStackTrace(out);
		if (rootCause != null) {
			rootCause.printStackTrace(out);
		}
		out.flush();
	}

	public void printStackTrace(PrintWriter writer) {
		super.printStackTrace(writer);
		if (rootCause != null) {
			rootCause.printStackTrace(writer);
		}
		writer.flush();
	}

	// ---------------------- setters --------------
	public void setRootCause(Throwable newRootCause) {
		this.rootCause = newRootCause;
	}

	public void setMessageKey(String newMessageKey) {
		this.messageKey = newMessageKey;
	}

	public void setMessageArgs(Object[] args) {
		this.messageArgs = args;
	}

	// ---------------------- getters --------------
	public Throwable getRootCause() {
		return this.rootCause;
	}

	public String getMessageKey() {
		if (this.messageKey == null) {
			this.messageKey = "errors.common";
		}
		return this.messageKey;
	}

	public List<BaseException> getExceptions() {
		return exceptions;
	}

	public Object[] getMessageArgs() {
		return this.messageArgs;
	}

}
