package clinical.web.helpers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
//import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

//import org.jfree.util.Log;
import clinical.utils.FileUtils;
//import clinical.web.actions.AnalysisResultQueryAction;
//import clinical.web.actions.SVNavigateAction.Header;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.services.BatchQueryResult;
import clinical.web.services.AssessmentServiceHelper.SiteAsiInfo;
//import clinical.web.vo.QuerySummary;
import clinical.web.vo.ASValueKey;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.VisitSegAsResultValues;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

//import com.sun.java.util.collections.Map.Entry;

/**
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryHelper.java 421 2011-08-03 19:51:58Z jinranc $
 */
public class BatchQueryHelper {	
	private static Log log = LogFactory.getLog(BatchQueryHelper.class);
	
	/*
	 * Jinran added
	 * An object class represents a header row in wide format in CSV file
	 */	
	public static class ClsHeaderRow{
		private String subjectID;
		private String siteID;
		private String expID;
		private String visitID;
		private String segID;
		private List<String> assAndScoreName = new LinkedList<String>(); //name combined with assessment name and score name
		//private String scoreValue;
		private String subjectIDValue;
		
		public void setSubjectIDValue(String value){
			this.subjectIDValue = value;
		}
		
		public String getSubjectIDValue(){
			return this.subjectIDValue;
		}
			
		public void setSubjectID(String subjectID) {
			this.subjectID = subjectID;
		}
		
		public String getSubjectID() {
			return subjectID;
		}
		
		public void setSiteID(String siteID) {
			this.siteID = siteID;
		}
		
		public String getSiteID() {
			return siteID;
		}
		
		public void setExpID(String expID) {
			this.expID = expID;
		}
		
		public String getExpID() {
			return expID;
		}
		
		public void setVisitID(String visitID) {
			this.visitID = visitID;
		}
		
		public String getVisitID() {
			return visitID;
		}
		
		public void setSegID(String segID) {
			this.segID = segID;
		}
		
		public String getSegID() {
			return segID;
		}

		public void setAssAndScoreName(List<String> assAndScoreName) {
			this.assAndScoreName = assAndScoreName;
		}

		public List<String> getAssAndScoreName() {
			return assAndScoreName;
		}		

	}
	
	/*
	 * Jinran added
	 * An object class represents a data row in wide format in CSV file 
	 */
	public static class ClsDataRow{
		private String subjectID;
		private String siteID;
		private String expID;
		private String visitID;
		private String segID;
		private HashMap<String, String> assAndScoreNameValue = new HashMap<String, String>(); //name and value combined with assessment name and score name

		public ClsDataRow(List<String> assAndScoreName){

			for(String name: assAndScoreName){
				this.assAndScoreNameValue.put(name.toString(), ".");	
			}			
		}
		
		public ClsDataRow() {
			// TODO Auto-generated constructor stub
		}

		public void setSubjectID(String subjectID) {
			this.subjectID = subjectID;
		}
		
		public String getSubjectID() {
			return subjectID;
		}
		
		public void setSiteID(String siteID) {
			this.siteID = siteID;
		}
		
		public String getSiteID() {
			return siteID;
		}
		
		public void setExpID(String expID) {
			this.expID = expID;
		}
		
		public String getExpID() {
			return expID;
		}
		
		public void setVisitID(String visitID) {
			this.visitID = visitID;
		}
		
		public String getVisitID() {
			return visitID;
		}
		
		public void setSegID(String segID) {
			this.segID = segID;
		}
		
		public String getSegID() {
			return segID;
		}

		public void setAssAndScoreNameValue(HashMap<String, String> assAndScoreNameValue) {
			this.assAndScoreNameValue = assAndScoreNameValue;
		}

		public HashMap<String, String> getAssAndScoreNameValue() {
			return assAndScoreNameValue;
		}		

	}
	
	public static void prepareCSV(BufferedWriter out, List<QuerySummary> qsList, String longFormat){
		try{
			if(longFormat.equals("long")){ // unrevised format (long)			
				outputLongFormatCSV(qsList, out, null);
			}else if(longFormat.equals("wide")){ //output in wide format
				outputWideFormatCSV(qsList, out, null);			
			}else if(longFormat.equals("wider")){
				outputWiderFormatCSV(qsList, out, null);
			}	
		}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static void prepareCSVFile(File file, BatchQueryResult bqr, String longFormat)
			throws Exception {
		
		BufferedWriter out = null;

		if(longFormat.equals("long")){ // unrevised format (long)			
			outputLongFormat(bqr, out, file);
		}else if(longFormat.equals("wide")){ 
			outputWideFormat(bqr, out, file);
		}else if(longFormat.equals("wider")){
			outputWiderFormat(bqr, out, file);
		}
	}
	
	/*
	 * Export csv file in long format: subjectId, experiment, visitId, segmentId, assessmentName, scoreName, scoreValue
	 */
	private static void outputLongFormatCSV(List<QuerySummary> qsList, BufferedWriter out, File file){
		StringBuilder buf = new StringBuilder(256);
		buf.append("SubjectID,");
		buf.append("SiteID,");
		buf.append("ExperimentID,");
		buf.append("VisitID,");
		buf.append("SegmentID,");
		buf.append("AssessmentName,");
		buf.append("ScoreName,");
		buf.append("ScoreValue");
		String header = buf.toString();

		try {
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}
			
			out.write(header);
			out.newLine();

			String[] row = new String[8];
			
			for(QuerySummary qs : qsList){
				AssessmentResultSummary ars = qs.getArs();
				for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
					row[0] = ars.getSubjectID();
					String siteID = vsarv.getSiteID();

					if (siteID == null) {
						row[1] = ars.getSubjectID().substring(0, 4);
					} else {
						row[1] = siteID;
					}

					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						row[2] = String.valueOf(ars.getExpName());
						row[3] = String.valueOf(vsarv.getVisitID());
						row[4] = String.valueOf(vsarv.getSegmentID());
						row[5] = aKey.getAsName();
						row[6] = aKey.getScoreName();
						// TODO multiple values per score
						SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);			
						row[7] = sasvs.getValue() != null ? sasvs.getValue().toString()	: ".";
						buf = new StringBuilder(200);
						for (int i = 0; i < row.length; i++) {
							buf.append(row[i]).append(',');
						}							
					}
					out.write(buf.substring(0, buf.length() - 1));
					out.newLine();
				}
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			FileUtils.close(out);
		}		
	}	

	/*
	 * Export csv file in Wide Format. SubjectId, ExperimentID, VisitId, SegmentId, Var1, Var2, ... VarN 
	 */
	private static void outputWideFormatCSV(List<QuerySummary>qsList, BufferedWriter out, File file) throws IOException{
		// Add header row
		ClsHeaderRow hdr = addHeaderRowCSV(qsList, "wide");
		
		// Add data row		
		List<ClsDataRow> dataRowList = addDataRowCSV(qsList, hdr, "wide");
		
		// export to csv file
		exportFile(file, out, hdr, dataRowList, "wide");							
	}
	
	/*
	 * Export csv file in Wider Format. SubjectId, ExperimentID, Var1_visit1, Var1_visit2, ... VarN_visit1, varN_visitN 
	 */
	private static void outputWiderFormatCSV(List<QuerySummary> qsList, BufferedWriter out, File file){
		ClsHeaderRow hdr = addHeaderRowCSV(qsList, "wider");
		
		List<ClsDataRow> dataRowList = addDataRowCSV(qsList, hdr, "wider"); 

		exportFile(file, out, hdr, dataRowList, "wider");				
	}

	private static List<ClsDataRow> addDataRowCSV(List<QuerySummary> qsList,
			ClsHeaderRow hdr, String format) {
		List<ClsDataRow> dataRowList = new LinkedList<ClsDataRow>();				
		
		for(QuerySummary qs : qsList){
			AssessmentResultSummary ars = qs.getArs();
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				String name = new String();
				ClsDataRow dr = new ClsDataRow();
				if(format.equals("wide")||format.equals("long")){
					dr = dataRowContainsSubject(dataRowList, ars.getSubjectID(), vsarv.getSiteID(), 
							String.valueOf(ars.getExpName()), String.valueOf(vsarv.getVisitID()), String.valueOf(vsarv.getSegmentID()));					
				}else if(format.equals("wider")){
					dr = dataRowContainsSubject(dataRowList, ars.getSubjectID(), vsarv.getSiteID(), 
							String.valueOf(ars.getExpName()));
				}
				
				if(dr!=null){
					String asName = null;	
					String scoreName = null;
					StringBuilder sb = new StringBuilder();
					
					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						asName = aKey.getAsName();
						scoreName = aKey.getScoreName();
						sb.append(asName);
						sb.append("_");
						sb.append(scoreName);
						if(format.equals("wider")){
							sb.append("_Visit");
							sb.append(vsarv.getVisitID());
							sb.append("_Seg");
							sb.append(vsarv.getSegmentID());
						}
						sb.append(",");
						name = replaceWithUnderScore(sb.toString());

						if(dr.getAssAndScoreNameValue().containsKey(name)){
							SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);								
							String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
							dr.getAssAndScoreNameValue().put(name, score);
						}else{
							log.info("Error in creating header columns.");
						}
					}
				}else{
					//Subject does not exist in DataRowList
					//create a new clsDataRow
					ClsDataRow dataRow = new ClsDataRow(); 
					if(hdr!=null){
						dataRow  = new ClsDataRow(hdr.assAndScoreName);							
					}
					dataRow.subjectID = ars.getSubjectID();
					dataRow.siteID = vsarv.getSiteID();
					if (dataRow.siteID == null) {
						dataRow.siteID = ars.getSubjectID().substring(0, 4);
					} 
					
					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						String asName = null;
						String scoreName = null;
						
						asName = aKey.getAsName();
						scoreName = aKey.getScoreName();
						
						dataRow.expID =ars.getExpName();
						
						if(!format.equals("wider")){
							dataRow.visitID =String.valueOf(vsarv.getVisitID());
							dataRow.segID = String.valueOf(vsarv.getSegmentID());
						}
						
						StringBuilder sb = new StringBuilder();
						sb.append(asName);
						sb.append("_");
						sb.append(scoreName);
						if(format.equals("wider")){
							sb.append("_Visit");
							sb.append(vsarv.getVisitID());
							sb.append("_Seg");
							sb.append(vsarv.getSegmentID());
						}
						sb.append(",");
						name = replaceWithUnderScore(sb.toString());
						if(dataRow.getAssAndScoreNameValue().containsKey(name)){
							SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);
							String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
							dataRow.getAssAndScoreNameValue().put(name, score);
						}else{
							log.info("Error in creating header columns.");
						}
					}
					dataRowList.add(dataRow);
				}
				
			}
		}
		return dataRowList;
	}

	private static ClsHeaderRow addHeaderRowCSV(List<QuerySummary> qsList, String format) {
		ClsHeaderRow hdr = new ClsHeaderRow();
		hdr.subjectID = "SubjectID,";
		hdr.siteID =	"SiteID,";
		hdr.expID = "Experiment,";
		if(format.equals("wide")||format.equals("long")){
			hdr.visitID = "VisitID,";
			hdr.segID = "SegmentID,";
		}
		
		// Add Header row		
		String ass_scoreName;
		
		for(QuerySummary qs : qsList){
			AssessmentResultSummary ars = qs.getArs();
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				//get assessment name and score name
				String siteID = vsarv.getSiteID();
				if (siteID == null) {
					siteID = ars.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				String scoreName = null;			
				for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
					asName = aKey.getAsName();
					scoreName = aKey.getScoreName();
					
					StringBuilder sb = new StringBuilder();
					sb.append(asName);
					sb.append("_");
					sb.append(scoreName);
					if(format.equals("wider")){
						sb.append("_Visit");
						sb.append(vsarv.getVisitID());
						sb.append("_Seg");
						sb.append(vsarv.getSegmentID());
					}
					sb.append(",");
					ass_scoreName = sb.toString();
					
					//replace non-alphabet or non-underscore with underscore
					ass_scoreName = replaceWithUnderScore(ass_scoreName);
					
					//add column name to header row if not exists in hdr object
					Boolean bExist = false;
					if(hdr.assAndScoreName!=null){
						for(String st: hdr.assAndScoreName){
							if(ass_scoreName.equals(st)){
								bExist = true;
								break;
							}
						}	
					}					
					if(!bExist){
						hdr.assAndScoreName.add(ass_scoreName);
						java.util.Collections.sort(hdr.assAndScoreName);
					}
				}	
			}
		}
		return hdr;
	}
	
	private static void exportFile(File file, BufferedWriter out, ClsHeaderRow hdr, List<ClsDataRow> dataRowList, 
			String longFormat){		
		//output to csv		
		try{		
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}
			
			StringBuilder buf = new StringBuilder();
			
			//write header first
			buf.append(hdr.subjectID);
			buf.append(hdr.siteID);
			buf.append(hdr.expID);
			if(longFormat.equals("wide")||longFormat.equals("long")){
				buf.append(hdr.visitID);
				buf.append(hdr.segID);
			}
			for(String sName : hdr.assAndScoreName){
				buf.append(sName);
			}
			buf.deleteCharAt(buf.length()-1);
			out.write(buf.toString());
			out.newLine();
			
			//write datarow				
			for(ClsDataRow drow : dataRowList){
				buf = new StringBuilder();
				buf.append(drow.subjectID);
				buf.append(",");
				buf.append(drow.siteID);
				buf.append(",");
				buf.append(drow.expID);
				buf.append(",");
				if(longFormat.equals("wide")||longFormat.equals("wide")){
					buf.append(drow.visitID);
					buf.append(",");
					buf.append(drow.segID);
					buf.append(",");
				}
				
				for(String sName : hdr.assAndScoreName){
					Boolean bFind = false;
					for(Map.Entry<String,String> entry : drow.assAndScoreNameValue.entrySet()){
						if(entry.getKey().equals(sName)){
							buf.append(entry.getValue().toString());
							buf.append(",");
							bFind = true;
							break;
						}							
					}	
					if(bFind.equals(false)){
						buf.append(".");
						buf.append(",");
					}
				}					
				
				buf.deleteCharAt(buf.length()-1);
				out.write(buf.toString());
				out.newLine();
			}
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally{
			FileUtils.close(out);
		}
	}

	/*
	 * Export batch query results in long format: subjectId, experiment, visitId, segmentId, assessmentName, scoreName, scoreValue
	 */
	private static void outputLongFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		StringBuilder buf = new StringBuilder(256);
		buf.append("SubjectID,");
		buf.append("SiteID,");
		buf.append("ExperimentID,");
		buf.append("VisitID,");
		buf.append("SegmentID,");
		buf.append("AssessmentName,");
		buf.append("ScoreName,");
		buf.append("ScoreValue");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		Set<String> seenSites = new HashSet<String>(17);
		for (Map.Entry<String, SiteAsiInfo> entry : bqr.getSaiMap().entrySet()) {
			String siteID = entry.getKey();
			if (!seenSites.contains(siteID.toUpperCase())) {
				theSite = siteID.toUpperCase();
				seenSites.add(theSite);
			}
			SiteAsiInfo sai = entry.getValue();

			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuffer keyBuf = new StringBuffer(asi.getAssessmentID()
						.toString());
				keyBuf.append('_').append(siteID.toUpperCase());
				map.put(keyBuf.toString(), asi.getName());
			}
		}
		if (seenSites.size() > 1) {
			theSite = null;
		}

		try {
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				String siteID = sasvs.getSiteID();

				if (siteID == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = siteID;
				}

				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(siteID.toUpperCase());
				asName = map.get(keyBuf.toString());
				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				row[5] = asName;
				row[6] = sasvs.getScoreName();
				// TODO multiple values per score
				row[7] = sasvs.getValue() != null ? sasvs.getValue().toString()
						: ".";
				buf = new StringBuilder(200);
				for (int i = 0; i < row.length; i++) {
					buf.append(row[i]).append(',');
				}
				out.write(buf.substring(0, buf.length() - 1));
				out.newLine();
			}

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			FileUtils.close(out);
		}		
	}

	/*
	 * Export batch query results in Wide Format. SubjectId, ExperimentID, VisitId, SegmentId, Var1, Var2, ... VarN 
	 */
	private static void outputWideFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		ClsHeaderRow hdr = new ClsHeaderRow();
		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		
		addHeaderToFile(bqr, hdr,map, theSite, "wide");
		
		List<ClsDataRow> dataRowList = addDataRowToFile(bqr, hdr, map,
					theSite, "wide");

		exportFile(file, out, hdr,dataRowList, "wide");						
	}

	/*
	 * Export batch query results in Wider Format. SubjectId, ExperimentID, Var1_visit1, Var1_visit2, ... VarN_visit1, varN_visitN 
	 */
	private static void outputWiderFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		ClsHeaderRow hdr = new ClsHeaderRow();
		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		
		theSite = addHeaderToFile(bqr, hdr, map, theSite, "wider");
	
		List<ClsDataRow> dataRowList = addDataRowToFile(bqr, hdr, map,
					theSite, "wider");

		exportFile(file, out, hdr, dataRowList, "wider");		
	}

	private static List<ClsDataRow> addDataRowToFile(BatchQueryResult bqr,
			ClsHeaderRow hdr, Map<String, String> map, String theSite, String format) {
		List<ClsDataRow> dataRowList = new LinkedList<ClsDataRow>();				
						
		for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
			String name = new String();
			ClsDataRow dr = new ClsDataRow();
			if(format.equals("wide")||format.equals("long")){
				dr = dataRowContainsSubject(dataRowList, sasvs.getSubjectID(), sasvs.getSiteID(), 
						String.valueOf(sasvs.getExperimentID()), String.valueOf(sasvs.getVisitID()), String.valueOf(sasvs.getSegmentID()));
			}else if(format.equals("wider")){
				dr = dataRowContainsSubject(dataRowList, sasvs.getSubjectID(), sasvs.getSiteID(), 
						String.valueOf(sasvs.getExperimentID()));
			}
			
			if(dr!=null){
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(dr.siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}
					
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");
				name = replaceWithUnderScore(sb.toString());
				
				if(dr.getAssAndScoreNameValue().containsKey(name)){
					String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
					dr.getAssAndScoreNameValue().put(name, score);
				}else{
					log.info("Error in creating header columns.");
				}
			}else{
				//Subject does not exist in DataRowList
				//create a new clsDataRow
				ClsDataRow dataRow = new ClsDataRow(); 
				if(hdr!=null){
					dataRow  = new ClsDataRow(hdr.assAndScoreName);							
				}
				dataRow.subjectID = sasvs.getSubjectID();
				dataRow.siteID = sasvs.getSiteID();
				if (dataRow.siteID == null) {
					dataRow.siteID = sasvs.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(dataRow.siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}

				dataRow.expID =String.valueOf(sasvs.getExperimentID());
				if(format.equals("wide")||format.equals("long")){
					dataRow.visitID =String.valueOf(sasvs.getVisitID());
					dataRow.segID = String.valueOf(sasvs.getSegmentID());
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");
				name = replaceWithUnderScore(sb.toString());
				
				if(dataRow.getAssAndScoreNameValue().containsKey(name)){
					String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
					dataRow.getAssAndScoreNameValue().put(name, score);
				}else{
					log.info("Error in creating header columns.");
				}
				
				dataRowList.add(dataRow);
			}					
		}
		return dataRowList;
	}

	private static String addHeaderToFile(BatchQueryResult bqr,
			ClsHeaderRow hdr, Map<String, String> map, String theSite, String format) {
		hdr.subjectID = "SubjectID,";
		hdr.siteID =	"SiteID,";
		hdr.expID = "ExperimentID,";		
		if(format.equals("wide")||format.equals("long")){
			hdr.visitID = "VisitID,";
			hdr.segID = "SegmentID,";	
		}
		
		Set<String> seenSites = new HashSet<String>(17);
		for (Map.Entry<String, SiteAsiInfo> entry : bqr.getSaiMap().entrySet()) {
			String siteID = entry.getKey();
			if (!seenSites.contains(siteID.toUpperCase())) {
				theSite = siteID.toUpperCase();
				seenSites.add(theSite);
			}
			SiteAsiInfo sai = entry.getValue();

			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuffer keyBuf = new StringBuffer(asi.getAssessmentID()
						.toString());
				keyBuf.append('_').append(siteID.toUpperCase());
				map.put(keyBuf.toString(), asi.getName());
			}
		}
		if (seenSites.size() > 1) {
			theSite = null;
		}
		
		// Add Header row
		String ass_scoreName;
		
		//Create header row by looping the subject score list. Var1_Visit1_Seg1, Var1_Visit1_Seg2, Var1_Visit2_Seg1, Var1_Visit2_Seg2, Var... 
		for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				//get assessment name and score name
				String siteID = sasvs.getSiteID();
				if (siteID == null) {
					siteID = sasvs.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");
				ass_scoreName = sb.toString();
				
				//replace non-alphabet or non-underscore with underscore
				ass_scoreName = replaceWithUnderScore(ass_scoreName);

				//add column name to header row if not exists in hdr object
				Boolean bExist = false;
				if(hdr.assAndScoreName!=null){
					for(String st: hdr.assAndScoreName){
						if(ass_scoreName.equals(st)){
							bExist = true;
							break;
						}
					}	
				}					
				if(!bExist){
					hdr.assAndScoreName.add(ass_scoreName);
					java.util.Collections.sort(hdr.assAndScoreName);
				}
		}
		return theSite;
	}
	
	private static ClsDataRow dataRowContainsSubject(List<ClsDataRow> lst, String subId, String siteId, 
			String expId, String visitId, String segId){
		ClsDataRow result = null;
		
		for(ClsDataRow dr : lst){
			if(dr.subjectID.equals(subId)){
				if(dr.siteID.equals(siteId)){
					if(dr.expID.equals(expId)){
						if(dr.visitID.equals(visitId)){
							if(dr.segID.equals(segId)){
								result = new ClsDataRow();
								result = dr;
								return result;
							}
						}
					}
				}
			}			
		}
		return result;
	}
	
	private static ClsDataRow dataRowContainsSubject(List<ClsDataRow> lst, String subId, String siteId, String expId){
		ClsDataRow result = null;
		
		for(ClsDataRow dr : lst){
			if(dr.subjectID.equals(subId)){
				if(dr.siteID.equals(siteId)){
					if(dr.expID.equals(expId)){
						result = new ClsDataRow();
						result = dr;
						return result;						
					}
				}
			}			
		}
		return result;
	}

	public static void prepareCSVFile(File file,
			List<AssessmentSelectionInfo> asiList, BatchQueryResult bqr)
			throws Exception {
		BufferedWriter out = null;

		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");
		buf.append("Experiment ID,");
		buf.append("Visit ID,");
		buf.append("Segment ID,");
		buf.append("Assessment Name,");
		buf.append("Score Name,");
		buf.append("Score Value");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		for (SiteAsiInfo sai : bqr.getSaiMap().values()) {
			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuilder sb = new StringBuilder(sai.getSiteID());
				sb.append('_').append(asi.getAssessmentID().toString());
				map.put(sb.toString(), asi.getName());
			}
		}

		try {
			out = new BufferedWriter(new FileWriter(file));

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				if (sasvs.getSiteID() == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = sasvs.getSiteID();
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				StringBuilder sb = new StringBuilder();
				// TODO assumption: the first 4 digits of the BIRN ID indicates
				// the acquisition AND retrieval site ID
				// if siteID is not explicitly specified.
				if (sasvs.getSiteID() != null) {
					sb.append(sasvs.getSiteID());
				} else {
					sb.append(sasvs.getSubjectID().substring(0, 4));
				}
				sb.append('_').append(sasvs.getAssessmentID());
				String key = sb.toString();
				row[5] = map.get(key);
				row[6] = sasvs.getScoreName();
				if (sasvs.isMultiValued()) {
					for (Object value : sasvs.getValues()) {
						row[7] = value != null ? value.toString() : ".";
						writeRow(out, row);
					}
				} else {
					row[7] = sasvs.getValue() != null ? sasvs.getValue()
							.toString() : ".";
					writeRow(out, row);
				}

			}

		} finally {
			FileUtils.close(out);
		}
	}

	protected static void writeRow(BufferedWriter out, String[] row)
			throws IOException {
		StringBuilder sb;
		sb = new StringBuilder(200);
		for (int i = 0; i < row.length; i++) {
			sb.append(row[i]).append(',');
		}
		out.write(sb.substring(0, sb.length() - 1));
		out.newLine();
	}

	protected static String replaceWithUnderScore(String str){
		String tempStr = str; 
		
		for(int i = 0; i<tempStr.length()-1; i++){
			char ch = tempStr.charAt(i);
			
			if(Character.isLetter(ch)){
				continue;
			}else if(ch == '_'){
				continue;
			}else if(Character.isDigit(ch)){
				continue;
			}
			else{
				tempStr = tempStr.replace(ch, '_');				
			}			
		}
		
		return tempStr;
	}
}
