package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

/**
 * @author I. Burak Ozyurt
 * @version $Id: TransformationInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class TransformationInfo {
	protected String package_;
	protected String packageVersion;
	protected String transform;
	protected String transformVersion;
	protected String description;
	protected List<TransformArgInfo> argList = new ArrayList<TransformArgInfo>(
			5);

	public TransformationInfo(String package_, String packageVersion,
			String transform, String transformVersion) {
		super();
		this.package_ = package_;
		this.packageVersion = packageVersion;
		this.transform = transform;
		this.transformVersion = transformVersion;
	}

	public TransformationInfo() {
	}

	public String getPackage() {
		return package_;
	}

	public String getPackageVersion() {
		return packageVersion;
	}

	public String getTransform() {
		return transform;
	}

	public String getTransformVersion() {
		return transformVersion;
	}

	public void setPackage(String package_) {
		this.package_ = package_;
	}

	public void setPackageVersion(String packageVersion) {
		this.packageVersion = packageVersion;
	}

	public void setTransform(String transform) {
		this.transform = transform;
	}

	public void setTransformVersion(String transformVersion) {
		this.transformVersion = transformVersion;
	}

	public void addArgument(TransformArgInfo arg) {
		if (!argList.contains(arg)) {
			argList.add(arg);
		}
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("TransformationInfo::[");
		buf.append("transform=").append(transform);
		buf.append(",transformVersion=").append(transformVersion);
		buf.append(",package=").append(package_);
		buf.append(",packageVersion=").append(packageVersion);
		buf.append(']');
		return buf.toString();
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<TransformArgInfo> getArgList() {
		return argList;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((transform == null) ? 0 : transform.hashCode());
		result = prime
				* result
				+ ((transformVersion == null) ? 0 : transformVersion.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TransformationInfo other = (TransformationInfo) obj;
		if (transform == null) {
			if (other.transform != null)
				return false;
		} else if (!transform.equals(other.transform))
			return false;
		if (transformVersion == null) {
			if (other.transformVersion != null)
				return false;
		} else if (!transformVersion.equals(other.transformVersion))
			return false;
		return true;
	}
}
