<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic"%>

<div class="error"><html:errors /></div>
<br>
<br>

<script>
   var helpSystem = null;
//    window.onload = onLoadHandler;
   window.addOnLoadListener(onLoadHandler);
   
   function validate(form) {

      if (form.action.value == 'Change Group') {
         if ( form.studyGroupValue.selectedIndex == -1 ||
           form.enrolledSubjectValue.selectedIndex == -1 )
         {
            alert('You need to select a study group and an enrolled subject to continue with Group Change!');
            return false;
         }
      } else if ( form.action.value == 'Unenroll') {
         var ok = confirm('Do you want to unenroll the subject from the experiment?');
         if (ok) { 
           if ( form.enrolledSubjectValue.selectedIndex == -1 )
           {
              alert('You need to select an enrolled subject to continue with unenroll operation!');
              return false;
           } 
         } else {
            return false;
         } 
      }
      return true;
   }

   function subjectSelected(selectElem) {
      var selOption = selectElem.options[ selectElem.selectedIndex ];
      // alert('selectOption = ' + selOption.value);
      var form = selectElem.form;
      form.action.value="<bean:message key="action.jump_to_subject"/>";
      form.submit();
   }

   function go(elem, action_value) {
      var form = elem.form;
      form.action.value = action_value;
   }

   function onLoadHandler() {
      var options = [];
      var url = '<html:rewrite page="/help.do?context=man_experiments"/>';
      helpSystem = new bal.AjaxHelpSystem(url, options); 
   }
</script>
<style>
div.mainPanel {
     background-color: #d3d3d3;
     float:left;
     margin-left:10px;
     padding-bottom: 1em;
     width: 70%;
}

div.headerPane {
  text-align:left; 
  margin:0; 
  padding-top:15px;
  padding-bottom:0px;
  background-color:#ffcc33; 
  height:35px;
}

.input_div {
   padding-top:5px;
   padding-left:5px;
 }


.button_div {
   padding-top:5px;
   padding-left:5px;
	text-align:right;
}

.label {
	font-weight: bold;
} 

label {
	width: 10em;
	float:left;
	text-align: right;
	margin-right:0.5em;
	display:block;
}
</style>

<html:form action="/expman" onsubmit="return validate(this)">
<div id="expManPane" class="mainPanel">
  <div class="headerPane">
       <div class="mlarge" style="margin:0 0 0 5px; padding:0;">Experiment Information</div>
  </div>
  <div>
		<input type="hidden" name="action" value="" />
		<div class="input_div">
		  <label><span class="label" title="Name of the selected experiment">Experiment Name:</span></label>
		  <bean:write name="expForm" property="experimentInfo.name" />
		</div>
		<div class="input_div">
		 <label><span class="label" title="Name of the contact person for this experiment">Contact Name:</span></label>
  		 <bean:define id="contactPersons" name="expForm" property="experimentInfo.contactPersonsLVBeans" type="java.util.Collection" /> 
		 <html:select name="expForm" property="experimentInfo.contactPersonValue">
			<html:options collection="contactPersons" property="value" labelProperty="label" />
 		 </html:select> 
		</div>
		<div class="input_div">
			<label><span class="label">Last Modified:</span></label>
			<bean:write name="expForm" property="experimentInfo.modTime" />
		</div>
		<div class="input_div">
			<label><span class="label">Base URI:</span></label>
			<bean:write name="expForm" property="experimentInfo.baseURI" />
		</div>
		<div class="input_div">
			<label><span class="label">Storage Type:</span></label>
			<bean:write name="expForm" property="experimentInfo.storageType" />
		</div>
		<div class="input_div">
			<label><span class="label" title="Description of this experiment">Description:</span></label>
			<html:textarea name="expForm" property="experimentInfo.description" cols="50" rows="5" />
		</div>
		<div class="button_div">
			<html:submit onclick="go(this,'Update')" title="Saves Experiment to Database" styleClass="submit-button">
						<bean:message key="button.exp_update" />
					</html:submit>
		</div>
		<hr></hr>

		<div class="input_div">
				<label><span class="label" title="Experimental groups defined for this experiment">Study Groups:</span></label>
				<bean:define id="studygroups" name="expForm" property="studyGroupLVBeans" type="java.util.Collection" /> 
				<html:select name="expForm" property="studyGroupValue">
					<html:options collection="studygroups" property="value" labelProperty="label" />
				</html:select> &nbsp; 
				<html:submit title="Add a new experimental group"
					onclick="go(this,'Add Study Group')" styleClass="submit-button">
				  <bean:message key="button.show_add_studygroup" />
				</html:submit> 
				<span id="help_4">
					<button onclick="return helpHandler('help_4')">
					<img align="middle" class="help_button" src="images/questionmark.png" width="19" height="19"></button>
				</span>
		</div>
		<%-- enrolled subjects section --%>
		<div class="input_div">
			<label><span class="label" title="Subjects who are enrolled in this study">Enrolled Subjects:</span></label>
			<html:submit title="Changes the group assignment of the currently selected subject to the selected study group"
					onclick="go(this,'Change Group')" styleClass="submit-button">
						<bean:message key="button.change_group" /> 
			 </html:submit> &nbsp; 
			 <html:submit title="Enrolls a subject in the experiment"
				onclick="go(this,'Enroll')" styleClass="submit-button">
					<bean:message key="button.subject_show_enroll" />
		  	 </html:submit> &nbsp; 
			 <html:submit title="Unenrolls the currently selected subject"
					onclick="go(this,'Unenroll')" styleClass="submit-button">
				<bean:message key="button.subject_unenroll" />
			 </html:submit> 
			 <span id="help_5">
				<button onclick="return helpHandler('help_5')"><img class="help_button" src="images/questionmark.png" width="19" height="19"></button>
			 </span>
		 </div>
		<div class="input_div">
		      <label>&nbsp</label>
				<bean:define id="enrolledSubjects" name="expForm" property="enrolledSubjectLVBeans" type="java.util.Collection" /> 
				<html:select name="expForm" property="enrolledSubjectValue" size="5"
										ondblclick="subjectSelected(this)">
					<html:options collection="enrolledSubjects" property="value" labelProperty="label" />
				</html:select> 
				<span id="help_6"> 
				   <button onclick="return helpHandler('help_6')"><img class="help_button" src="images/questionmark.png" width="19" height="19"></button>
				</span>
		</div>
  </div>
</div>
</html:form>

<script>
     var divElem = $('expManPane');
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     
</script>
