
create or replace procedure CREATE_RATER(rater_name_in varchar2,
  first_name_in varchar2, last_name_in varchar2, email_in varchar2,
  owner_id_in number)
as
  cursor person_cur is select uniqueid from nc_person 
     where FIRST_NAME = first_name_in and LAST_NAME = last_name_in;
  cursor du_cur is select uniqueid from nc_databaseuser where 
     name = rater_name_in and 
     userclass=(select uniqueid from nc_userclass where name='researcher');
  rater_id number := -1;
  person_id number := -1;
begin
 open person_cur;
 loop 
   fetch person_cur into person_id;
   if person_cur%NOTFOUND then
     close person_cur;
     exit;
   end if;
 end loop;
 close person_cur;
 if person_id = -1 then
   select uid_seq.nextval INTO person_id from dual;
   insert into nc_person (UNIQUEID,TABLEID,OWNER,
        MODTIME,MODUSER,FIRST_NAME, LAST_NAME, EMAIL)
     values(person_id, get_table_id('nc_person'), owner_id_in, 
       SYSDATE, owner_id_in, first_name_in,
        last_name_in, email_in);
 end if;
 open du_cur;
 loop
   fetch du_cur into rater_id;
   if du_cur%NOTFOUND then
     close du_cur;
     exit;
   end if;
 end loop;
 close du_cur;
 dbms_output.put_line('rater_id = ' || rater_id || ' person_id=' || person_id);
 if rater_id = -1 then
   select uid_seq.nextval INTO rater_id from dual;
   insert into nc_databaseUser ( UNIQUEID,NAME,TABLEID,
            OWNER, MODTIME, MODUSER, USERCLASS,USERSTATUS,
            ISGROUP,PERSONID)
     values(rater_id, 
            UPPER(rater_name_in), 
            get_table_id('nc_databaseuser'), owner_id_in, 
            SYSDATE, owner_id_in,
            (select uniqueid from nc_userclass where name='researcher'),
            (select uniqueid from nc_userstatus where userstatus='active'),
             0, 
             person_id);
 end if;
 commit;
end;
/


-- example usage

-- call CREATE_RATER('FBIRN_TEST2','Burak','Ozyurt','iozyurt@ucsd.edu',89);
--
