package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Assessmentboolean;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AssessmentbooleanDAO implements
		clinical.server.dao.AssessmentbooleanDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AssessmentbooleanDAO() {
	}

	public void insert(Connection con, Assessmentboolean bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ASSESSMENTBOOLEAN ");
			buf
					.append(" (TABLEID,NC_ASSESSMENTDATA_UNIQUEID,SCOREORDER,OWNER,MODTIME,MODUSER,TEXTVALUE,TEXTNORMVALUE,COMMENTS,DATAVALUE,DATANORMVALUE,STOREDASSESSMENTID,ASSESSMENTID,SCORENAME,SCORETYPE,ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID,CLASSIFICATION,NC_DATACLASSIFICATION_UNIQUEID,UNIQUEID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 24; ++i) {
				buf.append('?');
				if (i < 23)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean
					.getNcAssessmentdataUniqueid(), Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getScoreorder(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(5, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(6, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(7, (String) bean.getTextvalue(), Types.VARCHAR);
			ps.setObject(8, (String) bean.getTextnormvalue(), Types.VARCHAR);
			ps.setObject(9, OracleUtils.getCLOB(con, bean.getComments()),
					Types.CLOB);
			ps.setObject(10, boolean2Number((Boolean) bean.getDatavalue()),
					Types.NUMERIC);
			ps.setObject(11, boolean2Number((Boolean) bean.getDatanormvalue()),
					Types.NUMERIC);
			ps.setObject(12, (java.math.BigDecimal) bean
					.getStoredassessmentid(), Types.NUMERIC);
			ps.setObject(13, (java.math.BigDecimal) bean.getAssessmentid(),
					Types.NUMERIC);
			ps.setObject(14, (String) bean.getScorename(), Types.VARCHAR);
			ps.setObject(15, (String) bean.getScoretype(), Types.VARCHAR);
			ps.setObject(16, boolean2Number((Boolean) bean.getIsvalidated()),
					Types.NUMERIC);
			ps.setObject(17, boolean2Number((Boolean) bean.getIsranked()),
					Types.NUMERIC);
			ps.setObject(18, (String) bean.getSubjectid(), Types.VARCHAR);
			ps.setObject(19, (java.math.BigDecimal) bean.getEntryid(),
					Types.NUMERIC);
			ps.setObject(20, (java.math.BigDecimal) bean.getKeyerid(),
					Types.NUMERIC);
			ps.setObject(21, (java.math.BigDecimal) bean.getRaterid(),
					Types.NUMERIC);
			ps.setObject(22, (java.math.BigDecimal) bean.getClassification(),
					Types.NUMERIC);
			ps.setObject(23, (java.math.BigDecimal) bean
					.getNcDataclassificationUniqueid(), Types.NUMERIC);
			ps.setObject(24, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Assessmentboolean bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TABLEID");
		buf.append(',');
		buf.append("NC_ASSESSMENTDATA_UNIQUEID");
		buf.append(',');
		buf.append("SCOREORDER");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("TEXTVALUE");
		buf.append(',');
		buf.append("TEXTNORMVALUE");
		buf.append(',');
		buf.append("COMMENTS");
		buf.append(',');
		buf.append("DATAVALUE");
		buf.append(',');
		buf.append("DATANORMVALUE");
		buf.append(',');
		buf.append("STOREDASSESSMENTID");
		buf.append(',');
		buf.append("ASSESSMENTID");
		buf.append(',');
		buf.append("SCORENAME");
		buf.append(',');
		buf.append("SCORETYPE");
		buf.append(',');
		buf.append("ISVALIDATED");
		buf.append(',');
		buf.append("ISRANKED");
		buf.append(',');
		buf.append("SUBJECTID");
		buf.append(',');
		buf.append("ENTRYID");
		buf.append(',');
		buf.append("KEYERID");
		buf.append(',');
		buf.append("RATERID");
		buf.append(',');
		buf.append("CLASSIFICATION");
		buf.append(',');
		buf.append("NC_DATACLASSIFICATION_UNIQUEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessmentboolean bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getNcAssessmentdataUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_ASSESSMENTDATA_UNIQUEID=?");
			qi.values.add(bean.getNcAssessmentdataUniqueid());
			valueSet = true;
		}
		if (bean.getScoreorder() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCOREORDER=?");
			qi.values.add(bean.getScoreorder());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TEXTVALUE=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getTextnormvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TEXTNORMVALUE=?");
			qi.values.add(bean.getTextnormvalue());
			valueSet = true;
		}
		if (bean.getComments() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMMENTS=?");
			qi.values.add(bean.getComments());
			valueSet = true;
		}
		if (bean.getDatavalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATAVALUE=?");
			qi.values.add(boolean2Number((Boolean) bean.getDatavalue()));
			valueSet = true;
		}
		if (bean.getDatanormvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATANORMVALUE=?");
			qi.values.add(boolean2Number((Boolean) bean.getDatanormvalue()));
			valueSet = true;
		}
		if (bean.getStoredassessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("STOREDASSESSMENTID=?");
			qi.values.add(bean.getStoredassessmentid());
			valueSet = true;
		}
		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTID=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getScorename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORENAME=?");
			qi.values.add(bean.getScorename());
			valueSet = true;
		}
		if (bean.getScoretype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORETYPE=?");
			qi.values.add(bean.getScoretype());
			valueSet = true;
		}
		if (bean.getIsvalidated() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISVALIDATED=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsvalidated()));
			valueSet = true;
		}
		if (bean.getIsranked() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISRANKED=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsranked()));
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SUBJECTID=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getEntryid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ENTRYID=?");
			qi.values.add(bean.getEntryid());
			valueSet = true;
		}
		if (bean.getKeyerid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("KEYERID=?");
			qi.values.add(bean.getKeyerid());
			valueSet = true;
		}
		if (bean.getRaterid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("RATERID=?");
			qi.values.add(bean.getRaterid());
			valueSet = true;
		}
		if (bean.getClassification() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CLASSIFICATION=?");
			qi.values.add(bean.getClassification());
			valueSet = true;
		}
		if (bean.getNcDataclassificationUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_DATACLASSIFICATION_UNIQUEID=?");
			qi.values.add(bean.getNcDataclassificationUniqueid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessmentboolean bean,
			Assessmentboolean criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ASSESSMENTBOOLEAN SET ");

		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getNcAssessmentdataUniqueid() != null
				|| bean.isNull("ncAssessmentdataUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_ASSESSMENTDATA_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcAssessmentdataUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncAssessmentdataUniqueid"),
					uqi);
			valueSet = true;
		}
		if (bean.getScoreorder() != null || bean.isNull("scoreorder")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCOREORDER=? ");
			uqi.setValues.add(bean.getScoreorder());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoreorder"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TEXTVALUE=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getTextnormvalue() != null || bean.isNull("textnormvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TEXTNORMVALUE=? ");
			uqi.setValues.add(bean.getTextnormvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textnormvalue"), uqi);
			valueSet = true;
		}
		if (bean.getComments() != null || bean.isNull("comments")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMMENTS=? ");
			uqi.setValues.add(bean.getComments());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("comments"), uqi);
			valueSet = true;
		}
		if (bean.getDatavalue() != null || bean.isNull("datavalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATAVALUE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getDatavalue()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("datavalue"), uqi);
			valueSet = true;
		}
		if (bean.getDatanormvalue() != null || bean.isNull("datanormvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATANORMVALUE=? ");
			uqi.setValues
					.add(boolean2Number((Boolean) bean.getDatanormvalue()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("datanormvalue"), uqi);
			valueSet = true;
		}
		if (bean.getStoredassessmentid() != null
				|| bean.isNull("storedassessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("STOREDASSESSMENTID=? ");
			uqi.setValues.add(bean.getStoredassessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("storedassessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTID=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getScorename() != null || bean.isNull("scorename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORENAME=? ");
			uqi.setValues.add(bean.getScorename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorename"), uqi);
			valueSet = true;
		}
		if (bean.getScoretype() != null || bean.isNull("scoretype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORETYPE=? ");
			uqi.setValues.add(bean.getScoretype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoretype"), uqi);
			valueSet = true;
		}
		if (bean.getIsvalidated() != null || bean.isNull("isvalidated")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISVALIDATED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsvalidated()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isvalidated"), uqi);
			valueSet = true;
		}
		if (bean.getIsranked() != null || bean.isNull("isranked")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISRANKED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsranked()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isranked"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SUBJECTID=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getEntryid() != null || bean.isNull("entryid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ENTRYID=? ");
			uqi.setValues.add(bean.getEntryid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("entryid"), uqi);
			valueSet = true;
		}
		if (bean.getKeyerid() != null || bean.isNull("keyerid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("KEYERID=? ");
			uqi.setValues.add(bean.getKeyerid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("keyerid"), uqi);
			valueSet = true;
		}
		if (bean.getRaterid() != null || bean.isNull("raterid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("RATERID=? ");
			uqi.setValues.add(bean.getRaterid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("raterid"), uqi);
			valueSet = true;
		}
		if (bean.getClassification() != null || bean.isNull("classification")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CLASSIFICATION=? ");
			uqi.setValues.add(bean.getClassification());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("classification"), uqi);
			valueSet = true;
		}
		if (bean.getNcDataclassificationUniqueid() != null
				|| bean.isNull("ncDataclassificationUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_DATACLASSIFICATION_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcDataclassificationUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(
					bean.isNull("ncDataclassificationUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Assessmentboolean createObject(ResultSet rs) throws SQLException {
		Assessmentboolean obj = new Assessmentboolean();
		obj.setTableid((java.math.BigDecimal) rs.getObject(1));
		obj.setNcAssessmentdataUniqueid((java.math.BigDecimal) rs.getObject(2));
		obj.setScoreorder((java.math.BigDecimal) rs.getObject(3));
		obj.setOwner((java.math.BigDecimal) rs.getObject(4));
		if (rs.getTimestamp(5) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(5).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(6));
		obj.setTextvalue((String) rs.getObject(7));
		obj.setTextnormvalue((String) rs.getObject(8));
		obj
				.setComments(OracleUtils.readCLOB((oracle.sql.CLOB) rs
						.getObject(9)));
		obj.setDatavalue(convert2Boolean(rs.getObject(10)));
		obj.setDatanormvalue(convert2Boolean(rs.getObject(11)));
		obj.setStoredassessmentid((java.math.BigDecimal) rs.getObject(12));
		obj.setAssessmentid((java.math.BigDecimal) rs.getObject(13));
		obj.setScorename((String) rs.getObject(14));
		obj.setScoretype((String) rs.getObject(15));
		obj.setIsvalidated(convert2Boolean(rs.getObject(16)));
		obj.setIsranked(convert2Boolean(rs.getObject(17)));
		obj.setSubjectid((String) rs.getObject(18));
		obj.setEntryid((java.math.BigDecimal) rs.getObject(19));
		obj.setKeyerid((java.math.BigDecimal) rs.getObject(20));
		obj.setRaterid((java.math.BigDecimal) rs.getObject(21));
		obj.setClassification((java.math.BigDecimal) rs.getObject(22));
		obj.setNcDataclassificationUniqueid((java.math.BigDecimal) rs
				.getObject(23));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(24));
		return obj;
	}

	public List<Assessmentboolean> find(Connection con,
			Assessmentboolean criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessmentboolean> results = new LinkedList<Assessmentboolean>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ASSESSMENTBOOLEAN ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessmentboolean item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Assessmentboolean bean,
			Assessmentboolean criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Assessmentboolean criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ASSESSMENTBOOLEAN ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
