package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Humansubject;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class HumansubjectDAO implements clinical.server.dao.HumansubjectDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public HumansubjectDAO() {
	}

	public void insert(Connection con, Humansubject bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_HUMANSUBJECT ");
			buf
					.append(" (SUBJECTID,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,EXTENSIONNAME,NC_ANIMALSPECIES_UNIQUEID,NAME,BIRTHDATE,LOCALID,SITEID,ISREMOTE) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 13; ++i) {
				buf.append('?');
				if (i < 12)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (String) bean.getSubjectid(), Types.VARCHAR);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(5, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(6, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(7, (String) bean.getExtensionname(), Types.VARCHAR);
			ps.setObject(8, (java.math.BigDecimal) bean
					.getNcAnimalspeciesUniqueid(), Types.NUMERIC);
			ps.setObject(9, (String) bean.getName(), Types.VARCHAR);
			ps.setTimestamp(10, bean.getBirthdate() == null ? null
					: new java.sql.Timestamp(bean.getBirthdate().getTime()));
			ps.setObject(11, (String) bean.getLocalid(), Types.VARCHAR);
			ps.setObject(12, (java.math.BigDecimal) bean.getSiteid(),
					Types.NUMERIC);
			ps.setObject(13, boolean2Number((Boolean) bean.getIsremote()),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Humansubject bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("SUBJECTID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("EXTENSIONNAME");
		buf.append(',');
		buf.append("NC_ANIMALSPECIES_UNIQUEID");
		buf.append(',');
		buf.append("NAME");
		buf.append(',');
		buf.append("BIRTHDATE");
		buf.append(',');
		buf.append("LOCALID");
		buf.append(',');
		buf.append("SITEID");
		buf.append(',');
		buf.append("ISREMOTE");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Humansubject bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SUBJECTID=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getExtensionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXTENSIONNAME=?");
			qi.values.add(bean.getExtensionname());
			valueSet = true;
		}
		if (bean.getNcAnimalspeciesUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_ANIMALSPECIES_UNIQUEID=?");
			qi.values.add(bean.getNcAnimalspeciesUniqueid());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NAME=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getBirthdate() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("BIRTHDATE=?");
			qi.values
					.add(new java.sql.Timestamp(bean.getBirthdate().getTime()));
			valueSet = true;
		}
		if (bean.getLocalid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("LOCALID=?");
			qi.values.add(bean.getLocalid());
			valueSet = true;
		}
		if (bean.getSiteid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SITEID=?");
			qi.values.add(bean.getSiteid());
			valueSet = true;
		}
		if (bean.getIsremote() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISREMOTE=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsremote()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Humansubject bean,
			Humansubject criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_HUMANSUBJECT SET ");

		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SUBJECTID=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXTENSIONNAME=? ");
			uqi.setValues.add(bean.getExtensionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("extensionname"), uqi);
			valueSet = true;
		}
		if (bean.getNcAnimalspeciesUniqueid() != null
				|| bean.isNull("ncAnimalspeciesUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_ANIMALSPECIES_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcAnimalspeciesUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncAnimalspeciesUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NAME=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getBirthdate() != null || bean.isNull("birthdate")) {
			if (valueSet)
				buf.append(", ");
			buf.append("BIRTHDATE=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getBirthdate()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("birthdate"), uqi);
			valueSet = true;
		}
		if (bean.getLocalid() != null || bean.isNull("localid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("LOCALID=? ");
			uqi.setValues.add(bean.getLocalid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("localid"), uqi);
			valueSet = true;
		}
		if (bean.getSiteid() != null || bean.isNull("siteid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SITEID=? ");
			uqi.setValues.add(bean.getSiteid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("siteid"), uqi);
			valueSet = true;
		}
		if (bean.getIsremote() != null || bean.isNull("isremote")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISREMOTE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsremote()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isremote"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Humansubject createObject(ResultSet rs) throws SQLException {
		Humansubject obj = new Humansubject();
		obj.setSubjectid((String) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(3));
		obj.setOwner((java.math.BigDecimal) rs.getObject(4));
		if (rs.getTimestamp(5) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(5).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(6));
		obj.setExtensionname((String) rs.getObject(7));
		obj.setNcAnimalspeciesUniqueid((java.math.BigDecimal) rs.getObject(8));
		obj.setName((String) rs.getObject(9));
		if (rs.getTimestamp(10) != null) {
			obj.setBirthdate(new java.util.Date(rs.getTimestamp(10).getTime()));
		}
		obj.setLocalid((String) rs.getObject(11));
		obj.setSiteid((java.math.BigDecimal) rs.getObject(12));
		obj.setIsremote(convert2Boolean(rs.getObject(13)));
		return obj;
	}

	public List<Humansubject> find(Connection con, Humansubject criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Humansubject> results = new LinkedList<Humansubject>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_HUMANSUBJECT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Humansubject item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Humansubject bean, Humansubject criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Humansubject criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_HUMANSUBJECT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */

	/**
	 * 
	 * 
	 * @param con
	 *            a JDBC connection
	 * @param bean
	 *            a <code>Humansubject</code> value object to insert to the
	 *            database
	 * @exception Exception
	 *                if an error occurs
	 */
	public void insert2(Connection con, Humansubject bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_HUMANSUBJECT VALUES ");
			buf.append('(');
			for (int i = 0; i < 11; ++i) {
				buf.append('?');
				if (i < 10)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getSubjectid());
			ps.setObject(2, bean.getTableid());
			ps.setObject(3, bean.getUniqueid());
			ps.setObject(4, bean.getOwner());
			ps.setObject(5, new java.sql.Date(bean.getModtime().getTime()));
			ps.setObject(6, bean.getModuser());
			ps.setObject(7, bean.getExtensionname());
			ps.setObject(8, bean.getNcAnimalspeciesUniqueid());
			if (bean.getLocalid() == null) {
				ps.setNull(9, Types.VARCHAR);
			} else {
				ps.setObject(9, bean.getLocalid());
			}

			if (bean.getName() == null) {
				ps.setNull(10, Types.VARCHAR);
			} else {
				ps.setObject(10, bean.getName());
			}
			if (bean.getBirthdate() == null) {
				ps.setNull(11, Types.DATE);
			} else {
				ps.setObject(11, new java.sql.Date(bean.getBirthdate()
						.getTime()));
			}
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	/* +++ */
}// ;
