package clinical.storage;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.utils.PluginManUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PluginManager.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class PluginManager {
	protected static PluginManager instance;
	protected Map<String, Class<?>> pluginClassMap = new HashMap<String, Class<?>>(
			7);

	protected PluginManager() throws Exception {
		detectAndCachePlugins("clinical.storage.plugins");
	}

	public static synchronized PluginManager getInstance() throws Exception {
		if (instance == null) {
			instance = new PluginManager();
		}
		return instance;
	}

	public IPlugin getPlugin(String storageType, Map<String, Object> paramMap)
			throws Exception {
		if (storageType == null)
			return null;
		Class<?> pc = pluginClassMap.get(storageType.toUpperCase());
		Constructor<?>[] constructors = pc.getDeclaredConstructors();
		for (Constructor<?> cons : constructors) {
			Class<?>[] parameterTypes = cons.getParameterTypes();
			if (paramMap != null && parameterTypes.length == 1
					&& Map.class.isAssignableFrom(parameterTypes[0])) {
				Object plugin = cons.newInstance(new Object[] { paramMap });
				return (IPlugin) plugin;
			}
		}
		return null;
	}

	public List<String> getRegisteredStorageTypes() {
		return new ArrayList<String>(pluginClassMap.keySet());
	}

	protected void detectAndCachePlugins(String pluginsPackageName)
			throws Exception {
		List<Class<?>> pluginClasses = PluginManUtils.detectPluginImplClasses(
				pluginsPackageName, IPlugin.class);
		for (Class<?> pc : pluginClasses) {
			Method m = pc.getMethod("getSupportedType", (Class<?>[]) null);
			if (m != null) {				
				String type = (String) m.invoke(null, (Object[]) null);
				if (type != null)
					pluginClassMap.put(type.toUpperCase(), pc);
			}
		}
	}

}
