package clinical.test;

import java.io.IOException;

import junit.framework.TestSuite;
import clinical.server.vo.Expsegment;
import clinical.web.IRemoteDBServices;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.security.DBConfig;
import clinical.web.services.SecurityService;

public class RemoteDBServicesTest extends MyDBTestCase {

	public RemoteDBServicesTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	public RemoteDBServicesTest(String testName) throws IOException {
		super(testName, "test.properties", true);
	}

	protected void setUp() throws Exception {
		MinimalServiceFactory.setMimimalOpMode(true);
		ServiceFactory.setMimimalOpMode(false);
		mixin.startup();
		SecurityService ss = SecurityService.getInstance(getDbPoolService(), getDbID(), DBConfig.POSTGRES);
		ss.startup();

		con = mixin.getConnection();
		ISequenceHelper seqHelper = ServiceFactory.getSequenceHelper(mixin
				.getDbID());
		seqHelper.addListener(this);
	}

	public void testGetSegmentInfo() throws Exception {
		String subjectID = "000920416589";
		Integer visitID = new Integer(2);
		String segmentName = "t1";
		String expName = "fBIRNPhaseII__0010";
		String siteID = "0009"; // "0008"; UCSD

		
		IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();

		Expsegment s = rds.getSegmentInfo(getUi(), siteID, expName, subjectID,
				visitID, segmentName);
		assertNotNull(s);
		System.out.println(s);
	}

	public static TestSuite suite() throws IOException {
		TestSuite s = new TestSuite();
		s.addTest(new RemoteDBServicesTest("testGetSegmentInfo"));
		return s;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
