package clinical.web.actions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.json.JSONArray;
import org.json.JSONObject;


import clinical.cache.CacheUtils;
import clinical.server.vo.Assessmentscorecode;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Protocol;
import clinical.server.vo.Storedquery;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAnalysisResultService;
import clinical.web.IAssessmentService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.forms.StoredQuerySelector;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.helpers.ProtocolSelector;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.QueryInfo;
import java.util.Collections;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentQueryAction.java 547 2012-02-22 18:19:37Z jinranc $
 */
public class AssessmentQueryAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(AssessmentQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.aq.show", "show");
		map.put("action.aq.load_saved_query", "loadSavedQuery");
		map.put("action.aq.query", "query");
		map.put("action.aq.msquery", "multiSiteQuery");

		map.put("action.aq.save_query", "saveQuery");
		map.put("action.aq.get_scorecodes", "getScorecodes");
		map.put("action.aq.change_exp", "changeExp"); //Jinran added
		map.put("action.aq.delete_query", "deleteQuery"); //Jinran added
		return map;
	}

	@SuppressWarnings("unchecked")
	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("in show");
		IDBCache dbCache = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IAssessmentService asService = ServiceFactory
					.getAssessmentService(dbID);
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

//			List<AssessmentSelectionInfo> asiList = rds
//					.getAllAssessmentsWithScores(primarySiteID); //Jinran commented
			List<AssessmentSelectionInfo> asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); //Jinran added
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			queryForm.clean();

			IAnalysisResultService ars = ServiceFactory.getAnalysisResultService(dbID);

			boolean supportAnalysisQuery = ars.hasAnalysisMetaData();
			queryForm.setSupportAnalysisQuery(supportAnalysisQuery);
			boolean supportAssessmentQuery = !asiList.isEmpty();
			queryForm.setSupportAssessmentQuery(supportAssessmentQuery);

			for (AssessmentSelectionInfo asi : asiList) {
				queryForm.addAssessment(asi);
			}
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(new AssessmentQueryInfo(asiList));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() != null && qi.getAqi().hasQueryParts()) {
					qi.getAqi().resetAllSelected();
				}
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			/********* Jinran added for Imaging Query *****************/
			//QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm);
			QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm, qi);
			/**********************************************************/
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward query(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** query");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);		
			
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

//			qa.handleQuery(queryString, queryForm.getDdQueryString(),
//					primarySiteID); //commented by Jinran
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols");
			log.info("selected protocols: " + selPros);
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions");
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes");
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
						
			qa.handleQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, selVersions);				

			//Add assessment to asilist			
				String expName = new String();
				for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
					if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
						expName = lvb.getLabel();
						break;
					}
				}			
				IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
				List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
				if(expName.equals("All Experiments")){
					asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
				}else if(expName.equals("All Experiments without Regression")){
					asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
				}else{
					asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
				}
				queryForm.deleteAssessment();
				for(AssessmentSelectionInfo asi : asiList){
					queryForm.addAssessment(asi);					
				}	
			//Jinran added ends		
			
			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}
	}

	private String[] getDistinctExpSegs(List<Expsegment> listExpSegments) {		
		List<String> listAllDisExpsegs = new ArrayList<String>();
		
		try{
			for(Expsegment seg : listExpSegments){
				String name = "";
				if(seg.getName()!=null){
					name = seg.getName();
				}
				int index = Collections.binarySearch(listAllDisExpsegs, name);			
				if(index<0){
					listAllDisExpsegs.add(Math.abs(index)-1, name);
				}
			}
			
			int i = 0;
			String[] allExpsegs = new String[listAllDisExpsegs.size()];
			for(String s : listAllDisExpsegs){
				allExpsegs[i++] = s;
			}
			
			return allExpsegs;
			
		}catch(Exception e){
			log.debug(e.getMessage());
			return null;
		}
		
	}

	private String[] getSelectedExpSegs(List<Expsegment> list,
			String[] selectedProtocols, String[] selectedVersions) {
		boolean bAllVers = false;
		for(String sVer : selectedVersions){
			if(sVer.equals(Constants.ALL_VERSIONS)){
				bAllVers = true;
				break;
			}
		}
		
		List<String> listExpSeg = new ArrayList<String>();
		for(String s : selectedProtocols){
			if(s.equals(Constants.ALL_PROTOCOLS)){				
				if(bAllVers==true){
					for(Expsegment expseg : list){
						String name = "";
						if(expseg.getName()!=null){
							name = expseg.getName();
						}
						int idx = Collections.binarySearch(listExpSeg, name);
						if(idx<0){
							listExpSeg.add(Math.abs(idx)-1, name);	
						}																	
					}
				}else{
					for(Expsegment expseg : list){
						for(int i=0; i<selectedVersions.length;i++){
							if(selectedVersions[i].equals(expseg.getProtocolversion().toString())){
								String name = "";
								if(expseg.getName()!=null){
									name = expseg.getName();
								}
								int idx = Collections.binarySearch(listExpSeg, name);
								if(idx<0){
									listExpSeg.add(Math.abs(idx)-1, name);	
								}												
							}	
						}					
					}					
				}
				String[] selectedExpsegs = new String[listExpSeg.size()];
				int i = 0;
				for(String str : listExpSeg){
					selectedExpsegs[i++] = str;
				}
				return selectedExpsegs;
			}			
		}		
		
		listExpSeg = new ArrayList<String>();
		for(Expsegment expseg : list){
			for(String s : selectedProtocols){	
				if(expseg.getProtocolid().toLowerCase().equals(s.toLowerCase())){
					if(bAllVers==true){
						String name = "";
						if(expseg.getName()!=null){
							name = expseg.getName();
						}
						int idx = Collections.binarySearch(listExpSeg, name);
						if(idx<0){
							listExpSeg.add(Math.abs(idx)-1, name);	
						}
						continue;
					}

					for(int i=0; i<selectedVersions.length; i++){
						if(expseg.getProtocolversion().toString().equals(selectedVersions[i])){
							String name = "";
							if(expseg.getName()!=null){
								name = expseg.getName();
							}
							int index = Collections.binarySearch(listExpSeg, name);
							if(index<0){
								listExpSeg.add(Math.abs(index)-1, name);
							}					 							
						}
					}
				}
			}
		}
		int j = 0;
		String[] selectedExpsegs = new String[listExpSeg.size()];
		for(String s : listExpSeg){
			selectedExpsegs[j++] = s;
		}
		
		return selectedExpsegs;
	}

	public ActionForward multiSiteQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** multiSiteQuery");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

			//qa.handleMultisiteQuery(queryString, queryForm.getDdQueryString(),
			//		primarySiteID);
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols");
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions");
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes");
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
						
			qa.handleMultisiteQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, selVersions);				
			//Jinran added ends
			
			//Jinran added. Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}	

			
			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}

	}

	public ActionForward loadSavedQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);

			log.info("selected query ID=" + sqs.getSelectedQueryID());
			JSONObject js = QueryWizardHelper.loadJSONQueryFromDB(ui,
					asService, sqs.getSelectedQueryID(), ui.getPerceivedName());
			
			QueryInfo qi = queryForm.getQueryInfo();

			Assertion.assertNotNull(qi);
			// System.out.println(js.toString(2));
			qi.jsonToQuery(js);

			//Jinran added
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){
				if(lvb.getValue().equals(qi.getExpIDStr())){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}			
			qi.getAqi().setAsiList(asiList); 
		

			// set assessment query
			qi.prepareStoredQuery();

			ExperimentSelector expSelector = queryForm.getExpSelector();
			if (expSelector == null) {
				QueryWizardHelper.prepareExperimentSelector(ui, queryForm,
						dbCache);
				expSelector = queryForm.getExpSelector();
			}
			expSelector.setSelectedExpID(GenUtils.toInt(qi.getExpIDStr(), -1));					
					
			/********* Jinran added for Imaging Query *****************/
			//QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm);
			QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm, qi);
			/**********************************************************/
			
			return mapping.findForward(Constants.SUCCESS);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			JSONObject js = new JSONObject(queryString);
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(AssessmentQueryInfo.initializeFromJSON(js));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() == null) {
					qi.setAqi(AssessmentQueryInfo.initializeFromJSON(js));
				} else {
					qi.getAqi().updateQueryFromJSON(js);
				}
			}
			qi.prepareStoredQuery();

			SaveQueryForm sqForm = (SaveQueryForm) session
					.getAttribute(Constants.STORED_QUERY_FORM_KEY);
			if (sqForm != null) {
				sqForm.setDescription("");
				sqForm.getStoredQueryDescriptions().clear();
				sqForm.getStoredQueryIdDesc().clear(); //Jinran added
			} else {
				sqForm = new SaveQueryForm();
				session.setAttribute(Constants.STORED_QUERY_FORM_KEY, sqForm);
			}
			List<Storedquery> storedQueries = asService
					.getAvailableStoredQueries(ui, ui.getPerceivedName());
			for (Storedquery sq : storedQueries) {
				sqForm.addStoredQueryDescription(sq.getDescription());
				sqForm.addStoredQueryIdDesc(sq.getDescription(), sq.getUniqueid()); //Jinran added
			}
			
			sqForm.getSavedQuerySelector().setSelectedQueryID(queryForm.getSavedQuerySelector().getSelectedQueryID()); //pass selected queryId

			//Jinran added
			String selPros = request.getParameter("selProtocols");
			String selVers = request.getParameter("selVersions");
			String seltypes = request.getParameter("selDTypes");
			sqForm.setSaveProtocols(selPros);
			sqForm.setSaveVersions(selVers);
			sqForm.setSaveTypes(seltypes);

			return mapping.findForward(Constants.SAVE_QUERY);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getScorecodes(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			System.out.println(":::: getScorecodes");
			HttpSession session = request.getSession(false);

			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			String scoreName = request.getParameter("scoreName");
			Assertion.assertNotNull(scoreName);
			String key = asID + "_" + scoreName;
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
					.getScoreCodeMap(ui, false);
			JSONObject js = new JSONObject();
			js.put("asID", asID);
			js.put("scoreName", scoreName);
			List<Assessmentscorecode> scList = scoreCodeMap.get(key);
			if (scList != null) {
				js.put("hasEnums", true);
				JSONArray jsArr = new JSONArray();
				js.put("sci", jsArr);
				for (Assessmentscorecode asc : scList) {
					JSONObject scJs = new JSONObject();
					scJs.put("l", asc.getScorecodevalue());
					scJs.put("c", asc.getScorecode());
					jsArr.put(scJs);
				}
			} else {
				js.put("hasEnums", false);
			}
			response.setContentType("application/json");
			String jsonStr = js.toString();
			log.info("jsonStr:" + jsonStr);
			response.getOutputStream().println(jsonStr);
			return null;
		} catch (Exception x) {
			x.printStackTrace();
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static Map<String, Experiment> toMap(List<Experiment> experiments) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = experiments.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(exp.getUniqueid().toString(), exp);
		}
		return map;
	}
	
	/**
	 * Jinran added. Action when Experiments dropdown changes.
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	public ActionForward changeExp(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		String expName = new String();
		expName = request.getParameter("curExp");
		
		log.info("in changeExp, curExp: " + expName);
		
		//UserInfo ui = getUserInfo(request);
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(dbID);
		
		List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
		if(expName.equals("All Experiments")){
			asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
		}else if(expName.equals("All Experiments without Regression")){
			asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
		}else{
			asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
		}		

		AsQueryBuilderForm asform = (AsQueryBuilderForm) form;
		asform.deleteAssessment();	
		
		QueryInfo qi = new QueryInfo(new AssessmentQueryInfo(asiList));
		asform.setQueryInfo(qi);
		
		//populate protocol selector
		List<Protocol> proList = new ArrayList<Protocol>();
		if(expName.equals("All Experiments")){
			proList = rds.getAllValidProtocols(primarySiteID); 	
		}else if(expName.equals("All Experiments without Regression")){
			proList = rds.getAllValidProtocols(primarySiteID); 
		}else{
			proList = rds.getProtocols(primarySiteID, expName); 	
		}				
		ProtocolSelector proSelector = new ProtocolSelector(proList);
		BigDecimal[] ids = new BigDecimal[1];
		ids[0] = BigDecimal.valueOf(-1);
		if(proSelector.getProtocolCols().size()>0){
			proSelector.setSelProtocolIds(ids);
		}
		if(proSelector.getProtocolVers().size()>0){
			proSelector.setSelProtocolVers(ids);
		}
		if(proSelector.getDataTypes().size()>0){
			proSelector.setSelDataTypes(ids);
		}
		asform.setProSelector(proSelector);
		
		return mapping.findForward(Constants.SUCCESS);		
	}

	/**
	 * Jinran added
	 * 
	 * Delete stored query from db 
	 * 
	 */
	public ActionForward deleteQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IDBCache dbCache = null;
		try{
			// cancel delete action
			String cancel = request.getParameter("cancelDelete");
			log.info("cancelDelete: " + cancel);
			if(!cancel.equals("no")){
				return mapping.findForward(Constants.DELETE);
			}
			
			//use assessmentservice as interface to interact with db
			IAssessmentService asService = null;
			UserInfo ui = getUserInfo(request);
			
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			
			String queryName = request.getParameter("queryName");
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();			
			BigDecimal queryId = new BigDecimal(sqs.getSelectedQueryID());
			log.info("queryName: " + queryName + ". queryId: " + queryId);

			//delete stored query from db
			asService.deleteStoredAssessmentQuery(ui, queryId);

			//reload AssessmentQueryForm
			queryForm.clean();

			IAnalysisResultService ars = ServiceFactory.getAnalysisResultService(dbID);
			boolean supportAnalysisQuery = ars.hasAnalysisMetaData();
			queryForm.setSupportAnalysisQuery(supportAnalysisQuery);
			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			List<AssessmentSelectionInfo> asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); //Jinran added
			boolean supportAssessmentQuery = !asiList.isEmpty();
			queryForm.setSupportAssessmentQuery(supportAssessmentQuery);

			for (AssessmentSelectionInfo asi : asiList) {
				queryForm.addAssessment(asi);
			}
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(new AssessmentQueryInfo(asiList));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() != null && qi.getAqi().hasQueryParts()) {
					qi.getAqi().resetAllSelected();
				}
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			return mapping.findForward(Constants.SUCCESS);		}
		catch(Exception x){
			return processExceptions(request, response, mapping, form, x);
		}
	}

}
