package clinical.web.actions;

import javax.servlet.http.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import clinical.web.*;
import clinical.web.common.UserInfo;
import clinical.web.forms.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: EnrollSubjectAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class EnrollSubjectAction extends BaseAction {
  private Log log = LogFactory.getLog(EnrollSubjectAction.class);

  public EnrollSubjectAction() {}

  public ActionForward execute(ActionMapping mapping,
                              ActionForm form,
                              HttpServletRequest request,
                              HttpServletResponse response) throws Exception
 {


   IExperimentManagement iem = null;
   ExperimentManagementForm emForm = (ExperimentManagementForm) form;
   try {
     UserInfo ui = getUserInfo(request);

     HttpSession session = request.getSession(false);
     String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);

     int studyGroupID = Integer.parseInt( emForm.getAvailableStudyGroupValue() );
     String subjectID = emForm.getAvailableSubjectValue();
     int experimentID = emForm.getExperimentInfo().getId();

     iem = ServiceFactory.getExperimentManagement(dbID);
     iem.enrollSubject(ui, experimentID, subjectID, studyGroupID);
     ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID, ui, experimentID, emForm);
     return mapping.findForward(Constants.SUCCESS);
   }  catch (Exception x) {
     log.error("EnrollSubjectAction",x);
     return processExceptions(request, response, mapping, form, x);
   }
 }

}
