package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import clinical.server.vo.Researchgroup;
import clinical.server.vo.Subjexperiment;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.ExperimentManagementForm;

/**
 *
 *  @author I. Burak Ozyurt
 *  @version $Id: ExperimentManagementHelper.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ExperimentManagementHelper {
  protected ExperimentManagementHelper() {}

  /**
   *
   * @param ui
   * @param experimentID
   * @param emForm
   * @throws BaseException
   */
  public static void prepareEnrolledSubjectStudyGroups(String dbID, UserInfo ui,
       int experimentID, ExperimentManagementForm emForm) throws BaseException
   {

     IExperimentManagement iem = ServiceFactory.getExperimentManagement(dbID);

     List<Subjexperiment> enrolledSubjects = iem.getEnrolledSubjects(ui, experimentID);
     Collections.sort(enrolledSubjects, new Comparator<Subjexperiment>() {
          public int compare(Subjexperiment se1, Subjexperiment se2) {
            int rc = se1.getNcResearchgroupUniqueid().compareTo( se2.getNcResearchgroupUniqueid());
            if ( rc == 0)
              return se1.getSubjectid().compareTo(se2.getSubjectid());
            else
              return rc;
          }
       });


     Map<Researchgroup, Integer> studyGroupMap = iem.getResearchGroupSubjectCount(ui, experimentID);
     List<String> studyGroups = new ArrayList<String>( studyGroupMap.size());
     for (Map.Entry<Researchgroup, Integer> entry : studyGroupMap.entrySet()) {     
       Researchgroup rg = entry.getKey();
       StringBuffer buf = new StringBuffer();
       buf.append(rg.getUniqueid()).append(' ');
       buf.append( rg.getName()).append(" (");
       buf.append( (Integer) entry.getValue() );
       buf.append(")");
       studyGroups.add(buf.toString());
     }

     List<String> remainingStudyGroups =
         ExperimentManagementHelper.getRemainingResearchGroups(dbID, ui,
                                       studyGroups, experimentID);

     if ( !remainingStudyGroups.isEmpty() ) {
       studyGroups.addAll(remainingStudyGroups);
     }

     emForm.setStudyGroups( studyGroups);

     emForm.setEnrolledSubjects(enrolledSubjects, studyGroupMap);
   }

   /**
    * returns the study groups which do not have any enrolled subjects.
    * @param ui User Information used to use the correct named database user connection from the connection pool
    * @param studyGroups a list of strings containing study group name and enrolled subject counts
    *  in <code>&lt;study group id&gt; &lt;study group name&gt; (&lt;enrolled subject count&gt;)</code> format.
    * @param experimentID
    * @return a list of Strings containing the remaining study (research) group names
    */
   public static List<String> getRemainingResearchGroups(String dbID, UserInfo ui,
       List<String> studyGroups, int experimentID) throws BaseException {
     List<Researchgroup> rgList = ServiceFactory.getDBCache(dbID).getResearchGroups(ui, true);

     Map<String, String> rgIDMap = new HashMap<String, String>(11);
     for (Iterator<String> iter = studyGroups.iterator(); iter.hasNext(); ) {
       String str = iter.next();
       StringTokenizer stok = new StringTokenizer(str);
       String uidStr = stok.nextToken();
       String name = stok.nextToken();
       rgIDMap.put(uidStr, name);
     }
     List<String> remainList = new LinkedList<String>();
     for (Researchgroup rg : rgList) {
       if ( rg.getNcExperimentUniqueid().intValue() != experimentID )
         continue;
       if ( rgIDMap.get( rg.getUniqueid().toString()) == null) {
         remainList.add( rg.getUniqueid().toString() + " " + rg.getName() );
       }
     }
     return remainList;
   }

   public static Subjexperiment findSubjectExperimentInfo(String subjectID, ExperimentManagementForm emForm)
   {
      List<Subjexperiment> seList = emForm.getEnrolledSubjects();
      for (Subjexperiment se : seList) {
        if ( se.getSubjectid().equals(subjectID))
           return se;
      }
      return null;
   }
}
