package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.FileUtils;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;

/**
 * @author I. Burak Ozyurt
 * @version $Id: FileServerAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class FileServerAction extends BaseAction {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {

			String path = request.getParameter("path");
			IAppConfigService configService = ServiceFactory.getAppConfigService();
			String cacheRoot = configService.getParamValue("download.cacheroot");
			if (path == null) {
				return null;
			}
			
			File filePath = new File(cacheRoot, path);
			
			if (filePath.isFile()) {

				response.setContentType("application/octet-stream");
				// as of RFC 2183
				response.setHeader("Content-Disposition",
						"attachment; filename=" + filePath.getName() + ";");
				BufferedInputStream bin = null;
				BufferedOutputStream bout = null;

				try {
					bin = new BufferedInputStream(new FileInputStream(filePath));
					bout = new BufferedOutputStream( response.getOutputStream() );
					byte[] buffer = new byte[4096];
					int readBytes = 0;
					while ((readBytes = bin.read(buffer)) != -1) {
						bout.write(buffer, 0, readBytes);
					}
					bout.flush();
				} finally {
					FileUtils.close(response.getOutputStream());
				}
			}
			return null;
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}
}
