package clinical.web.actions;

import java.io.File;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.UserInfo;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.services.IDownloadJobService;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ImageSeriesViewerDataAction.java 62 2009-05-29 23:54:50Z
 *          bozyurt $
 */
public class ImageSeriesViewerDataAction extends BaseAction {
	private Log log = LogFactory.getLog(ImageSeriesViewerDataAction.class);

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("execute");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			SubjectVisitForm svForm = (SubjectVisitForm) session
					.getAttribute(Constants.SUBVISIT_FORM_KEY);
			String siteID = svForm.getSiteID();
			int visitID = GenUtils.toInt(request.getParameter("visitID"), -1);
			int segID = GenUtils.toInt(request.getParameter("segID"), -1);

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IAuthenticationService authService = ServiceFactory
					.getAuthenticationService();
			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			String theDBID = ss.findDBForSiteID(siteID);
			if (theDBID != dbID) {
				log.info("theDBID=" + theDBID);
				ui = authService.getDefaultUser(theDBID, ui);
			}
			VisitSegment vs = null;
			for (Visit v : svForm.getClinicalVisits()) {
				if (v.getComponentID() == visitID) {
					vs = v.getVisitSegment(segID);
				}
			}
			if (vs == null) {
				for (Visit v : svForm.getScanVisits()) {
					if (v.getComponentID() == visitID) {
						vs = v.getVisitSegment(segID);
					}
				}
			}
			ImageSeriesDataInfo isdi = null;
			File[] jpegFiles = null;

			String cacheRoot = ImageSeriesViewHelper.REL_VIEWER_IMAGES_PATH;
			cacheRoot = session.getServletContext().getRealPath(cacheRoot);
			new File(cacheRoot).mkdirs();
			if (vs != null) {
				IDownloadJobService djs = ServiceFactory.getDownloadJobService();
				isdi = vs.getIsdi();

				jpegFiles = djs.downloadAndPrepareImageSeries(isdi, cacheRoot, ui);
			}

			JSONObject js = ImageSeriesViewHelper.prepImagePreviewComObject(
					siteID, isdi, jpegFiles);
			response.setContentType("application/json");
			String jsonStr = js.toString();
			log.info("jsonStr:" + jsonStr);
			response.getOutputStream().println(jsonStr);
			return null;

		} catch (Exception x) {
			log.error("execute", x);
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("jpegs", jsArr);
			response.setContentType("application/json");
			String jsonStr = js.toString();
			response.getOutputStream().println(jsonStr);
		}

		return null;
	}

}
