package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Rawdata;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.image.ConversionWorker;
import clinical.web.vo.Visit;

/**
 * @author I. Burak Ozyurt
 * @version $Id: MRIDownloadAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MRIDownloadAction extends BaseAction {
	private Log log = LogFactory.getLog("clinical");

	public MRIDownloadAction() {
	}

	public static String getFilenamePart(String path) {
		File f = new File(path);
		return f.getName();
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			HttpSession session = request.getSession(false);
			if (session == null) {
				return null;
			}

			ConversionWorker worker = (ConversionWorker) session
					.getAttribute(Constants.MRICONVERT_PROGRESS_TASK_KEY);

			String tarFile = worker.getTarFileName();
			if (tarFile == null) {
				return null;
			}

			String cacheRoot = worker.getCacheRoot();
			String dataURI = worker.getDataURI();
			
			response.setContentType("application/octet-stream"); // name=x.tgz;");
			// as of RFC 2183
			response.setHeader("Content-Disposition", "attachment; filename="
					+ getFilenamePart(tarFile) + ";");

			response.setHeader("CACHE-CONTROL", "no-cache");

			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);
			// pool = ServiceFactory.getPoolService( dbID );
			uc.getUserInfo();

			ImageHandler imgHandler = ServiceFactory.getImageHandlerService();
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			if (tarFile != null) {

				BufferedOutputStream out = null;
				BufferedInputStream in = null;
				byte[] buffer = new byte[4096];
				try {
					// lock the image cache dir with read lock so that the cache
					// sweeper does not
					// try to delete it while read

					imgHandler.lockImageSeries(cacheRoot, dataURI,
							configService);

					out = new BufferedOutputStream(response.getOutputStream(),
							4096);
					in = new BufferedInputStream(new FileInputStream(tarFile),
							4096);
					int bytesRead;
					while ((bytesRead = in.read(buffer)) != -1) {
						out.write(buffer, 0, bytesRead);
					}

				} catch (IOException iox) {
					iox.printStackTrace();
				} finally {
					if (out != null) {
						out.flush();
					}
					FileUtils.close(in);
					imgHandler.unlockImageSeries(cacheRoot, dataURI,
							configService);
				}
			}
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
		}
		return null;
	}

	public ActionForward executeOld(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		UserInfo ui = null;
		IDBPoolService pool = null;
		Connection con = null;
		try {
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			response.setContentType("application/octet-stream");
			if (session == null) {
				return null;
			}
			UserContainer uc = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);
			pool = ServiceFactory.getPoolService(dbID);
			ui = uc.getUserInfo();
			con = pool.getConnection(ui.getName());

			SubjectVisitForm svForm = (SubjectVisitForm) form;
			ImageHandler imgHandler = ServiceFactory.getImageHandlerService();

			Visit vi = (Visit) svForm.getScanVisits().get(0);
			log.debug("got visit :" + vi);

			BigDecimal scanVisitID = new BigDecimal(String.valueOf(vi
					.getComponentID()));
			BigDecimal scanExpID = new BigDecimal(String.valueOf(vi
					.getExperimentID()));

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			boolean allowMriDownload = GenUtils.toBoolean(configService
					.getParamValue(Constants.ALLOW_MRI_DOWNLOAD_PROPERTY),
					false);
			if (allowMriDownload) {
				loadMRISeries(response, con, session, svForm, imgHandler,
						scanVisitID, scanExpID, configService);
			}

		} catch (BaseException be) {
			return processExceptions(request, response, mapping, form, be);
		} finally {
			if (pool != null) {
				pool.releaseConnection(ui.getName(), con);
			}
		}

		return null;
	}

	private void loadMRISeries(HttpServletResponse response, Connection con,
			HttpSession session, SubjectVisitForm svForm,
			ImageHandler imgHandler, BigDecimal scanVisitID,
			BigDecimal scanExpID, IAppConfigService configService)
			throws Exception {
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);

		List<Rawdata> rawDatas = imgHandler.getRawDataForSubject(dbID, con,
				svForm.getSubjectID(), scanVisitID, scanExpID, null);
		if (rawDatas.size() == 1) {
			Rawdata rd = (Rawdata) rawDatas.get(0);

			String cacheRoot = (String) session.getServletContext()
					.getAttribute(Constants.CACHE_ROOT_KEY);
			cacheRoot = session.getServletContext().getRealPath(cacheRoot);
			if (log.isDebugEnabled()) {
				log.debug("got cacheRoot:" + cacheRoot);
			}
			String tarFile = imgHandler.retrieveMRISeriesForSubject(cacheRoot,
					rd.getDatauri(), configService);
			if (log.isDebugEnabled()) {
				log.debug("got tarFile:" + tarFile);
			}
			if (tarFile != null) {

				BufferedOutputStream out = null;
				BufferedInputStream in = null;
				byte[] buffer = new byte[4096];
				try {
					// lock the image cache dir with read lock so that the cache
					// sweeper does not try to delete it while read

					imgHandler.lockImageSeries(cacheRoot, rd.getDatauri(),
							configService);

					out = new BufferedOutputStream(response.getOutputStream(),
							4096);
					in = new BufferedInputStream(new FileInputStream(tarFile),
							4096);
					int bytesRead;
					while ((bytesRead = in.read(buffer)) != -1) {
						out.write(buffer, 0, bytesRead);
					}

				} catch (IOException iox) {
					iox.printStackTrace();
				} finally {
					if (out != null) {
						out.flush();
					}
					FileUtils.close(in);
					imgHandler.unlockImageSeries(cacheRoot, rd.getDatauri(),
							configService);
				}
			}
		}
	}

}
