package clinical.web.actions;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Element;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.vo.Storedquery;
import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.forms.StoredQuerySelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.QueryInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SaveQueryAction.java 547 2012-02-22 18:19:37Z jinranc $
 */
public class SaveQueryAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(3);
	private Log log = LogFactory.getLog(SaveQueryAction.class);
	
	protected Map<String, String> getKeyMethodMap() {

		map.put("button.save_query", "saveQuery");
		map.put("button.cancel", "cancel");
		map.put("button.delete", "deleteQuery"); //Jinran added
		return map;
	}

	public SaveQueryAction() {
	}

	
	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		log.debug("*** SaveQueryAction");
		try {		
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SaveQueryForm sqForm = (SaveQueryForm) form;

			if (sqForm.getDescription().trim().length() == 0) {
				throw new Exception(
						"A description is required to save a user query!");
			}

			//Jinran added. Cancel overwrite action
			String cancel = request.getParameter("cancelOverwrite");
			if(cancel.equals("yes")){
				return mapping.findForward(Constants.DELETE);
			}
			
			String queryName = request.getParameter("queryName");
			log.info("queryName: " + queryName);			
			
			//Jinran added. Overwrite existing query
			BigDecimal queryId = null;
			if(cancel.equals("no")){
				queryId = new BigDecimal(request.getParameter("queryId"));
				log.info("queryId: " + queryId);
				
				asService = ServiceFactory.getAssessmentService(dbID);

				AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
						.getAttribute(Constants.ASQUERYFORM_KEY);

				if (queryForm.getQueryInfo() != null) {
					// JSON
					QueryInfo qi = queryForm.getQueryInfo();
					String expID = null;
					if (queryForm.getExpSelector() != null) {
						expID = String.valueOf(queryForm.getExpSelector()
								.getSelectedExpID());
					}
					// FIXME what about SCOPE?????
					JSONObject js = qi.queryToJSON(expID);

					//Jinran added.  Save "Protocol Type","Version", and "Data Type" to json
					String selPros = sqForm.getSaveProtocols();
					String selVers = sqForm.getSaveVersions();
					String seltypes = sqForm.getSaveTypes();					
					js = qi.imagingqueryToJSON(js, selPros, selVers, seltypes);

					QueryWizardHelper.updateStoredAssessmentQuery(ui, js, queryName, queryId, asService);

				} else {
					Element queryElem = QueryWizardHelper
							.prepareQueryForPersistence(queryForm);

					QueryWizardHelper.persistQueryToDB(queryElem, sqForm
							.getDescription(), ui, asService);
				}
				// make the saved query available to use for this session
				QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
						.getName(), queryForm);
				
				//display selected query in dropdown
				if(queryId!=null){
					queryForm.getSavedQuerySelector().setSelectedQueryID(queryId.intValue());
				}
				
				if (queryForm.getQueryInfo() != null)
					return mapping.findForward("query");
				return mapping.findForward(Constants.SUCCESS);
			}			
			
			
			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);		
			
			if (queryForm.getQueryInfo() != null) {
				// JSON
				QueryInfo qi = queryForm.getQueryInfo();
				String expID = null;
				if (queryForm.getExpSelector() != null) {
					expID = String.valueOf(queryForm.getExpSelector()
							.getSelectedExpID());
				}
				// FIXME what about SCOPE?????
				JSONObject js = qi.queryToJSON(expID);
				
				//Jinran added.  Save "Protocol Type","Version", and "Data Type" to json
				String selPros = sqForm.getSaveProtocols();
				String selVers = sqForm.getSaveVersions();
				String seltypes = sqForm.getSaveTypes();					
				js = qi.imagingqueryToJSON(js, selPros, selVers, seltypes);

				QueryWizardHelper.saveJSONQueryToDB(js,
						sqForm.getDescription(), ui, asService);

			} else {
				Element queryElem = QueryWizardHelper
						.prepareQueryForPersistence(queryForm);

				QueryWizardHelper.persistQueryToDB(queryElem, sqForm
						.getDescription(), ui, asService);
			}
			// make the saved query available to use for this session
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getName(), queryForm);
			
			//Jinran added. Show the selected query in dropdown
			if(queryName.length()>0){
				queryForm.getSavedQuerySelector().setSelectedQueryID(queryName);
			}
			
			if (queryForm.getQueryInfo() != null)
				return mapping.findForward("query");
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward cancel(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			
			SaveQueryForm sForm = (SaveQueryForm)form;
			
			//Jinran added. When "cancel" is hit after delete a query, the saved queries dropdown needs to be updated. 
			IAssessmentService asService = null;
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session.getAttribute(Constants.ASQUERYFORM_KEY);			
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui.getName(), queryForm);
			
			queryForm.getSavedQuerySelector().setSelectedQueryID(sForm.getSavedQuerySelector().getSelectedQueryID()); //show selected query in dropdown
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}
	
	/**
	 * Jinran added
	 * 
	 * Delete stored query from db 
	 * 
	 */
	public ActionForward deleteQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try{
			// cancel delete action
			String cancel = request.getParameter("cancel");
			log.info("cancel: " + cancel);
			if(!cancel.equals("no")){
				return mapping.findForward(Constants.DELETE);
			}
			
			//use assessmentservice as interface to interact with db
			IAssessmentService asService = null;
			UserInfo ui = getUserInfo(request);
			
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			
			String queryName = request.getParameter("queryName");
			BigDecimal queryId = new BigDecimal(request.getParameter("queryId"));
			log.info("queryName: " + queryName + ". queryId: " + queryId);

			//delete stored query from db
			asService.deleteStoredAssessmentQuery(ui, queryId);

			//reload SaveQueryForm
			SaveQueryForm sqForm = (SaveQueryForm) session.getAttribute(Constants.STORED_QUERY_FORM_KEY);
			
			if (sqForm != null) {
				sqForm.setDescription("");
				sqForm.getStoredQueryDescriptions().clear();
				sqForm.getStoredQueryIdDesc().clear(); 
			} else {
				sqForm = new SaveQueryForm();
				session.setAttribute(Constants.STORED_QUERY_FORM_KEY, sqForm);
			}

			List<Storedquery> storedQueries = asService.getAvailableStoredQueries(ui, ui.getPerceivedName());
			for (Storedquery sq : storedQueries) {
				sqForm.addStoredQueryDescription(sq.getDescription());
				sqForm.addStoredQueryIdDesc(sq.getDescription(), sq.getUniqueid()); 
			}

			return mapping.findForward(Constants.DELETE);
		}
		catch(Exception x){
			return processExceptions(request, response, mapping, form, x);
		}	
		
	}

}