package clinical.web.actions;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Assessment;
import clinical.server.vo.Dataclassification;
import clinical.server.vo.Protocol;
import clinical.utils.DateTimeUtils;
import clinical.web.Constants;
import clinical.web.IRemoteDBServices;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AssessmentEntriesForm;
import clinical.web.forms.AssessmentSelector;
import clinical.web.forms.ReconciliationForm;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.game.AssessmentManagementHelper;
import clinical.web.game.forms.DynamicDropDownSelector;
import clinical.web.helpers.MissingEntry;
import clinical.web.helpers.ScoreValuesDisplayLayout;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.helpers.StudyFormInfo;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.helpers.VisitFormInfo;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ReconScoreValueInfo;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.StudySegment;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SegmentManagementAction.java,v 1.29 2007/10/10 01:11:40 bozyurt
 *          Exp $
 */
public class SegmentManagementAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(11);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.segment_edit", "editSegment");
		map.put("button.segment_add", "addSegment");
		map.put("action.changeVisit", "changeVisit");
		map.put("action.changeSegment", "changeSegment");
		map.put("button.show_edit_segment", "showEditSegment");
		map.put("button.show_add_segment", "showAddSegment");
		map.put("button.add_assessment", "addAssessment");
		map.put("button.edit_assessment", "editAssessment");
		map.put("button.delete_assessment", "deleteAssessment");
		map.put("button.show_reconcile", "showReconcileAssessment");
		map.put("button.show_as_entries", "showAssessmentEntries");

		return map;
	}

	public SegmentManagementAction() {
	}

	public ActionForward showReconcileAssessment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info("showReconcileAssessment");
		ISubjectAssessmentManagement isam = null;
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String selectedAsName = svmForm.getSelectedAsNameForEdit();
			AssessmentInfo theAsi = findAssessmentInfo(svmForm, selectedAsName);
			log.info("selectedAsName=" + selectedAsName);
			ReconciliationForm recForm = new ReconciliationForm();
			recForm.setTheAsi(theAsi);

			if (!ReconScoreValueInfo.isDataClassificationMapPopulated()) {
				IDBCache dbCache = ServiceFactory.getDBCache(dbID);
				List<Dataclassification> classificationList = dbCache
						.getDataClassications(ui, true);
				Map<String, Integer> classificationMap = new HashMap<String, Integer>(
						11);
				for (Dataclassification dc : classificationList) {
					classificationMap.put(dc.getName(), new Integer(dc
							.getUniqueid().intValue()));
				}
				ReconScoreValueInfo.setDataClassificationMap(classificationMap);
			}

			isam = ServiceFactory.getSubjectAssessmentManagement(dbID);

			int expID = svmForm.getCurrentVisit().getVisit().getExperimentID();

			Map<String, ReconScoreValueInfo> reconMap = isam
					.getReconciliationDataForAssessment(ui, svmForm
							.getSelectedSubjectID(), expID,
							theAsi.getVisitID(), theAsi.getSegmentID(), theAsi
									.getAssessmentID());

			recForm.setReconMap(reconMap);
			recForm.setSelectedSubjectID(svmForm.getSelectedSubjectID());
			recForm.setExperimentID(String.valueOf(expID));
			List<ReconScoreValueInfo> mismatchedOnes = new ArrayList<ReconScoreValueInfo>();
			List<ReconScoreValueInfo> rsviList = new ArrayList<ReconScoreValueInfo>(
					reconMap.values());
			// order by score sequence
			orderReconList(rsviList, theAsi);

			Set<String> scoreNameSet = new HashSet<String>();
			Map<String, String> multiValuedScoreMap = new HashMap<String, String>();
			for (Iterator<ReconScoreValueInfo> iter = rsviList.iterator(); iter
					.hasNext();) {
				ReconScoreValueInfo rsvi = iter.next();
				if (scoreNameSet.contains(rsvi.getScoreName())) {
					multiValuedScoreMap.put(rsvi.getScoreName(), rsvi
							.getScoreName());
				} else {
					scoreNameSet.add(rsvi.getScoreName());
				}
			}
			scoreNameSet = null;

			for (Iterator<ReconScoreValueInfo> iter = rsviList.iterator(); iter
					.hasNext();) {
				ReconScoreValueInfo rsvi = iter.next();
				if (multiValuedScoreMap.get(rsvi.getScoreName()) != null) {
					rsvi.setMultiValued(true);
				}
				recForm.addRsvi(rsvi);
				// determine the mismatching ones also
				boolean ok = true;
				String value = null;
				int idx = 0;
				for (ScoreValue sv : rsvi.getScoreValues()) {
					// TODO handle the case where both entries differ only in
					// the reason of missing answer
					if (value == null) {
						if (idx > 0) {
							// the first entry value was null (missing answer),
							// but the second entry is different
							// means reconciliation
							ok = sv.getUncorrectedValue() == null;
						}
						value = sv.getUncorrectedValue();

					} else {
						if (!value.equals(sv.getUncorrectedValue())) {
							ok = false;
							break;
						}
					}
					++idx;
				}// for it
				if (!ok) {
					mismatchedOnes.add(rsvi);
					ScoreValue sv = (ScoreValue) rsvi.getScoreValues().get(0);
					ScoreValue reconValue = new ScoreValue(sv);
					reconValue.setValue("");
					rsvi.setReconciledValue(reconValue);
				}
			}
			recForm.setMismatchedList(mismatchedOnes);

			session.setAttribute(Constants.RECFORM_KEY, recForm);

			// reset the assessment counter
			svmForm.resetAssessments();

		} catch (Exception x) {
			// reset the assessment counter
			svmForm.resetAssessments();
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward("reconcile_assessment");
	}

	private void orderReconList(List<ReconScoreValueInfo> rsviList,
			final AssessmentInfo asi) {
		Collections.sort(rsviList, new Comparator<ReconScoreValueInfo>() {
			public int compare(ReconScoreValueInfo rsv1,
					ReconScoreValueInfo rsv2) {
				int diff = asi.findScore(rsv1.getScoreName())
						.getScoreSequence()
						- asi.findScore(rsv2.getScoreName()).getScoreSequence();
				if (diff == 0) {
					diff = rsv1.getScoreOrder() - rsv2.getScoreOrder();
				}
				return diff;
			}
		});
	}

	public ActionForward showAssessmentEntries(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info("showAssessmentEntries");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			AssessmentEntriesForm aeForm = new AssessmentEntriesForm();

			String selectedAsName = svmForm.getSelectedAsNameForEdit();
			AssessmentInfo theAsi = findAssessmentInfo(svmForm, selectedAsName);
			log.info("selectedAsName=" + selectedAsName);

			int expID = svmForm.getCurrentVisit().getVisit().getExperimentID();
			int visitID = svmForm.getCurrentVisit().getVisit().getComponentID();
			int segmentID = theAsi.getSegmentID();

			aeForm.setAssessmentName(theAsi.getName());

			Map<Integer, AssessmentScoreValues> entryMap = SubjectManagementHelper
					.getAssessmentEntryData(ui, dbID, svmForm
							.getSelectedSubjectID(), expID, visitID, segmentID,
							theAsi);

			AssessmentScoreValues asv = entryMap.get(new Integer(1));
			ScoreValuesDisplayLayout svdl = SubjectManagementHelper
					.prepareScoreValuesDisplayLayout(asv, theAsi);
			aeForm.addScoreValuesDisplayLayout(svdl);

			asv = entryMap.get(new Integer(2));
			svdl = SubjectManagementHelper.prepareScoreValuesDisplayLayout(asv,
					theAsi);
			aeForm.addScoreValuesDisplayLayout(svdl);

			List<MissingEntry> missingEntries = SubjectManagementHelper
					.getMissingEntryItems(ui, dbID, svmForm
							.getSelectedSubjectID(), expID, visitID, segmentID,
							theAsi.getAssessmentID());

			aeForm.setMissingEntries(missingEntries);

			session.setAttribute(Constants.ASENTRY_FORM_KEY, aeForm);

			// reset the assessment counter
			svmForm.resetAssessments();

		} catch (Throwable t) {
			// reset the assessment counter
			svmForm.resetAssessments();
			Exception x = null;
			if (t instanceof Exception) {
				x = (Exception) t;
			} else {
				x = new Exception(t);
			}
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward("show_entries");
	}

	public ActionForward editAssessment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("editAssessment");
		try {
			UserInfo ui = getUserInfo(request);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			HttpSession session = request.getSession(false);

			String selectedAsName = svmForm.getSelectedAsNameForEdit();

			AssessmentInfo theAsi = findAssessmentInfo(svmForm, selectedAsName);
			log.info("selectedAsName=" + selectedAsName);

			SegmentManagementHelper smHelper = new SegmentManagementHelper();
			String formBeanClassName = smHelper
					.findFormBeanClassName(selectedAsName);

			ActionForm asForm = smHelper.createFormBean(formBeanClassName);

			log.info("formBeanClassName=" + formBeanClassName);

			smHelper.setProperty("setAssessmentID", String.valueOf(theAsi
					.getAssessmentID()), asForm);
			smHelper.setProperty("setSubjectID",
					svmForm.getSelectedSubjectID(), asForm);
			smHelper.setProperty("setSegmentID",
					svmForm.getSelectedSegmentID(), asForm);
			smHelper.setProperty("setVisitID", svmForm.getSelectedVisitID(),
					asForm);
			smHelper.setProperty("setExperimentID", String.valueOf(svmForm
					.getCurrentVisit().getVisit().getExperimentID()), asForm);

			String formBeanName = smHelper.findFormBeanName(mapping,
					formBeanClassName);

			log.info("*** populating dynamic dropdowns");
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			// populate the dynamic dropdown(s)
			populateDynamicDropdowns(ui, dbID, asForm);

			log.info("formBeanName=" + formBeanName);

			// cleanup old GAME form beans in session (if any)
			cleanupOldGAMEFormBeans(mapping, session, smHelper);

			session.setAttribute(formBeanName, asForm);
			session.setAttribute(Constants.GAME_FORM_BEAN_NAME_KEY,
					formBeanName);

			if (svmForm.getSelectedEntryID() != null) {
				int entryID = Integer.parseInt(svmForm.getSelectedEntryID());
				log.info("editAssessment: selected entryID=" + entryID);
				session.setAttribute(Constants.SELECTED_ENTRYID_KEY, svmForm
						.getSelectedEntryID());
			}

			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward("edit_assessment");
	}

	private AssessmentInfo findAssessmentInfo(
			SubjectVisitManagementForm svmForm, String selectedAsName) {
		AssessmentInfo theAsi = null;
		for (AssessmentInfo asi : svmForm.getAssessmentInfosForCurrentSegment()) {
			if (asi.getName().equals(selectedAsName)) {
				theAsi = asi;
				break;
			}
		}
		return theAsi;
	}

	private void cleanupOldGAMEFormBeans(ActionMapping mapping,
			HttpSession session, SegmentManagementHelper smHelper) {
		List<String> prevFormBeans = smHelper.findGAMEFormBeansInSession(
				mapping, session);
		for (String pfbn : prevFormBeans) {
			session.removeAttribute(pfbn);
		}
	}

	public ActionForward deleteAssessment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info("deleteAssessment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String selectedAsName = svmForm.getSelectedAsNameForEdit();

			AssessmentInfo theAsi = null;
			for (AssessmentInfo asi : svmForm
					.getAssessmentInfosForCurrentSegment()) {
				if (asi.getName().equals(selectedAsName)) {
					theAsi = asi;
					break;
				}
			}
			log.info("selectedAsName=" + selectedAsName);
			String subjectID = svmForm.getSelectedSubjectID();
			int expID = svmForm.getCurrentVisit().getVisit().getExperimentID();
			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);

			isvm.deleteAssessmentFromSegment(ui, subjectID,
					theAsi.getVisitID(), theAsi.getSegmentID(), expID, theAsi
							.getAssessmentID());

			svmForm.removeFromCurrentAsInfos(theAsi);

			// update EditableAsSelDropdown
			ISubjectAssessmentManagement isam = ServiceFactory
					.getSubjectAssessmentManagement(dbID);
			List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(ui,
					subjectID, expID);
			SubjectManagementHelper.prepareEditableAsSelDropdown(session, ui,
					dbID, svmForm, asiList);

			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();
		} catch (Exception x) {
			svmForm.resetAssessments();
			log.error("", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward addAssessment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("addAssessment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			int entryID = -1;
			if ((svmForm.getSelectedEntryID() != null)
					&& (svmForm.getSelectedEntryID().length() >= 1)) {
				entryID = Integer.parseInt(svmForm.getSelectedEntryID());
				session.setAttribute(Constants.SELECTED_ENTRYID_KEY, svmForm
						.getSelectedEntryID());
			}

			String selectedAsName = null;
			if (entryID < 0) {
				AssessmentSelector selector = svmForm
						.getEditableAssessmentSelector();
				selectedAsName = selector.getAssessmentsToEdit(selector
						.getSelectedAssessmentIdx());
				if (log.isDebugEnabled()) {
					log.debug("selector.getSelectedAssessmentIdx()="
							+ selector.getSelectedAssessmentIdx()
							+ " selectedAsName=" + selectedAsName);
				}
			} else {
				// for other than first entry
				selectedAsName = svmForm.getSelectedAsNameForEdit();
			}

			ISecurityService ss = ServiceFactory.getSecurityService();
			String siteID = ss.findSiteIDByDbID(dbID);
			String assessmentID = findAssessmentID(ui, selectedAsName, siteID);

			SegmentManagementHelper smHelper = new SegmentManagementHelper();
			String formBeanClassName = smHelper
					.findFormBeanClassName(selectedAsName);
			log.info("formBeanClassName=" + formBeanClassName);

			ActionForm asForm = smHelper.createFormBean(formBeanClassName);

			smHelper.setProperty("setAssessmentID", assessmentID, asForm);
			smHelper.setProperty("setSubjectID",
					svmForm.getSelectedSubjectID(), asForm);
			smHelper.setProperty("setSegmentID",
					svmForm.getSelectedSegmentID(), asForm);
			smHelper.setProperty("setVisitID", svmForm.getSelectedVisitID(),
					asForm);
			smHelper.setProperty("setExperimentID", String.valueOf(svmForm
					.getCurrentVisit().getVisit().getExperimentID()), asForm);

			String formBeanName = smHelper.findFormBeanName(mapping,
					formBeanClassName);
			log.info("formBeanName=" + formBeanName);
			log.info(" actionForm=" + asForm);

			log.info("*** populating dynamic dropdowns");
			// populate the dynamic dropdown(s)
			populateDynamicDropdowns(ui, dbID, asForm);

			// cleanup old GAME form beans in session (if any)
			cleanupOldGAMEFormBeans(mapping, session, smHelper);

			session.setAttribute(formBeanName, asForm);
			session.setAttribute(Constants.GAME_FORM_BEAN_NAME_KEY,
					formBeanName);

			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();
		} catch (Exception x) {
			svmForm.resetAssessments();
			log.error("", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward("add_assessment");
	}

	private void populateDynamicDropdowns(UserInfo ui, String dbID,
			ActionForm asForm) throws BaseException, InvocationTargetException,
			IllegalAccessException, IntrospectionException {
		Class<? extends ActionForm> formClazz = asForm.getClass();
		AssessmentManagementHelper amh = AssessmentManagementHelper
				.getInstance();
		if (amh.hasFormProperty(Constants.CLINICALRATER_PROPERTY, asForm,
				formClazz)) {
			Object crValue = amh.getFormProperty(
					Constants.CLINICALRATER_PROPERTY, asForm, formClazz);
			if (crValue == null) {
				// prepare the dynamic dropdown
				Map<String, String> mdMap = amh.getMandatoryFieldMetaData(
						Constants.CLINICALRATER_PROPERTY, formClazz);
				if (mdMap != null
						&& mdMap.get(Constants.QUERY_PROPERTY) != null) {
					ISubjectAssessmentManagement isam = ServiceFactory
							.getSubjectAssessmentManagement(dbID);
					String sqlQuery = (String) mdMap
							.get(Constants.QUERY_PROPERTY);
					List<String> values = isam.getDynamicQueryResults(ui,
							sqlQuery);
					DynamicDropDownSelector dddSelector = new DynamicDropDownSelector(
							values);
					amh.setFormProperty(Constants.CLINICALRATER_PROPERTY,
							asForm, formClazz, dddSelector);
				}
			}
		}
	}

	private String findAssessmentID(UserInfo ui, String selectedAsName,
			String siteID) throws Exception {
		String assessmentID = "";
		IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
		List<Assessment> assessments = rds.getAllAssessments(siteID);
		for (Assessment as : assessments) {
			if (as.getName().equals(selectedAsName)) {
				return as.getAssessmentid().toString();
			}
		}
		return assessmentID;
	}

	public ActionForward showEditSegment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showEditSegment");
		try {
			getUserInfo(request);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;

			svmForm.setCurrentAction(Constants.EDIT_SEGMENT);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.EDIT_SEGMENT);
	}

	public ActionForward editSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editSegment (SegmentManagementAction)");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			StudyFormInfo studyFI = svmForm.getCurrentStudy();
			SegmentFormInfo sfi = svmForm.getCurrentSegment();
			int selectedSegmentID = -1;
			int visitIDForSelectedSegment = -1;
			if (studyFI != null) {
				isvm.updateStudySegmentForSubject(ui, sfi.getStudySegment());
				selectedSegmentID = sfi.getStudySegment().getSegmentID();
				visitIDForSelectedSegment = sfi.getStudySegment().getVisitID();
			} else {
				isvm.updateVisitSegmentForSubject(ui, sfi.getVisitSegment());
				selectedSegmentID = sfi.getVisitSegment().getSegmentID();
				visitIDForSelectedSegment = sfi.getVisitSegment().getVisitID();
			}

			SubjectManagementHelper.prepareCurrentSubjectAndVisit(dbID, ui,
					svmForm.getSelectedSubjectID(), visitIDForSelectedSegment,
					selectedSegmentID, svmForm);

			// also sets the current selected segment ID
			SubjectManagementHelper.prepareSegmentTimestampList(svmForm,
					selectedSegmentID);

			svmForm.setCurrentAsInfos();
			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();

		} catch (Exception x) {
			log.error("editSegment", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.EDIT_SEGMENT);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward showAddSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showAddSegment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			getUserInfo(request);
			VisitFormInfo vfi = svmForm.getCurrentVisit();
			StudyFormInfo studyFI = svmForm.getCurrentStudy();
			List<Protocol> protocols = svmForm.getProtocols();
			Object[] protocolNameVersions = SubjectManagementHelper
					.getProtocolNameVersions(protocols);

			if (studyFI != null) {
				StudySegment ss = new StudySegment();
				// also set the experiment id on visitSegment
				SubjectManagementHelper.setExperimentIDForStudySegment(svmForm,
						ss);
				ss.setSubjectID(svmForm.getSubject().getSubjectID());
				ss.setVisitID(vfi.getVisit().getComponentID());
				ss.setTimeStamp(vfi.getVisit().getTs());
				// set the study ID also
				ss.setStudyID(studyFI.getStudy().getStudyID());
				SegmentFormInfo sfi = new SegmentFormInfo(ss,
						(String[]) protocolNameVersions[0],
						(int[]) protocolNameVersions[1], svmForm);
				studyFI.addSegmentFormInfo(sfi);
				studyFI.getStudy().addStudySegment(ss);
			} else {
				VisitSegment vs = new VisitSegment();
				// also set the experiment id on visitSegment
				SubjectManagementHelper.setExperimentIDForVisitSegment(svmForm,
						vs);
				vs.setSubjectID(svmForm.getSubject().getSubjectID());
				vs.setVisitID(vfi.getVisit().getComponentID());
				vs.setTimeStamp(vfi.getVisit().getTs());

				SegmentFormInfo sfi = new SegmentFormInfo(vs,
						(String[]) protocolNameVersions[0],
						(int[]) protocolNameVersions[1], svmForm);

				vfi.getVisit().addVisitSegment(vs);
				vfi.addSegmentFormInfo(sfi);
			}
			svmForm.setSelectedSegmentID(null);
			svmForm.setCurrentAction(Constants.ADD_SEGMENT);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.ADD_SEGMENT);
	}

	public ActionForward addSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addSegment");
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		ISubjectVisitManagement isvm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isvm = ServiceFactory.getSubjectVisitManagement(dbID);
			StudyFormInfo studyFI = svmForm.getCurrentStudy();
			int segmentExpID = -1;
			int curVisitID = -1;

			if (studyFI != null) {
				StudySegment ss = svmForm.getCurrentSegment().getStudySegment();
				log.info("*** addSegment " + ss.toExpSegment().toString());
				int newSegmentID = isvm.addStudySegmentForSubject(ui, ss);
				svmForm.setSelectedSegmentID(String.valueOf(newSegmentID));
				segmentExpID = ss.getExperimentID();
				curVisitID = ss.getVisitID();
			} else {
				VisitSegment vs = svmForm.getCurrentSegment().getVisitSegment();
				log.info("*** addSegment " + vs.toExpSegment().toString());
				int newSegmentID = isvm.addVisitSegmentForSubject(ui, vs);
				svmForm.setSelectedSegmentID(String.valueOf(newSegmentID));
				segmentExpID = vs.getExperimentID();
				curVisitID = vs.getVisitID();
			}

			SubjectManagementHelper.prepareCurrentSubject(dbID, ui, svmForm
					.getSelectedSubjectID(), svmForm, segmentExpID, curVisitID);

			SubjectManagementHelper.prepareSegmentTimestampList(svmForm);

			// update EditableAsSelDropdown
			ISubjectAssessmentManagement isam = ServiceFactory
					.getSubjectAssessmentManagement(dbID);
			List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(ui,
					svmForm.getSelectedSubjectID(), segmentExpID);
			SubjectManagementHelper.prepareEditableAsSelDropdown(session, ui,
					dbID, svmForm, asiList);

			svmForm.setCurrentAsInfos();
			// necessary since the dispatcher action uses svmForm as its form
			svmForm.resetAssessments();

		} catch (Exception x) {
			log.error("addSegment", x);
			return processExceptions(request, response, mapping, form, x,
					Constants.ADD_SEGMENT);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward changeSegment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeSegment");
		HttpSession session = request.getSession(false);
		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			log.info("First **** ----------------------------");
			log.info(">> svmForm=" + svmForm);
			log.info(">> visit " + svmForm.getCurrentVisit());
			log.info(">> segmentFormInfos="
					+ svmForm.getCurrentVisit().getSegmentFormInfos());

			log.info("END First **** ----------------------------");
			String segmentID = svmForm.getSelectedSegmentID();
			log.info("selected segment ID:" + segmentID);

			String tsValue = svmForm.getSegTimestampSelector()
					.getMatchingTimeStamp(segmentID);
			svmForm.setSegmentTimestampValue(tsValue);

			int experimentID = -1;
			StudyFormInfo studyFI = svmForm.getCurrentStudy();

			// retrieves the selected segment as the current segment
			SegmentFormInfo sfi = svmForm.getCurrentSegment();
			if (studyFI != null) {
				StudySegment ss = sfi.getStudySegment();
				experimentID = ss.getExperimentID();
				sfi.setDate(DateTimeUtils.formatTimestampToDate(ss
						.getTimeStamp()));
				sfi.setTime(DateTimeUtils.extractTimePart(ss.getTimeStamp()));

				sfi.setDescription(ss.getDescription());

				String protocolValue = SubjectManagementHelper
						.getProtocolValue(svmForm.getProtocols(), ss
								.getProtocolID(), ss.getProtocolVersion());
				sfi.setProtocolValue(protocolValue);

				
			} else {
				VisitSegment vs = sfi.getVisitSegment();
				experimentID = vs.getExperimentID();
				sfi.setDate(DateTimeUtils.formatTimestampToDate(vs
						.getTimeStamp()));
				sfi.setTime(DateTimeUtils.extractTimePart(vs.getTimeStamp()));

				sfi.setDescription(vs.getDescription());

				String protocolValue = SubjectManagementHelper
						.getProtocolValue(svmForm.getProtocols(), vs
								.getProtocolID(), vs.getProtocolVersion());
				sfi.setProtocolValue(protocolValue);
			}

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISubjectAssessmentManagement isam = null;
			isam = ServiceFactory.getSubjectAssessmentManagement(dbID);

			List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(ui,
					svmForm.getSelectedSubjectID(), experimentID);

			SubjectManagementHelper.prepareEditableAsSelDropdown(session, ui,
					dbID, svmForm, asiList);

			log.info("changeSegment: " + sfi.toString());
			log.info("changeSegment:>> "
					+ svmForm.getCurrentVisit().getVisit().toExpComponent()
							.toString());
			svmForm.setCurrentAsInfos();
			svmForm.resetAssessments();
			svmForm.setSelectedEntryID(null);
			// prepare reconciliation status map
			SubjectManagementHelper.prepareReconStatsMap(ui, dbID, asiList,
					svmForm);
			// prepare entry count map for the selected segment
			Map<String, Integer> entryCountMap = SubjectManagementHelper
					.prepareEntryCountMap(ui, dbID, asiList, svmForm);
			svmForm.setEntryMap(entryCountMap);
		} catch (Exception x) {
			log.error("changeSegment", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward changeVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeVisit");

		SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			Subject subject = svmForm.getSubject();

			VisitFormInfo oldVfi = svmForm.getCurrentVisit();
			int selExpID = oldVfi.getVisit().getExperimentID();

			int newVisitID = Integer.parseInt(svmForm.getSelectedVisitID());
			Visit newVisit = subject.findVisit(newVisitID, selExpID);
			log.info("newVisit=" + newVisit);

			svmForm.setVisitDateValue(newVisit.getComponentIDAsString());

			VisitFormInfo vfi = new VisitFormInfo(newVisit, oldVfi
					.getExperimentNamesAsArray(),
					oldVfi.getVisitTypesAsArray(), svmForm);

			List<Protocol> protocols = svmForm.getProtocols();
			Object[] protocolNameVersions = SubjectManagementHelper
					.getProtocolNameVersions(protocols);

			for (VisitSegment vs : newVisit.getVisitSegments()) {
				log.info("adding visitsegment " + vs);
				SegmentFormInfo sfi = new SegmentFormInfo(vs,
						(String[]) protocolNameVersions[0],
						(int[]) protocolNameVersions[1], svmForm);
				String protocolValue = SubjectManagementHelper
						.getProtocolValue(protocols, vs.getProtocolID(), vs
								.getProtocolVersion());

				sfi.setProtocolValue(protocolValue);
				vfi.addSegmentFormInfo(sfi);
			}
			// add to the visit segmentforminfos for the studies also

			svmForm.setCurrentVisit(vfi);
			svmForm.setSelectedVisitID(String.valueOf(vfi.getVisit()
					.getComponentID()));

			// prepare the segment time stamp
			SubjectManagementHelper.prepareSegmentTimestampList(svmForm);

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			// prepare editable assessment selection dropdown
			int experimentID = newVisit.getExperimentID();
			ISubjectAssessmentManagement isam = null;
			isam = ServiceFactory.getSubjectAssessmentManagement(dbID);

			List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(ui,
					svmForm.getSelectedSubjectID(), experimentID);

			SubjectManagementHelper.prepareEditableAsSelDropdown(session, ui,
					dbID, svmForm, asiList);
			Map<String,Integer> entryCountMap = SubjectManagementHelper.prepareEntryCountMap(
					ui, dbID, asiList, svmForm);
			svmForm.setEntryMap(entryCountMap);

			svmForm.setCurrentAsInfos();
			svmForm.resetAssessments();
			svmForm.setSelectedStudyID(null);

			log.info(">> end of changeVisit");
		} catch (Exception x) {
			log.error("changeVisit", x);
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

}
