package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 * Allows/hides the subject visit assessment information detail.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitDetailAction.java,v 1.6 2005/09/09 01:47:39 bozyurt
 *          Exp $
 */
public class SubjectVisitDetailAction extends BaseLookupDispatchAction {
	private Log log = LogFactory.getLog("clinical");
	protected Map<String, String> map = new HashMap<String, String>(3);

	public SubjectVisitDetailAction() {
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.show_detail", "showDetail");
		map.put("button.hide_detail", "hideDetail");
		return map;
	}

	public ActionForward showDetail(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("action: showDetail");
		try {
			getUserInfo(request);

			SubjectVisitForm svForm = (SubjectVisitForm) form;
			// reset the assessment iteration counters
			resetAssessmentCounters(svForm.getClinicalVisits());
			resetAssessmentCounters(svForm.getScanVisits());
			// simply set the showDetail flag, since the data is already
			// retrieved
			svForm.setShowDetail(true);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void resetAssessmentCounters(List<Visit> visits) {
		for (Visit v  : visits) {
			for (VisitSegment vs : v.getVisitSegments()) {
				vs.resetAssessments();
			}
		}
	}

	public ActionForward hideDetail(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("action: hideDetail");
		try {
			getUserInfo(request);

			SubjectVisitForm svForm = (SubjectVisitForm) form;
			// reset the assessment iteration counters
			resetAssessmentCounters(svForm.getClinicalVisits());
			resetAssessmentCounters(svForm.getScanVisits());

			// simply set the showDetail flag to indicate hiding of the detail
			// data
			svForm.setShowDetail(false);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

}
