package clinical.web.actions;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.dao.SchemaversionDAO;
import clinical.server.vo.Schemaversion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.security.DBConfig;

/**
 * 
 * @author Karen R. Pease
 * @author I. Burak Ozyurt
 * @version $Id: VersionCheckAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class VersionCheckAction extends BaseAction {
	private Log log = LogFactory.getLog(VersionCheckAction.class);

	public VersionCheckAction() {
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		Connection con = null;
		IDBPoolService pool = null;
		try {
			log.info("in VersionCheckAction");
			ISecurityService secScervice = ServiceFactory.getSecurityService();
			String dbID = secScervice.getDefaultDBID();
			log.info("dbID=" + dbID + " dbType=" + secScervice.getDBType(dbID));

			if (secScervice.getDBType(dbID).equals(DBConfig.POSTGRES)) {
				// no postgres version checking support yet IBO
				return mapping.findForward(Constants.SUCCESS);
			}
			
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			String value = configService
					.getParamValue(Constants.DO_SCHEMA_VERSION_CHECK);
			boolean versionCheck = GenUtils.toBoolean(value, true);
			if (!versionCheck) {
				log.info("Bypassing schema version checking...");
				// configured to not check for schema version
				return mapping.findForward(Constants.SUCCESS);
			}

			// Figure out what versions we need.

			// Establish a connection
			pool = ServiceFactory.getPoolService(dbID);

			con = pool.getConnection(Constants.ADMIN_USER);

			// To create a transparent DAO for nc_schemaversion table and return
			// an interface
			SchemaversionDAO svDAO = DAOFactory.createSchemaversionDAO(dbID);

			// Build a query criteria to get the record(s) having the user class
			// 'Database Version'
			Schemaversion cr = new Schemaversion();

			// Get the records (implicitly querying the db)
			List<Schemaversion> svList = svDAO.find(con, cr);

			int minNeededMajorVersion = GenUtils.toInt(configService
					.getParamValue(Constants.MIN_NEEDED_MAJOR_VERSION), -1);
			int minNeededMinorVersion = GenUtils.toInt(configService
					.getParamValue(Constants.MIN_NEEDED_MINOR_VERSION), -1);
			int maxNeededMajorVersion = GenUtils.toInt(configService
					.getParamValue(Constants.MAX_NEEDED_MAJOR_VERSION), -1);
			int maxNeededMinorVersion = GenUtils.toInt(configService
					.getParamValue(Constants.MAX_NEEDED_MINOR_VERSION), -1);

			// Find the most recent record.
			int max_majorVersion = 0;
			int max_minorVersion = 0;
			for (Iterator<?> iter = svList.iterator(); iter.hasNext();) {
				Schemaversion val = (Schemaversion) iter.next();
				int majorVersion = val.getMajorversion().intValue();
				int minorVersion = val.getMinorversion().intValue();
				boolean updateFinished = val.getUpdatefinished().booleanValue();
				//System.out.println("" + minorVersion);
				//System.out.println("" + majorVersion);

				if (updateFinished) {
					if ((majorVersion > max_majorVersion)
							|| ((majorVersion == max_majorVersion) && (minorVersion > max_minorVersion))) {
						max_majorVersion = majorVersion;
						max_minorVersion = minorVersion;
					}
				}
			}

			if (((max_majorVersion > minNeededMajorVersion) || ((max_majorVersion == minNeededMajorVersion) && (max_minorVersion >= minNeededMinorVersion)))
					&& ((max_majorVersion < maxNeededMajorVersion) || ((max_majorVersion == maxNeededMajorVersion) && (max_minorVersion <= maxNeededMinorVersion)))) {
				return mapping.findForward(Constants.SUCCESS);
			} else {
				return mapping.findForward(Constants.FAILURE);
			}
		} catch (Exception x) {
			System.out.println("Exception");
			return processExceptions(request, response, mapping, form, x);
		} finally {
			if (pool != null && con != null) {
				pool.releaseConnection(Constants.ADMIN_USER, con);
			}
		}
	}

}
