package clinical.web.common.query;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

/**
 * Generic SQL query builder and processor for single table queries. It relies
 * on the one-to-one relationship between a value object and its corresponding
 * table. <code>QueryProcessor</code> requires a search predicate list and the
 * class type of the value object for which a query will be build and sent to
 * the database server.
 * <p>
 * QueryProcessor internally converts from the value object property names to
 * the corresponding database table column names and vice versa. To accomplish
 * this, it keeps a static cache of all database table column names which needs
 * to be initialized during the application startup.
 * <p>
 * The search predicate list is used to build the <i>where</i> clause of the
 * SQL query.
 * 
 * 
 * @author I. Burak Ozyurt
 * @version $Id: IQueryProcessor.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public interface IQueryProcessor {

	/**
	 * 
	 * @return The SQL query built based on the search predicate list and the
	 *         value object class info
	 * @throws java.lang.Exception
	 */
	public String buildQuery(String dbType) throws Exception;

	public List<?> doQuery(Connection con, String query) throws SQLException,
			InstantiationException, IllegalAccessException,
			InvocationTargetException;

}
