package clinical.web.common.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Assessment;
import clinical.web.IAssessmentService;
import clinical.web.IDerivedDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.AssessmentMapping;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.helpers.SubCorticalVarInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MediatedQueryWorker.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MediatedQueryWorker implements Runnable {
	public final static int NONE = 0;
	public final static int STARTED = 1;
	public final static int FINISHED = 2;
	public final static int ERROR = 3;
	public final static int ASSESSMENT_QUERY = 1;
	public final static int SUBCORTICAL_QUERY = 2;
	public final static int ASSESSMENT_NAMES_QUERY = 3;
	public final static int SCORE_NAMES_QUERY = 4;

	protected int status = NONE;
	protected String id;
	String dbID;
	protected String query;
	protected int queryType;
	protected BaseException be;
	protected List<Object> argList = new ArrayList<Object>();
	protected Object result;
	protected Object lock = new Object();
	private static Log log = LogFactory.getLog("MediatedQueryWorker");

	public MediatedQueryWorker(String id, int queryType, String dbID) {
		this.id = id;
		this.queryType = queryType;
		this.dbID = dbID;
	}

	public String getID() {
		return id;
	}

	public synchronized int getStatus() {
		return status;
	}

	private synchronized void setStatus(int value) {
		this.status = value;
	}

	public int getQueryType() {
		return queryType;
	}

	public Object getLock() {
		return lock;
	}

	public void addArgument(Object arg) {
		argList.add(arg);
	}

	public synchronized Object getResult() {
		return result;
	}

	public BaseException getException() {
		return be;
	}

	@SuppressWarnings("unchecked")
   public void run() {
		log.info("started worker" + id);
		setStatus(STARTED);


		try {
			IAssessmentService asService = ServiceFactory.getAssessmentService(dbID);
			IDerivedDataService ddService = ServiceFactory.getDerivedDataService(dbID);
			switch (queryType) {
			case ASSESSMENT_QUERY:
				result = asService.queryMediatorForScores((Operator) argList
						.get(0),
						(List<AssessmentSelectionInfo>) argList.get(1),
						(Map<Integer, List<AssessmentMapping>>) argList.get(2));

				break;
			case ASSESSMENT_NAMES_QUERY:
				result = asService.getAssessmentsFromMediator((String) argList
						.get(0), (String) argList.get(1),
						(List<Assessment>) argList.get(2));
				break;
			case SCORE_NAMES_QUERY:
				result = asService.getAssessmentScoresFromMediator(
						(String) argList.get(0), (String) argList.get(1),
						(List<Assessment>) argList.get(2));
				break;
			case SUBCORTICAL_QUERY:
				log.info("doing subcortical " + id);
				result = ddService.getMediatedSubCorticalValues(
						(List<SubCorticalVarInfo>) argList.get(0),
						(Operator) argList.get(1));
				break;
			default:
				break;
			}
			setStatus(FINISHED);
			synchronized (lock) {
				lock.notifyAll();
			}
		} catch (Exception x) {
			setStatus(ERROR);
			be = new BaseException(x);
		}
	}

	public static void main(String[] args) {
		// String query = "query.qa2(ASSESSMENTID, NAME) :-
		// (view.nc_assessment_view(ASSESSMENTID,TABLEID,OWNER,MODTIME,MODUSER,NAME,DESCRIPTION))";
		Thread t = new Thread(new MediatedQueryWorker("test1",
				MediatedQueryWorker.ASSESSMENT_QUERY,"ucsd_fbirn"));

		t.setDaemon(true);
		t.start();
		try {
			t.join();
		} catch (InterruptedException ie) {
		}
	}

}