package clinical.web.common.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;

import clinical.utils.Assertion;
import clinical.web.ISQLDialect;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PostgresSQLDialect.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class PostgresSQLDialect implements ISQLDialect {
	public PostgresSQLDialect() {
	}

	/**
	 * prepareSchemaObjectName
	 *
	 * @param schemaObjName
	 *            String
	 * @return String
	 */
	public String prepareSchemaObjectName(String schemaObjName) {
		return schemaObjName;
	}

	/**
	 * prepareString
	 *
	 * @param value
	 *            String
	 * @return String
	 */
	public String prepareString(String value) {
		StringBuffer buf = new StringBuffer();
		value = escapeQuotes(value);
		buf.append("'").append(value).append("'");
		return buf.toString();
	}

	public static String escapeQuotes(String str) {
		if (str == null) {
			return str;
		}
		if (str.indexOf('\'') != -1) {
			str = str.replaceAll("'", "\\'");
		}
		if (str.indexOf('"') != -1) {
			str = str.replaceAll("\"", "\\\"");
		}

		return str;
	}

	/**
	 * prepareBooleanPredicate
	 *
	 * @param prefix
	 *            String
	 * @param value
	 *            boolean
	 * @return String
	 */
	public String prepareBooleanPredicate(String prefix, boolean value) {
		StringBuffer buf = new StringBuffer();
		buf.append(prefix).append(' ').append(value ? "true" : "false");
		return buf.toString();
	}

	public String prepareBooleanValue(Boolean value) {
		return (value.booleanValue()) ? "true" : "false";
	}

	public String getDialectName() {
		return "PostgresDialect";
	}

	public void invokeSetter(Method m, Object vo, Object value, int colType)
			throws InvocationTargetException, IllegalArgumentException,
			IllegalAccessException {
		if (value != null && value instanceof Long) {
			m.invoke(vo, new Object[] { new BigDecimal(value.toString()) });
		} else {
			m.invoke(vo, new Object[] { value });
		}
	}

	public String endsWithFunction(String schemaColName, String suffix) {
		Assertion.assertNotNull(suffix);
		String colName = prepareSchemaObjectName(schemaColName);

		StringBuilder sb = new StringBuilder(50);
		sb.append("substring(").append(colName).append(" from char_length(");
		sb.append(colName).append(") - ").append(suffix.length() - 1);
		sb.append(" for ").append(suffix.length()).append(") = ");
		sb.append(prepareString(suffix));
		return sb.toString();
	}
}
